/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.model;

import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteStatement;
import android.util.Log;
import cm.aptoide.ptdev.Aptoide;
import cm.aptoide.ptdev.database.Database;
import cm.aptoide.ptdev.database.StatementHelper;
import cm.aptoide.ptdev.database.schema.Schema;
import cm.aptoide.ptdev.model.Apk;
import cm.aptoide.ptdev.utils.AptoideUtils;
import cm.aptoide.ptdev.utils.Filters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ApkInfoXML
extends Apk {
    @Override
    public void databaseDelete(Database database) {
        database.deleteApk(this.getPackageName(), this.getVersionCode(), this.getRepoId());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void databaseInsert(List<SQLiteStatement> list, HashMap<Integer, Integer> hashMap) {
        long l2;
        try {
            long l3;
            SQLiteStatement sQLiteStatement = list.get(0);
            String[] stringArray = new String[18];
            stringArray[0] = this.getPackageName();
            stringArray[1] = this.getName();
            stringArray[2] = String.valueOf(this.getVersionCode());
            stringArray[3] = String.valueOf(this.getVersionName());
            stringArray[4] = String.valueOf(this.getRepoId());
            stringArray[5] = String.valueOf(this.getDate().getTime());
            stringArray[6] = String.valueOf(this.getDownloads());
            stringArray[7] = String.valueOf(this.getRating());
            int n2 = this.getAge().equals((Object)Filters.Age.Mature) ? 1 : 0;
            stringArray[8] = String.valueOf(n2);
            stringArray[9] = String.valueOf(this.getMinSdk());
            stringArray[10] = String.valueOf((Object)this.getMinScreen());
            stringArray[11] = this.getMinGlEs();
            stringArray[12] = this.getIconPath();
            int n3 = AptoideUtils.isCompatible(this) ? 1 : 0;
            stringArray[13] = String.valueOf(n3);
            stringArray[14] = this.getSignature();
            stringArray[15] = this.getPath();
            stringArray[16] = this.getMd5h();
            stringArray[17] = String.valueOf(this.getPrice());
            StatementHelper.bindAllArgsAsStrings(sQLiteStatement, stringArray);
            l2 = l3 = list.get(0).executeInsert();
        }
        catch (SQLiteException sQLiteException) {
            Log.d((String)"RepoParser-ApkInfo-Insert", (String)("Conflict: " + sQLiteException.getMessage() + " on " + this.getPackageName() + " " + this.getRepoId() + " " + this.getVersionCode()));
            SQLiteStatement sQLiteStatement = list.get(3);
            String[] stringArray = new String[]{String.valueOf(this.getRepoId()), this.getPackageName(), String.valueOf(this.getVersionCode())};
            StatementHelper.bindAllArgsAsStrings(sQLiteStatement, stringArray);
            l2 = list.get(3).simpleQueryForLong();
        }
        if (Aptoide.getDb().yieldIfContendedSafely(1000L)) {
            Log.d((String)"RepoParser", (String)"yelded");
        }
        Iterator<Integer> iterator = this.getCategoryId().iterator();
        while (iterator.hasNext()) {
            Integer n4 = iterator.next();
            try {
                SQLiteStatement sQLiteStatement = list.get(2);
                String[] stringArray = new String[]{String.valueOf(l2), String.valueOf(n4), String.valueOf(this.getRepoId())};
                StatementHelper.bindAllArgsAsStrings(sQLiteStatement, stringArray);
                list.get(2).executeInsert();
            }
            catch (SQLiteException sQLiteException) {
                sQLiteException.printStackTrace();
            }
            if (!Aptoide.getDb().yieldIfContendedSafely(1000L)) continue;
            Log.d((String)"RepoParser", (String)"yelded");
        }
        return;
    }

    @Override
    public List<String> getStatements() {
        ArrayList<String> arrayList = new ArrayList<String>(10);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("package_name");
        arrayList2.add("name");
        arrayList2.add("version_code");
        arrayList2.add("version_name");
        arrayList2.add("id_repo");
        arrayList2.add("date");
        arrayList2.add("downloads");
        arrayList2.add("rating");
        arrayList2.add("mature");
        arrayList2.add("sdk");
        arrayList2.add("screen");
        arrayList2.add("gles");
        arrayList2.add("icon");
        arrayList2.add("is_compatible");
        arrayList2.add("signature");
        arrayList2.add("path");
        arrayList2.add("md5");
        arrayList2.add("price");
        arrayList.add(0, StatementHelper.getInsertStatment(Schema.Apk.getName(), arrayList2));
        arrayList2.add("name");
        arrayList2.add("id_repo");
        arrayList2.add("id_category_parent");
        arrayList.add(1, StatementHelper.getInsertStatment(Schema.Category.getName(), arrayList2));
        arrayList2.add("id_apk");
        arrayList2.add("id_real_category");
        arrayList2.add("id_repo");
        arrayList.add(2, StatementHelper.getInsertStatment(Schema.Category_Apk.getName(), arrayList2));
        arrayList.add(3, "select id_apk from apk where id_repo = ? and package_name = ? and version_code = ?");
        return arrayList;
    }
}

