/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.fragments;

import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.os.Bundle;
import android.support.v4.app.ListFragment;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import cm.aptoide.ptdev.AppViewActivity;
import cm.aptoide.ptdev.Aptoide;
import cm.aptoide.ptdev.R;
import cm.aptoide.ptdev.database.Database;
import cm.aptoide.ptdev.fragments.FragmentStore;
import cm.aptoide.ptdev.services.HttpClientSpiceService;
import cm.aptoide.ptdev.utils.AptoideUtils;
import cm.aptoide.ptdev.webservices.ListRepositoryLikesRequest;
import cm.aptoide.ptdev.webservices.json.RepositoryLikesJson;
import com.octo.android.robospice.SpiceManager;
import com.octo.android.robospice.persistence.exception.SpiceException;
import com.octo.android.robospice.request.listener.RequestListener;
import java.util.List;

public class LatestLikesFragment
extends ListFragment
implements FragmentStore {
    private String repoName;
    RequestListener<RepositoryLikesJson> request;
    SpiceManager spiceManager = new SpiceManager(HttpClientSpiceService.class);

    public LatestLikesFragment() {
        this.request = new RequestListener<RepositoryLikesJson>(){

            @Override
            public void onRequestFailure(SpiceException spiceException) {
            }

            @Override
            public void onRequestSuccess(RepositoryLikesJson repositoryLikesJson) {
                LatestLikesFragment.this.setListAdapter((ListAdapter)new LikesAdapter((Context)LatestLikesFragment.this.getActivity(), repositoryLikesJson.getListing()));
            }
        };
    }

    @Override
    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        View view = super.onCreateView(layoutInflater, viewGroup, bundle);
        Cursor cursor = new Database(Aptoide.getDb()).getStore(this.getArguments().getLong("storeid"));
        this.repoName = null;
        if (cursor.moveToFirst()) {
            this.repoName = cursor.getString(cursor.getColumnIndex("name"));
            if (this.repoName == null) {
                this.repoName = AptoideUtils.RepoUtils.split(cursor.getString(cursor.getColumnIndex("url")));
            }
        }
        cursor.close();
        ListRepositoryLikesRequest listRepositoryLikesRequest = new ListRepositoryLikesRequest(this.repoName);
        Log.d((String)"FragmentRelated", (String)"onCreateView");
        this.spiceManager.execute(listRepositoryLikesRequest, this.repoName + "-latestLikes", 86400000L, this.request);
        return view;
    }

    @Override
    public void onError() {
    }

    @Override
    public void onListItemClick(ListView listView, View view, int n2, long l2) {
        super.onListItemClick(listView, view, n2, l2);
        RepositoryLikesJson.Listing listing = (RepositoryLikesJson.Listing)listView.getItemAtPosition(n2);
        long l3 = new Database(Aptoide.getDb()).getApkFromPackage(listing.getApkid(), this.repoName);
        if (l3 > 0L) {
            Intent intent = new Intent((Context)this.getActivity(), AppViewActivity.class);
            intent.putExtra("id", l3);
            this.startActivity(intent);
        }
    }

    @Override
    public void onRefresh() {
    }

    @Override
    public void onStart() {
        super.onStart();
        this.spiceManager.start((Context)this.getActivity());
    }

    @Override
    public void onStop() {
        super.onStop();
        if (this.spiceManager.isStarted()) {
            this.spiceManager.shouldStop();
        }
    }

    @Override
    public void onViewCreated(View view, Bundle bundle) {
        super.onViewCreated(view, bundle);
        this.getListView().setDivider(null);
        this.getListView().setCacheColorHint(this.getResources().getColor(17170445));
        Log.d((String)"FragmentRelated", (String)"onViewCreated");
    }

    @Override
    public void setRefreshing(boolean bl2) {
    }

    public class LikesAdapter
    extends ArrayAdapter<RepositoryLikesJson.Listing> {
        public LikesAdapter(Context context, List<RepositoryLikesJson.Listing> list) {
            super(context, 0, list);
        }

        /*
         * Enabled aggressive block sorting
         */
        public View getView(int n2, View view, ViewGroup viewGroup) {
            View view2 = view == null ? LayoutInflater.from((Context)LatestLikesFragment.this.getActivity()).inflate(R.layout.row_latest_likes, viewGroup, false) : view;
            TextView textView = (TextView)view2.findViewById(R.id.username);
            TextView textView2 = (TextView)view2.findViewById(R.id.app_name);
            TextView textView3 = (TextView)view2.findViewById(R.id.app_version);
            ImageView imageView = (ImageView)view2.findViewById(R.id.user_taste);
            textView.setText((CharSequence)((RepositoryLikesJson.Listing)this.getItem(n2)).getUsername());
            textView2.setText((CharSequence)((RepositoryLikesJson.Listing)this.getItem(n2)).getName());
            textView3.setText((CharSequence)((RepositoryLikesJson.Listing)this.getItem(n2)).getVer());
            if (Boolean.parseBoolean(((RepositoryLikesJson.Listing)this.getItem(n2)).getLike())) {
                imageView.setImageResource(R.drawable.like);
                return view2;
            }
            imageView.setImageResource(R.drawable.dont_like);
            return view2;
        }
    }
}

