/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.fragments;

import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.os.Bundle;
import android.support.v4.app.ListFragment;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import cm.aptoide.ptdev.AppViewActivity;
import cm.aptoide.ptdev.Aptoide;
import cm.aptoide.ptdev.R;
import cm.aptoide.ptdev.database.Database;
import cm.aptoide.ptdev.fragments.FragmentStore;
import cm.aptoide.ptdev.services.HttpClientSpiceService;
import cm.aptoide.ptdev.utils.AptoideUtils;
import cm.aptoide.ptdev.utils.Configs;
import cm.aptoide.ptdev.webservices.ListRepositoryCommentsRequest;
import cm.aptoide.ptdev.webservices.json.RepositoryCommentsJson;
import com.octo.android.robospice.SpiceManager;
import com.octo.android.robospice.persistence.exception.SpiceException;
import com.octo.android.robospice.request.listener.RequestListener;
import java.text.ParseException;
import java.util.Date;
import java.util.List;

public class LatestCommentsFragment
extends ListFragment
implements FragmentStore {
    private String repoName;
    RequestListener<RepositoryCommentsJson> request;
    SpiceManager spiceManager = new SpiceManager(HttpClientSpiceService.class);

    public LatestCommentsFragment() {
        this.request = new RequestListener<RepositoryCommentsJson>(){

            @Override
            public void onRequestFailure(SpiceException spiceException) {
                LatestCommentsFragment.this.setListShown(true);
                LatestCommentsFragment.this.setEmptyText(LatestCommentsFragment.this.getString(R.string.connection_error));
            }

            @Override
            public void onRequestSuccess(RepositoryCommentsJson repositoryCommentsJson) {
                if (repositoryCommentsJson != null) {
                    LatestCommentsFragment.this.setListAdapter((ListAdapter)new CommentsAdapter((Context)LatestCommentsFragment.this.getActivity(), repositoryCommentsJson.getListing()));
                    return;
                }
                LatestCommentsFragment.this.setListShown(true);
                LatestCommentsFragment.this.setEmptyText(LatestCommentsFragment.this.getString(R.string.error_occured));
            }
        };
    }

    @Override
    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        View view = super.onCreateView(layoutInflater, viewGroup, bundle);
        Cursor cursor = new Database(Aptoide.getDb()).getStore(this.getArguments().getLong("storeid"));
        this.repoName = null;
        if (cursor.moveToFirst()) {
            this.repoName = cursor.getString(cursor.getColumnIndex("name"));
            if (this.repoName == null) {
                this.repoName = AptoideUtils.RepoUtils.split(cursor.getString(cursor.getColumnIndex("url")));
            }
        }
        cursor.close();
        ListRepositoryCommentsRequest listRepositoryCommentsRequest = new ListRepositoryCommentsRequest(this.repoName);
        Log.d((String)"FragmentRelated", (String)"onCreateView");
        this.spiceManager.execute(listRepositoryCommentsRequest, this.repoName + "-latestComments", 86400000L, this.request);
        return view;
    }

    @Override
    public void onError() {
    }

    @Override
    public void onListItemClick(ListView listView, View view, int n2, long l2) {
        super.onListItemClick(listView, view, n2, l2);
        RepositoryCommentsJson.Listing listing = (RepositoryCommentsJson.Listing)listView.getItemAtPosition(n2);
        long l3 = new Database(Aptoide.getDb()).getApkFromPackage(listing.getApkid(), this.repoName);
        if (l3 > 0L) {
            Intent intent = new Intent((Context)this.getActivity(), AppViewActivity.class);
            intent.putExtra("id", l3);
            this.startActivity(intent);
        }
    }

    @Override
    public void onRefresh() {
    }

    @Override
    public void onStart() {
        super.onStart();
        this.spiceManager.start((Context)this.getActivity());
    }

    @Override
    public void onStop() {
        super.onStop();
        if (this.spiceManager.isStarted()) {
            this.spiceManager.shouldStop();
        }
    }

    @Override
    public void onViewCreated(View view, Bundle bundle) {
        super.onViewCreated(view, bundle);
        this.getListView().setDivider(null);
        this.getListView().setCacheColorHint(this.getResources().getColor(17170445));
        Log.d((String)"FragmentRelated", (String)"onViewCreated");
    }

    @Override
    public void setRefreshing(boolean bl2) {
    }

    public class CommentsAdapter
    extends ArrayAdapter<RepositoryCommentsJson.Listing> {
        public CommentsAdapter(Context context, List<RepositoryCommentsJson.Listing> list) {
            super(context, 0, list);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public View getView(int n2, View view, ViewGroup viewGroup) {
            View view2 = view == null ? LayoutInflater.from((Context)LatestCommentsFragment.this.getActivity()).inflate(R.layout.row_latest_comments, viewGroup, false) : view;
            RepositoryCommentsJson.Listing listing = (RepositoryCommentsJson.Listing)this.getItem(n2);
            TextView textView = (TextView)view2.findViewById(R.id.comment_app_name);
            TextView textView2 = (TextView)view2.findViewById(R.id.comment_time);
            TextView textView3 = (TextView)view2.findViewById(R.id.comment);
            TextView textView4 = (TextView)view2.findViewById(R.id.user_comment);
            textView.setText((CharSequence)listing.getName());
            textView3.setText((CharSequence)listing.getText());
            if (textView4.equals("NOT_SIGNED_UP")) {
                textView4.setText((CharSequence)"");
            } else {
                textView4.setText((CharSequence)listing.getUsername());
            }
            try {
                Date date = Configs.TIME_STAMP_FORMAT.parse(listing.getTimestamp());
                textView2.setText((CharSequence)AptoideUtils.DateDiffUtils.getDiffDate(this.getContext(), date));
                return view2;
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
                return view2;
            }
        }
    }
}

