/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.fragments;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.os.AsyncTask;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.support.v7.view.ActionMode;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.GridView;
import cm.aptoide.ptdev.Aptoide;
import cm.aptoide.ptdev.EnumStoreTheme;
import cm.aptoide.ptdev.R;
import cm.aptoide.ptdev.StoreActivity;
import cm.aptoide.ptdev.StoreItem;
import cm.aptoide.ptdev.adapters.StoreAdapter;
import cm.aptoide.ptdev.database.Database;
import cm.aptoide.ptdev.dialogs.AptoideDialog;
import cm.aptoide.ptdev.events.BusProvider;
import cm.aptoide.ptdev.events.RepoAddedEvent;
import cm.aptoide.ptdev.fragments.Callback;
import cm.aptoide.ptdev.fragments.callbacks.RepoCompleteEvent;
import cm.aptoide.ptdev.fragments.callbacks.StoresCallback;
import cm.aptoide.ptdev.parser.events.StopParseEvent;
import cm.aptoide.ptdev.utils.SimpleCursorLoader;
import com.squareup.otto.Subscribe;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class FragmentStores
extends Fragment
implements LoaderManager.LoaderCallbacks<Cursor>,
Callback {
    private StoresCallback callback;
    private StoresCallback dummyCallback = new StoresCallback(){

        @Override
        public boolean isRefreshing(long l2) {
            return false;
        }

        @Override
        public void reloadStores(Set<Long> set) {
        }

        @Override
        public void showAddStoreDialog() {
        }
    };
    private GridView gridViewMyStores;
    private boolean isMergeStore;
    private StoreAdapter storeAdapter;
    private ArrayList<StoreItem> stores = new ArrayList();

    private void removeStores(Set<Long> set) {
        this.setRetainInstance(true);
        new AsyncTask<Set<Long>, Void, Void>(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected Void doInBackground(Set<Long> ... setArray) {
                try {
                    for (Long l2 : setArray[0]) {
                        BusProvider.getInstance().post(new StopParseEvent(l2));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return null;
                }
                {
                    new Database(Aptoide.getDb()).removeStores(setArray[0]);
                    return null;
                }
            }

            protected void onPostExecute(Void void_) {
                super.onPostExecute((Object)void_);
                ((DialogFragment)FragmentStores.this.getFragmentManager().findFragmentByTag("pleaseWaitDialogRemove")).dismissAllowingStateLoss();
                FragmentStores.this.setRetainInstance(false);
                FragmentStores.this.getLoaderManager().restartLoader(0, null, FragmentStores.this);
                BusProvider.getInstance().post(new RepoCompleteEvent(0L));
            }

            protected void onPreExecute() {
                super.onPreExecute();
                DialogFragment dialogFragment = AptoideDialog.pleaseWaitDialog();
                dialogFragment.setCancelable(false);
                dialogFragment.show(FragmentStores.this.getFragmentManager(), "pleaseWaitDialogRemove");
            }
        }.execute((Object[])new Set[]{set});
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setMergeStore(boolean bl2) {
        this.isMergeStore = bl2;
        PreferenceManager.getDefaultSharedPreferences((Context)Aptoide.getContext()).edit().putBoolean("mergeStores", bl2).commit();
        if (bl2) {
            this.stores.clear();
            this.stores.add(new StoreItem(this.getString(R.string.all_stores), "", "drawable://" + R.drawable.avatar_apps, EnumStoreTheme.APTOIDE_STORE_THEME_ORANGE, false, -1L));
            this.storeAdapter.notifyDataSetChanged();
        } else {
            this.refreshStoresEvent(null);
        }
        this.getActivity().supportInvalidateOptionsMenu();
    }

    @Override
    public boolean onActionItemClicked(ActionMode actionMode, MenuItem menuItem) {
        int n2 = menuItem.getItemId();
        if (n2 == R.id.menu_reload) {
            HashSet<Long> hashSet = new HashSet<Long>();
            for (Long l2 : this.storeAdapter.getCheckedItems()) {
                hashSet.add(this.storeAdapter.getItemId(l2.intValue()));
            }
            actionMode.finish();
            this.callback.reloadStores(hashSet);
            return true;
        }
        if (n2 == R.id.menu_discard) {
            HashSet<Long> hashSet = new HashSet<Long>();
            for (Long l3 : this.storeAdapter.getCheckedItems()) {
                hashSet.add(this.storeAdapter.getItemId(l3.intValue()));
            }
            actionMode.finish();
            this.removeStores(hashSet);
            return true;
        }
        if (n2 == R.id.menu_select_all) {
            this.storeAdapter.selectAll();
            return true;
        }
        return false;
    }

    @Override
    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.callback = (StoresCallback)activity;
        BusProvider.getInstance().register(this);
    }

    @Override
    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.setHasOptionsMenu(true);
        if (bundle != null) {
            this.isMergeStore = bundle.getBoolean("isMerge");
            return;
        }
        this.isMergeStore = PreferenceManager.getDefaultSharedPreferences((Context)Aptoide.getContext()).getBoolean("mergeStores", false);
    }

    @Override
    public Loader<Cursor> onCreateLoader(int n2, Bundle bundle) {
        return new SimpleCursorLoader((Context)this.getActivity()){

            @Override
            public Cursor loadInBackground() {
                return new Database(Aptoide.getDb()).getServers();
            }
        };
    }

    @Override
    public void onCreateOptionsMenu(Menu menu2, MenuInflater menuInflater) {
        block3: {
            block2: {
                super.onCreateOptionsMenu(menu2, menuInflater);
                menuInflater.inflate(R.menu.menu_stores, menu2);
                if ((this.gridViewMyStores == null || this.gridViewMyStores.getAdapter().getCount() <= 1) && !this.isMergeStore) break block2;
                menu2.findItem(R.id.menu_merge).setVisible(true);
                if (!this.isMergeStore) break block3;
                menu2.findItem(R.id.menu_merge).setTitle(R.string.split_stores);
            }
            return;
        }
        menu2.findItem(R.id.menu_merge).setTitle(R.string.merge_all_stores);
    }

    @Override
    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        this.storeAdapter = new StoreAdapter(bundle, (Context)this.getActivity(), this.stores, this);
        return layoutInflater.inflate(R.layout.page_my_stores, viewGroup, false);
    }

    @Override
    public void onDetach() {
        if (this.storeAdapter != null) {
            this.storeAdapter.setAdapterView((AdapterView<BaseAdapter>)this.gridViewMyStores);
        }
        super.onDetach();
        BusProvider.getInstance().unregister(this);
        this.callback = this.dummyCallback;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onLoadFinished(Loader<Cursor> loader, Cursor cursor) {
        this.stores.clear();
        cursor.moveToFirst();
        while (true) {
            if (cursor.isAfterLast()) {
                this.storeAdapter.setAdapterView((AdapterView<BaseAdapter>)this.gridViewMyStores);
                this.storeAdapter.notifyDataSetChanged();
                this.getActivity().supportInvalidateOptionsMenu();
                Log.d((String)"Aptoide-", (String)"OnLoadFinish");
                return;
            }
            String string2 = cursor.getString(cursor.getColumnIndex("theme"));
            String string3 = string2 != null ? string2.toUpperCase() : "DEFAULT";
            this.stores.add(new StoreItem(cursor.getString(cursor.getColumnIndex("name")), cursor.getString(cursor.getColumnIndex("downloads")), cursor.getString(cursor.getColumnIndex("avatar_url")), EnumStoreTheme.get("APTOIDE_STORE_THEME_" + string3), "grid".equals(cursor.getString(cursor.getColumnIndex("list"))), cursor.getLong(cursor.getColumnIndex("id_repo"))));
            Log.d((String)"Aptoide-", (String)"Added store");
            cursor.moveToNext();
        }
    }

    @Override
    public void onLoaderReset(Loader<Cursor> loader) {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onOptionsItemSelected(MenuItem menuItem) {
        if (menuItem.getItemId() == R.id.menu_merge) {
            boolean bl2 = !this.isMergeStore;
            this.setMergeStore(bl2);
        }
        return super.onOptionsItemSelected(menuItem);
    }

    @Override
    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        this.storeAdapter.save(bundle);
        bundle.putBoolean("isMerge", this.isMergeStore);
    }

    @Override
    public void onViewCreated(View view, Bundle bundle) {
        super.onViewCreated(view, bundle);
        this.gridViewMyStores = (GridView)view.findViewById(R.id.gridview_my_stores);
        view.findViewById(R.id.button_add_store).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                FragmentStores.this.callback.showAddStoreDialog();
            }
        });
        this.storeAdapter.setAdapterView((AdapterView<BaseAdapter>)this.gridViewMyStores);
        this.storeAdapter.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int n2, long l2) {
                Intent intent = new Intent((Context)FragmentStores.this.getActivity(), StoreActivity.class);
                StoreItem storeItem = (StoreItem)adapterView.getItemAtPosition(n2);
                intent.putExtra("storeid", l2);
                intent.putExtra("isrefreshing", FragmentStores.this.callback.isRefreshing(l2));
                intent.putExtra("list", storeItem.isList());
                FragmentStores.this.startActivity(intent);
            }
        });
        if (this.isMergeStore) {
            this.stores.clear();
            this.stores.add(new StoreItem(this.getString(R.string.all_stores), "", "drawable://" + R.drawable.avatar_apps, EnumStoreTheme.APTOIDE_STORE_THEME_ORANGE, false, -1L));
            this.storeAdapter.notifyDataSetChanged();
            return;
        }
        this.getLoaderManager().restartLoader(0, null, this);
    }

    @Subscribe
    public void refreshStoresEvent(RepoAddedEvent repoAddedEvent) {
        Log.d((String)"Aptoide-", (String)"OnEvent");
        if (!this.isMergeStore) {
            this.getLoaderManager().restartLoader(0, null, this);
        }
    }
}

