/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.fragments;

import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.os.Bundle;
import android.support.v4.app.ListFragment;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListAdapter;
import android.widget.ListView;
import cm.aptoide.ptdev.AppViewActivity;
import cm.aptoide.ptdev.Aptoide;
import cm.aptoide.ptdev.EnumCategories;
import cm.aptoide.ptdev.R;
import cm.aptoide.ptdev.StoreActivity;
import cm.aptoide.ptdev.adapters.CategoryAdapter;
import cm.aptoide.ptdev.database.Database;
import cm.aptoide.ptdev.fragments.FragmentStore;
import cm.aptoide.ptdev.fragments.LatestCommentsFragment;
import cm.aptoide.ptdev.fragments.LatestLikesFragment;
import cm.aptoide.ptdev.utils.SimpleCursorLoader;
import com.commonsware.cwac.merge.MergeAdapter;
import uk.co.senab.actionbarpulltorefresh.extras.actionbarcompat.AbcDefaultHeaderTransformer;
import uk.co.senab.actionbarpulltorefresh.extras.actionbarcompat.PullToRefreshLayout;
import uk.co.senab.actionbarpulltorefresh.library.ActionBarPullToRefresh;
import uk.co.senab.actionbarpulltorefresh.library.Options;
import uk.co.senab.actionbarpulltorefresh.library.listeners.OnRefreshListener;

public class FragmentStoreListCategories
extends ListFragment
implements LoaderManager.LoaderCallbacks<Cursor>,
OnRefreshListener,
FragmentStore {
    private CategoryAdapter apkAdapter;
    private CategoryAdapter categoryAdapter;
    int counter;
    private Database database;
    private PullToRefreshLayout mPullToRefreshLayout;
    private MergeAdapter mainAdapter;
    private long parentId;
    StoreActivity.SortObject sort;
    private long storeId;

    @Override
    public void onActivityCreated(Bundle bundle) {
        super.onActivityCreated(bundle);
        this.sort = ((StoreActivity)this.getActivity()).getSort();
        if (this.parentId == 0L) {
            this.setListAdapter((ListAdapter)this.mainAdapter);
        }
        if (this.storeId == -1L) {
            ((StoreActivity)this.getActivity()).getSupportActionBar().setDisplayShowTitleEnabled(true);
            ((StoreActivity)this.getActivity()).getSupportActionBar().setTitle(this.getString(R.string.all_stores));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.mainAdapter = new MergeAdapter();
        this.database = new Database(Aptoide.getDb());
        this.categoryAdapter = new CategoryAdapter((Context)this.getActivity());
        this.apkAdapter = new CategoryAdapter((Context)this.getActivity());
        this.mainAdapter.addAdapter((ListAdapter)this.categoryAdapter);
        this.mainAdapter.addAdapter((ListAdapter)this.apkAdapter);
        this.setHasOptionsMenu(true);
        if (bundle == null) {
            this.parentId = this.getArguments().getLong("parentid");
            this.storeId = this.getArguments().getLong("storeid");
        } else {
            this.parentId = bundle.getLong("parentid");
            this.storeId = bundle.getLong("storeid");
        }
        Log.d((String)"Aptoide-", (String)("StoreFragment id" + this.getArguments().getLong("storeid") + " " + this.storeId + " " + this.parentId + " " + this.getArguments().getLong("parentid")));
    }

    @Override
    public Loader<Cursor> onCreateLoader(final int n2, Bundle bundle) {
        return new SimpleCursorLoader((Context)this.getActivity()){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public Cursor loadInBackground() {
                switch (n2) {
                    case 20: {
                        if (!FragmentStoreListCategories.this.sort.isNoCategories()) {
                            return FragmentStoreListCategories.this.database.getCategories(FragmentStoreListCategories.this.storeId, FragmentStoreListCategories.this.parentId);
                        }
                    }
                    default: {
                        return null;
                    }
                    case 21: 
                }
                if (FragmentStoreListCategories.this.sort.isNoCategories()) {
                    return FragmentStoreListCategories.this.database.getAllStoreApks(FragmentStoreListCategories.this.storeId, FragmentStoreListCategories.this.sort);
                }
                return FragmentStoreListCategories.this.database.getApks(FragmentStoreListCategories.this.storeId, FragmentStoreListCategories.this.parentId, FragmentStoreListCategories.this.sort);
            }
        };
    }

    @Override
    public void onCreateOptionsMenu(Menu menu2, MenuInflater menuInflater) {
        super.onCreateOptionsMenu(menu2, menuInflater);
        if (this.getActivity() != null && ((StoreActivity)this.getActivity()).isRefreshing()) {
            menuInflater.inflate(R.menu.category_refresh, menu2);
        }
    }

    @Override
    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return super.onCreateView(layoutInflater, viewGroup, bundle);
    }

    @Override
    public void onError() {
        this.setEmptyText(this.getString(R.string.connection_error));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onListItemClick(ListView listView, View view, int n2, long l2) {
        super.onListItemClick(listView, view, n2, l2);
        Bundle bundle = this.getArguments();
        Log.d((String)"Aptoide-Stores", (String)listView.getAdapter().getClass().getCanonicalName());
        int n3 = listView.getAdapter().getItemViewType(n2);
        Log.d((String)"Aptoide-Stores", (String)String.valueOf(n3));
        switch (n3) {
            default: {
                Intent intent = new Intent((Context)this.getActivity(), AppViewActivity.class);
                intent.putExtra("id", l2);
                this.startActivity(intent);
                return;
            }
            case 1: 
        }
        ListFragment listFragment = new FragmentStoreListCategories();
        bundle.putLong("storeid", this.storeId);
        bundle.putLong("parentid", l2);
        listFragment.setArguments(bundle);
        int n4 = EnumCategories.getCategoryName((int)l2);
        String string2 = n4 == 0 ? ((Cursor)listView.getAdapter().getItem(n2)).getString(0) : this.getString(n4);
        switch ((int)l2) {
            case 502: {
                listFragment = new LatestLikesFragment();
                listFragment.setArguments(bundle);
            }
            default: {
                break;
            }
            case 503: {
                listFragment = new LatestCommentsFragment();
                listFragment.setArguments(bundle);
            }
        }
        this.getFragmentManager().beginTransaction().setBreadCrumbTitle(string2).replace(R.id.content_layout, listFragment, "fragStore").addToBackStack(String.valueOf(l2)).setTransition(4099).commit();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onLoadFinished(Loader<Cursor> loader, Cursor cursor) {
        block10: {
            block9: {
                switch (loader.getId()) {
                    case 20: {
                        this.categoryAdapter.swapCursor(cursor);
                        break;
                    }
                    case 21: {
                        this.apkAdapter.swapCursor(cursor);
                    }
                }
                Log.d((String)"Aptoide-StoreListCategories", (String)("Counter is " + this.counter));
                if (cursor == null) break block9;
                if (this.getListView().getAdapter() == null && cursor.getCount() > 0) {
                    this.setListAdapter((ListAdapter)this.mainAdapter);
                }
                if (cursor.getCount() > 0) {
                    this.setListShown(true);
                }
                if (new Database(Aptoide.getDb()).isStoreError(this.getArguments().getLong("storeid"))) break block10;
            }
            return;
        }
        this.setListAdapter(null);
        this.setListShown(true);
        this.setEmptyText(this.getString(R.string.connection_error));
    }

    @Override
    public void onLoaderReset(Loader<Cursor> loader) {
        this.categoryAdapter.swapCursor(null);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem menuItem) {
        return super.onOptionsItemSelected(menuItem);
    }

    @Override
    public void onRefresh() {
        Bundle bundle = new Bundle();
        bundle.putLong("storeid", this.storeId);
        bundle.putLong("parentid", this.parentId);
        this.sort = ((StoreActivity)this.getActivity()).getSort();
        if (this.sort.isNoCategories()) {
            this.categoryAdapter.swapCursor(null);
        }
        this.getLoaderManager().restartLoader(20, bundle, this);
        this.getLoaderManager().restartLoader(21, bundle, this);
    }

    @Override
    public void onRefreshStarted(View view) {
        ((StoreActivity)this.getActivity()).onRefreshStarted();
    }

    @Override
    public void onResume() {
        super.onResume();
        Bundle bundle = new Bundle();
        bundle.putLong("storeid", this.storeId);
        bundle.putLong("parentid", this.parentId);
        this.getLoaderManager().restartLoader(20, bundle, this);
        this.getLoaderManager().restartLoader(21, bundle, this);
        this.setRefreshing(((StoreActivity)this.getActivity()).isRefreshing());
    }

    @Override
    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putLong("storeid", this.storeId);
        bundle.putLong("parentid", this.parentId);
    }

    @Override
    public void onViewCreated(View view, Bundle bundle) {
        super.onViewCreated(view, bundle);
        ViewGroup viewGroup = (ViewGroup)view;
        this.setEmptyText(this.getString(R.string.preparing_to_load));
        this.getListView().setDivider(null);
        this.getListView().setCacheColorHint(this.getResources().getColor(17170445));
        this.getListView().setFastScrollEnabled(true);
        if (this.storeId > 0L) {
            this.mPullToRefreshLayout = new PullToRefreshLayout(viewGroup.getContext());
            ActionBarPullToRefresh.from(this.getActivity()).insertLayoutInto(viewGroup).theseChildrenArePullable(16908298, 16908292).listener(this).options(Options.create().headerTransformer(new AbcDefaultHeaderTransformer()).scrollDistance(0.5f).build()).setup(this.mPullToRefreshLayout);
        }
    }

    @Override
    public void setRefreshing(final boolean bl2) {
        if (this.mPullToRefreshLayout != null) {
            final View view = this.getActivity().getWindow().getDecorView();
            view.post(new Runnable(){

                @Override
                public void run() {
                    if (view.getWindowToken() != null) {
                        FragmentStoreListCategories.this.mPullToRefreshLayout.setRefreshing(bl2);
                        return;
                    }
                    view.post((Runnable)this);
                }
            });
        }
        this.onRefresh();
        this.getActivity().supportInvalidateOptionsMenu();
    }
}

