/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.fragments;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.ListFragment;
import android.util.Log;
import android.view.ContextMenu;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import cm.aptoide.ptdev.DownloadServiceConnected;
import cm.aptoide.ptdev.R;
import cm.aptoide.ptdev.Start;
import cm.aptoide.ptdev.adapters.DownloadSimpleSectionAdapter;
import cm.aptoide.ptdev.adapters.NotOngoingAdapter;
import cm.aptoide.ptdev.adapters.OngoingAdapter;
import cm.aptoide.ptdev.downloadmanager.event.DownloadEvent;
import cm.aptoide.ptdev.events.BusProvider;
import cm.aptoide.ptdev.model.Download;
import cm.aptoide.ptdev.services.DownloadService;
import com.commonsware.cwac.merge.MergeAdapter;
import com.squareup.otto.Subscribe;
import java.util.ArrayList;

public class FragmentDownloadManager
extends ListFragment {
    MergeAdapter adapter;
    Start callback;
    NotOngoingAdapter notOngoingAdapter;
    ArrayList<Download> notOngoingList;
    OngoingAdapter ongoingAdapter;
    ArrayList<Download> ongoingList = new ArrayList();
    DownloadSimpleSectionAdapter<Download> sectionAdapter;
    DownloadService service;

    public FragmentDownloadManager() {
        this.notOngoingList = new ArrayList();
    }

    @Subscribe
    public void initAdapters(DownloadServiceConnected downloadServiceConnected) {
        synchronized (this) {
            this.service = this.callback.getDownloadService();
            if (this.service != null) {
                this.ongoingList.clear();
                this.notOngoingList.clear();
                this.ongoingList.addAll(this.service.getAllActiveDownloads());
                this.notOngoingList.addAll(this.service.getAllNotActiveDownloads());
                this.sectionAdapter.notifyDataSetChanged();
                this.getActivity().supportInvalidateOptionsMenu();
            }
            return;
        }
    }

    @Override
    public void onActivityCreated(Bundle bundle) {
        super.onActivityCreated(bundle);
    }

    @Override
    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.callback = (Start)activity;
    }

    @Override
    public boolean onContextItemSelected(MenuItem menuItem) {
        if (menuItem.getItemId() == R.id.menu_retry) {
            ((Download)this.getListAdapter().getItem(((AdapterView.AdapterContextMenuInfo)menuItem.getMenuInfo()).position)).getParent().download();
        }
        return super.onContextItemSelected(menuItem);
    }

    @Override
    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.setHasOptionsMenu(true);
        this.adapter = new MergeAdapter();
        this.ongoingAdapter = new OngoingAdapter((Context)this.getActivity(), this.ongoingList);
        this.notOngoingAdapter = new NotOngoingAdapter((Context)this.getActivity(), this.notOngoingList);
        this.adapter.addAdapter((ListAdapter)this.ongoingAdapter);
        this.adapter.addAdapter((ListAdapter)this.notOngoingAdapter);
        this.sectionAdapter = new DownloadSimpleSectionAdapter((Context)this.getActivity(), this.adapter);
        this.setListAdapter((ListAdapter)this.sectionAdapter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onCreateContextMenu(ContextMenu contextMenu, View view, ContextMenu.ContextMenuInfo contextMenuInfo) {
        AdapterView.AdapterContextMenuInfo adapterContextMenuInfo = (AdapterView.AdapterContextMenuInfo)contextMenuInfo;
        Object object = this.getListView().getAdapter().getItem(adapterContextMenuInfo.position);
        MenuInflater menuInflater = this.getActivity().getMenuInflater();
        Log.d((String)"onCreateContextMenu", (String)"OnCreate");
        if (!(object instanceof Download)) return;
        switch (((Download)object).getDownloadState()) {
            default: {
                return;
            }
            case ERROR: 
        }
        menuInflater.inflate(R.menu.menu_download_error, (Menu)contextMenu);
    }

    @Override
    public void onCreateOptionsMenu(Menu menu2, MenuInflater menuInflater) {
        super.onCreateOptionsMenu(menu2, menuInflater);
        menuInflater.inflate(R.menu.menu_download_manager, menu2);
        if (!this.notOngoingList.isEmpty()) {
            menu2.findItem(R.id.menu_clear_downloads).setVisible(true);
        }
    }

    @Override
    public void onDetach() {
        super.onDetach();
        this.callback = null;
    }

    @Subscribe
    public void onDownloadStatus(DownloadEvent downloadEvent) {
        synchronized (this) {
            if (this.service != null && this.getActivity() != null) {
                this.ongoingList.clear();
                this.notOngoingList.clear();
                this.ongoingList.addAll(this.service.getAllActiveDownloads());
                this.notOngoingList.addAll(this.service.getAllNotActiveDownloads());
                this.sectionAdapter.notifyDataSetChanged();
                this.getActivity().supportInvalidateOptionsMenu();
                Log.d((String)"Aptoide-DownloadManager", (String)"On Download Status");
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Subscribe
    public void onDownloadUpdate(Download download) {
        synchronized (this) {
            int n2;
            int n3;
            Log.d((String)"Aptoide-DownloadManager", (String)("onDownloadUpdate " + download.getId()));
            try {
                n2 = n3 = this.getListView().getFirstVisiblePosition();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
            int n4 = this.getListView().getLastVisiblePosition();
            while (true) {
                block14: {
                    block13: {
                        if (n2 > n4) break block13;
                        if (!download.equals(this.getListView().getItemAtPosition(n2))) break block14;
                        View view = this.getListView().getChildAt(n2 - n3);
                        this.getListView().getAdapter().getView(n2, view, (ViewGroup)this.getListView());
                    }
                    return;
                }
                ++n2;
            }
        }
    }

    @Override
    public void onListItemClick(ListView listView, View view, int n2, long l2) {
        super.onListItemClick(listView, view, n2, l2);
        this.callback.installAppFromManager(l2);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem menuItem) {
        if (menuItem.getItemId() == R.id.menu_clear_downloads) {
            this.service.removeNonActiveDownloads();
        }
        return super.onOptionsItemSelected(menuItem);
    }

    @Override
    public void onResume() {
        super.onResume();
        this.initAdapters(null);
    }

    @Override
    public void onStart() {
        super.onStart();
        BusProvider.getInstance().register(this);
    }

    @Override
    public void onStop() {
        super.onStop();
        BusProvider.getInstance().unregister(this);
    }

    @Override
    public void onViewCreated(View view, Bundle bundle) {
        super.onViewCreated(view, bundle);
        this.getListView().setDivider(null);
        this.getListView().setCacheColorHint(this.getResources().getColor(17170445));
        this.setEmptyText(this.getString(R.string.no_downloads));
        this.registerForContextMenu((View)this.getListView());
    }
}

