/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.fragments;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.ListFragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.TextView;
import android.widget.Toast;
import cm.aptoide.ptdev.AllCommentsActivity;
import cm.aptoide.ptdev.Aptoide;
import cm.aptoide.ptdev.R;
import cm.aptoide.ptdev.model.Comment;
import cm.aptoide.ptdev.utils.AptoideUtils;
import cm.aptoide.ptdev.webservices.AllCommentsRequest;
import cm.aptoide.ptdev.webservices.json.AllCommentsJson;
import com.octo.android.robospice.SpiceManager;
import com.octo.android.robospice.persistence.exception.SpiceException;
import com.octo.android.robospice.request.listener.RequestListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;

public class FragmentComments
extends ListFragment {
    private RequestListener<AllCommentsJson> requestListener = new RequestListener<AllCommentsJson>(){

        @Override
        public void onRequestFailure(SpiceException spiceException) {
            Toast.makeText((Context)Aptoide.getContext(), (int)R.string.error_occured, (int)1).show();
        }

        @Override
        public void onRequestSuccess(AllCommentsJson allCommentsJson) {
            FragmentComments.this.setListAdapter((ListAdapter)new AllCommentsAdapter((Context)FragmentComments.this.getActivity(), allCommentsJson.getListing()));
        }
    };
    private SpiceManager spiceManager;

    @Override
    public void onActivityCreated(Bundle bundle) {
        super.onActivityCreated(bundle);
        this.spiceManager = ((AllCommentsActivity)this.getActivity()).getSpice();
        AllCommentsRequest allCommentsRequest = new AllCommentsRequest();
        allCommentsRequest.setRepoName(this.getActivity().getIntent().getStringExtra("repoName"));
        allCommentsRequest.setVersionName(this.getActivity().getIntent().getStringExtra("versionName"));
        allCommentsRequest.setPackageName(this.getActivity().getIntent().getStringExtra("packageName"));
        this.spiceManager.execute(allCommentsRequest, this.requestListener);
    }

    @Override
    public void onViewCreated(View view, Bundle bundle) {
        super.onViewCreated(view, bundle);
        this.getListView().setDivider(null);
        this.getListView().setCacheColorHint(this.getResources().getColor(17170445));
    }

    public class AllCommentsAdapter
    extends ArrayAdapter<Comment> {
        final SimpleDateFormat dateFormater;

        public AllCommentsAdapter(Context context, List<Comment> list) {
            super(context, 0, list);
            this.dateFormater = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public View getView(int n2, View view, ViewGroup viewGroup) {
            View view2 = view == null ? LayoutInflater.from((Context)this.getContext()).inflate(R.layout.row_comment, viewGroup, false) : view;
            Comment comment = (Comment)this.getItem(n2);
            TextView textView = (TextView)view2.findViewById(R.id.content);
            TextView textView2 = (TextView)view2.findViewById(R.id.date);
            TextView textView3 = (TextView)view2.findViewById(R.id.author);
            textView.setText((CharSequence)comment.getText());
            try {
                textView2.setText((CharSequence)AptoideUtils.DateTimeUtils.getInstance((Context)FragmentComments.this.getActivity()).getTimeDiffString(this.dateFormater.parse(comment.getTimestamp()).getTime()));
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
            textView3.setText((CharSequence)comment.getUsername());
            return view2;
        }
    }
}

