/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.downloadmanager.state;

import cm.aptoide.ptdev.downloadmanager.DownloadInfo;
import cm.aptoide.ptdev.downloadmanager.DownloadManager;
import cm.aptoide.ptdev.downloadmanager.event.DownloadEvent;
import cm.aptoide.ptdev.downloadmanager.state.EnumState;
import cm.aptoide.ptdev.events.BusProvider;
import java.io.Serializable;

public abstract class StatusState
implements Serializable {
    protected DownloadInfo mDownloadInfo;
    protected DownloadManager manager;

    protected StatusState(DownloadInfo downloadInfo) {
        this.mDownloadInfo = downloadInfo;
        this.manager = downloadInfo.getDownloadManager();
    }

    public abstract void changeFrom();

    public void changeTo(StatusState statusState) {
        if (statusState.changeTo()) {
            this.changeFrom();
            BusProvider.getInstance().post(new DownloadEvent(this.mDownloadInfo.getId(), this));
            this.mDownloadInfo = null;
        }
        this.manager.updatePendingList();
    }

    public abstract boolean changeTo();

    public abstract void download();

    public DownloadInfo getDownloadObject() {
        return this.mDownloadInfo;
    }

    public abstract EnumState getEnumState();

    public abstract int getQueuePosition();

    public abstract StatusState getShallowCopy();

    public void openFile() {
    }

    public abstract void pause();

    public void remove() {
        this.changeFrom();
    }
}

