/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.downloadmanager;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.pm.PackageManager;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.graphics.drawable.BitmapDrawable;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import cm.aptoide.ptdev.R;
import cm.aptoide.ptdev.downloadmanager.DownloadExecutorImpl;
import cm.aptoide.ptdev.downloadmanager.FinishedApk;
import cm.aptoide.ptdev.model.ApkPermission;
import com.nostra13.universalimageloader.core.ImageLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class PermissionsActivity
extends Activity {
    private static ExecutorService executor = Executors.newFixedThreadPool(10);
    private FinishedApk apk;
    Context context;

    public static ArrayList<ApkPermission> permissions(Context context, ArrayList<String> arrayList) {
        PackageManager packageManager = context.getPackageManager();
        List list = packageManager.getAllPermissionGroups(0);
        ArrayList<ApkPermission> arrayList2 = new ArrayList<ApkPermission>();
        for (int i2 = 0; i2 != arrayList.size(); ++i2) {
            String string2 = arrayList.get(i2);
            for (PermissionGroupInfo permissionGroupInfo : list) {
                CharSequence charSequence = permissionGroupInfo.loadLabel(packageManager);
                try {
                    for (PermissionInfo permissionInfo : packageManager.queryPermissionsByGroup(permissionGroupInfo.name, 0)) {
                        CharSequence charSequence2 = permissionInfo.loadLabel(packageManager);
                        if (!permissionInfo.name.equals(string2)) continue;
                        arrayList2.add(new ApkPermission(charSequence.toString(), charSequence2.toString()));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        Collections.sort(arrayList2, new Comparator<ApkPermission>(){

            @Override
            public int compare(ApkPermission apkPermission, ApkPermission apkPermission2) {
                return apkPermission.getName().compareTo(apkPermission2.getName());
            }
        });
        return arrayList2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void permissionsDialog(final FinishedApk finishedApk, ArrayList<ApkPermission> arrayList) {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.app_permission, null);
        LinearLayout linearLayout = (LinearLayout)view.findViewById(R.id.container);
        if (arrayList != null) {
            if (arrayList.isEmpty()) {
                TextView textView = new TextView(this.context);
                textView.setPadding(10, 10, 10, 10);
                textView.setText((CharSequence)this.context.getString(R.string.no_permissions_required));
                linearLayout.addView((View)textView);
            } else {
                for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                    ApkPermission apkPermission = arrayList.get(i2);
                    View view2 = LayoutInflater.from((Context)this.context).inflate(R.layout.row_permission, null);
                    if (i2 == 0 || !arrayList.get(i2 - 1).getName().equals(apkPermission.getName())) {
                        ((TextView)view2.findViewById(R.id.permission_name)).setText((CharSequence)apkPermission.getName());
                    } else {
                        view2.findViewById(R.id.permission_name).setVisibility(8);
                    }
                    ((TextView)view2.findViewById(R.id.permission_description)).setText((CharSequence)apkPermission.getDescription());
                    linearLayout.addView(view2);
                }
            }
        }
        AlertDialog alertDialog = new AlertDialog.Builder(this.context).setView(view).create();
        alertDialog.setTitle((CharSequence)(this.context.getString(R.string.restore) + " " + finishedApk.getName() + "?"));
        String string2 = finishedApk.getIconPath();
        alertDialog.setIcon(BitmapDrawable.createFromPath((String)ImageLoader.getInstance().getDiscCache().get(string2).getAbsolutePath()));
        alertDialog.setButton(-1, (CharSequence)this.context.getString(17039379), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n2) {
                executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        DownloadExecutorImpl.installWithRoot(finishedApk);
                    }
                });
                PermissionsActivity.this.finish();
            }
        });
        alertDialog.setButton(-2, (CharSequence)this.context.getString(17039369), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n2) {
                dialogInterface.dismiss();
            }
        });
        alertDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialogInterface) {
                PermissionsActivity.this.finish();
            }
        });
        alertDialog.show();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.context = this;
        this.apk = (FinishedApk)this.getIntent().getParcelableExtra("apk");
        ArrayList arrayList = this.getIntent().getStringArrayListExtra("permissions");
        try {
            ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList(this.getPackageManager().getPackageInfo((String)this.apk.getApkid(), (int)4096).requestedPermissions));
            Log.d((String)"TAG", (String)("Installed permissions: " + arrayList2.size() + " " + arrayList2));
            Log.d((String)"TAG", (String)("apk permissions: " + arrayList.size() + " " + arrayList));
            arrayList.removeAll(arrayList2);
            Log.d((String)"TAG", (String)("apk permissions 2: " + arrayList.size() + " " + arrayList));
            if (arrayList.isEmpty()) {
                DownloadExecutorImpl.installWithRoot(this.apk);
                this.finish();
                return;
            }
            ArrayList<ApkPermission> arrayList3 = PermissionsActivity.permissions(this.context, arrayList);
            if (!arrayList3.isEmpty()) {
                this.permissionsDialog(this.apk, arrayList3);
                return;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            try {
                this.permissionsDialog(this.apk, PermissionsActivity.permissions(this.context, arrayList));
                return;
            }
            catch (NullPointerException nullPointerException) {
                DownloadExecutorImpl.installWithRoot(this.apk);
                this.finish();
                return;
            }
        }
        catch (NullPointerException nullPointerException) {
            DownloadExecutorImpl.installWithRoot(this.apk);
            this.finish();
            return;
        }
        {
            DownloadExecutorImpl.installWithRoot(this.apk);
            this.finish();
            return;
        }
    }
}

