/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.downloadmanager;

import android.os.StatFs;
import android.util.Log;
import cm.aptoide.ptdev.downloadmanager.CompletedDownloadException;
import cm.aptoide.ptdev.downloadmanager.ContentTypeNotApkException;
import cm.aptoide.ptdev.downloadmanager.DownloadConnection;
import cm.aptoide.ptdev.downloadmanager.DownloadFile;
import cm.aptoide.ptdev.downloadmanager.DownloadInfo;
import cm.aptoide.ptdev.downloadmanager.DownloadModel;
import cm.aptoide.ptdev.downloadmanager.EnumDownloadFailReason;
import cm.aptoide.ptdev.downloadmanager.IPBlackListedException;
import cm.aptoide.ptdev.downloadmanager.Md5FailedException;
import cm.aptoide.ptdev.downloadmanager.NotFoundException;
import cm.aptoide.ptdev.downloadmanager.state.ActiveState;
import cm.aptoide.ptdev.downloadmanager.state.ErrorState;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.net.UnknownHostException;

public class DownloadThread
implements Runnable,
Serializable {
    private DownloadModel download;
    transient RandomAccessFile file = null;
    private long fileSize;
    DownloadConnection mConnection = null;
    DownloadFile mDownloadFile = null;
    private long mDownloadedSize = 0L;
    private long mFullSize;
    private long mProgress;
    private long mRemainingSize;
    private DownloadInfo parent;

    public DownloadThread(DownloadModel downloadModel, DownloadInfo downloadInfo) throws IOException {
        this.download = downloadModel;
        this.parent = downloadInfo;
        this.mConnection = downloadModel.createConnection();
        this.mProgress = DownloadFile.getFileLength(downloadModel.getDestination());
        this.mRemainingSize = this.mFullSize = downloadModel.getSize();
    }

    public long getmDownloadedSize() {
        return this.mDownloadedSize;
    }

    public long getmFullSize() {
        return this.mFullSize;
    }

    public long getmProgress() {
        long l2 = 0L;
        if (this.mProgress > l2) {
            l2 = this.mProgress;
        }
        return l2;
    }

    public long getmRemainingSize() {
        return this.mRemainingSize;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            if (!(this.parent.getStatusState() instanceof ActiveState)) {
                return;
            }
            this.mDownloadFile = this.download.createFile();
            this.file = this.mDownloadFile.getmFile();
            this.mConnection = this.download.createConnection();
            this.mDownloadedSize = 0L;
            this.fileSize = DownloadFile.getFileLength(this.download.getDestination());
            this.mDownloadFile.setDownloadedSize(this.file, this.fileSize);
            this.mRemainingSize = this.mFullSize - this.fileSize;
            this.mConnection.connect(this.fileSize);
            Log.d((String)"DownloadManager", (String)("Starting Download " + (this.parent.getStatusState() instanceof ActiveState) + " " + this.mDownloadedSize + this.fileSize + " " + this.mRemainingSize));
            var13_1 = new byte[1024];
            var14_2 = this.mConnection.getStream();
            if (this.parent.getStatusState() instanceof ActiveState && this.mRemainingSize > (var16_4 = (long)(var15_3 = new StatFs(this.download.getDestination())).getBlockSize() * (long)var15_3.getAvailableBlocks())) {
                this.parent.changeStatusState(new ErrorState(this.parent, EnumDownloadFailReason.NO_FREE_SPACE));
            }
            while ((var18_5 = var14_2.read(var13_1)) != -1 && this.parent.getStatusState() instanceof ActiveState) {
                this.file.write(var13_1, 0, var18_5);
                this.mDownloadedSize += (long)var18_5;
                this.mProgress += (long)var18_5;
            }
        }
        catch (NotFoundException var11_6) {
            var11_6.printStackTrace();
            this.parent.changeStatusState(new ErrorState(this.parent, EnumDownloadFailReason.NOT_FOUND));
lbl27:
            // 3 sources

            while (true) {
                if (this.mDownloadFile != null && this.file != null) {
                    this.mDownloadFile.close(this.file);
                }
                if (this.mConnection == null) return;
                this.mConnection.close();
                return;
            }
        }
        try {
            if (!(this.parent.getStatusState() instanceof ActiveState)) ** GOTO lbl27
            this.mDownloadFile.checkMd5();
        }
        catch (FileNotFoundException var10_7) {
            var10_7.printStackTrace();
            this.parent.changeStatusState(new ErrorState(this.parent, EnumDownloadFailReason.SD_ERROR));
        }
        catch (ContentTypeNotApkException var9_8) {
            this.parent.changeStatusState(new ErrorState(this.parent, EnumDownloadFailReason.PAIDAPP_NOTFOUND));
        }
        catch (IPBlackListedException var8_9) {
            this.parent.changeStatusState(new ErrorState(this.parent, EnumDownloadFailReason.IP_BLACKLISTED));
        }
        catch (Md5FailedException var7_10) {
            var7_10.printStackTrace();
            this.mDownloadFile.delete();
            this.parent.changeStatusState(new ErrorState(this.parent, EnumDownloadFailReason.MD5_CHECK_FAILED));
        }
        catch (UnknownHostException var6_11) {
            var6_11.printStackTrace();
            this.parent.changeStatusState(new ErrorState(this.parent, EnumDownloadFailReason.CONNECTION_ERROR));
        }
        catch (IOException var5_12) {
            var5_12.printStackTrace();
            this.parent.changeStatusState(new ErrorState(this.parent, EnumDownloadFailReason.CONNECTION_ERROR));
        }
        catch (CompletedDownloadException var2_13) {
            this.mProgress = var3_14 = this.fileSize;
            this.mFullSize = var3_14;
            this.mRemainingSize = 0L;
            var2_13.printStackTrace();
        }
        catch (Exception var1_15) {
            var1_15.printStackTrace();
            this.parent.changeStatusState(new ErrorState(this.parent, EnumDownloadFailReason.CONNECTION_ERROR));
        }
        ** while (true)
    }
}

