/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.downloadmanager;

import cm.aptoide.ptdev.downloadmanager.DownloadInfo;
import cm.aptoide.ptdev.downloadmanager.state.ActiveState;
import cm.aptoide.ptdev.downloadmanager.state.PendingState;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

public class DownloadManager
implements Serializable {
    private ArrayList<DownloadInfo> mActiveList = new ArrayList();
    private ArrayList<DownloadInfo> mCompletedList;
    private ArrayList<DownloadInfo> mErrorList;
    private ArrayList<DownloadInfo> mInactiveList = new ArrayList();
    private ArrayList<DownloadInfo> mPendingList = new ArrayList();

    public DownloadManager() {
        this.mCompletedList = new ArrayList();
        this.mErrorList = new ArrayList();
    }

    private boolean activeListHasRoom() {
        return !true || this.mActiveList.size() < 1;
    }

    private void switchBottomActiveWithTopPending() {
        DownloadInfo downloadInfo = this.mActiveList.get(-1 + this.mActiveList.size());
        downloadInfo.changeStatusState(new PendingState(downloadInfo));
        DownloadInfo downloadInfo2 = this.mPendingList.get(-1 + this.mPendingList.size());
        this.mPendingList.add(0, downloadInfo2);
        this.mPendingList.remove(-1 + this.mPendingList.size());
    }

    private URL verifyUrl(String string2) throws MalformedURLException {
        if (!string2.toLowerCase().startsWith("http://")) {
            throw new MalformedURLException("Must start with http://");
        }
        URL uRL = new URL(string2);
        if (uRL.getFile().length() < 2) {
            throw new MalformedURLException("URL has to specify a file.");
        }
        return uRL;
    }

    public boolean addToActiveList(DownloadInfo downloadInfo) {
        if (this.activeListHasRoom()) {
            return this.mActiveList.add(downloadInfo);
        }
        return false;
    }

    public boolean addToCompletedList(DownloadInfo downloadInfo) {
        return this.mCompletedList.add(downloadInfo);
    }

    public boolean addToErrorList(DownloadInfo downloadInfo) {
        return this.mErrorList.add(downloadInfo);
    }

    public boolean addToInactiveList(DownloadInfo downloadInfo) {
        return this.mInactiveList.add(downloadInfo);
    }

    public boolean addToPendingList(DownloadInfo downloadInfo) {
        return this.mPendingList.add(downloadInfo);
    }

    public int getActiveQueuePosition(DownloadInfo downloadInfo) {
        return 1 + this.mActiveList.indexOf(downloadInfo);
    }

    public int getNumberOfQueuedDownloads() {
        return this.mActiveList.size() + this.mPendingList.size();
    }

    public int getPendingQueuePosition(DownloadInfo downloadInfo) {
        return 1 + (this.mActiveList.size() + this.mPendingList.indexOf(downloadInfo));
    }

    public ArrayList<DownloadInfo> getmActiveList() {
        return this.mActiveList;
    }

    public ArrayList<DownloadInfo> getmCompletedList() {
        return this.mCompletedList;
    }

    public ArrayList<DownloadInfo> getmErrorList() {
        return this.mErrorList;
    }

    public ArrayList<DownloadInfo> getmInactiveList() {
        return this.mInactiveList;
    }

    public ArrayList<DownloadInfo> getmPendingList() {
        return this.mPendingList;
    }

    public void init() {
    }

    public void moveActiveDown(DownloadInfo downloadInfo) {
        int n2;
        block5: {
            block4: {
                n2 = this.mActiveList.indexOf(downloadInfo);
                if (n2 == -1) break block4;
                if (n2 != -1 + this.mActiveList.size()) break block5;
                if (this.mPendingList.size() > 0) {
                    this.switchBottomActiveWithTopPending();
                }
            }
            return;
        }
        DownloadInfo downloadInfo2 = this.mActiveList.get(n2 + 1);
        this.mActiveList.set(n2 + 1, downloadInfo);
        this.mActiveList.set(n2, downloadInfo2);
    }

    public void moveActiveUp(DownloadInfo downloadInfo) {
        int n2 = this.mActiveList.indexOf(downloadInfo);
        if (n2 != -1 && n2 != 0) {
            DownloadInfo downloadInfo2 = this.mActiveList.get(n2 - 1);
            this.mActiveList.set(n2 - 1, downloadInfo);
            this.mActiveList.set(n2, downloadInfo2);
        }
    }

    public void movePendingDown(DownloadInfo downloadInfo) {
        int n2 = this.mPendingList.indexOf(downloadInfo);
        if (n2 != -1 && n2 != -1 + this.mPendingList.size()) {
            DownloadInfo downloadInfo2 = this.mPendingList.get(n2 + 1);
            this.mPendingList.set(n2 + 1, downloadInfo);
            this.mPendingList.set(n2, downloadInfo2);
        }
    }

    public void movePendingUp(DownloadInfo downloadInfo) {
        int n2;
        block3: {
            block2: {
                n2 = this.mPendingList.indexOf(downloadInfo);
                if (n2 == -1) break block2;
                if (n2 != 0) break block3;
                this.switchBottomActiveWithTopPending();
            }
            return;
        }
        DownloadInfo downloadInfo2 = this.mPendingList.get(n2 - 1);
        this.mPendingList.set(n2 - 1, downloadInfo);
        this.mPendingList.set(n2, downloadInfo2);
    }

    public void removeAllActiveDownloads() {
        while (this.mActiveList.iterator().hasNext()) {
            this.mActiveList.get(0).pause();
        }
    }

    public void removeDownload(DownloadInfo downloadInfo) {
        this.mCompletedList.remove(downloadInfo);
    }

    public void removeFromActiveList(DownloadInfo downloadInfo) {
        this.mActiveList.remove(downloadInfo);
    }

    public void removeFromCompletedList(DownloadInfo downloadInfo) {
        this.mCompletedList.remove(downloadInfo);
    }

    public void removeFromErrorList(DownloadInfo downloadInfo) {
        this.mErrorList.remove(downloadInfo);
    }

    public void removeFromInactiveList(DownloadInfo downloadInfo) {
        this.mInactiveList.remove(downloadInfo);
    }

    public void removeFromPendingList(DownloadInfo downloadInfo) {
        this.mPendingList.remove(downloadInfo);
    }

    public void updatePendingList() {
        while (this.mPendingList.size() > 0 && this.activeListHasRoom()) {
            DownloadInfo downloadInfo = this.mPendingList.get(0);
            downloadInfo.changeStatusState(new ActiveState(downloadInfo));
        }
    }

    public static final class DefaultFileExistsBehavior
    extends Enum<DefaultFileExistsBehavior>
    implements Serializable {
        private static final /* synthetic */ DefaultFileExistsBehavior[] $VALUES;
        public static final /* enum */ DefaultFileExistsBehavior ASK = new DefaultFileExistsBehavior();
        public static final /* enum */ DefaultFileExistsBehavior RENAME = new DefaultFileExistsBehavior();
        public static final /* enum */ DefaultFileExistsBehavior REPLACE = new DefaultFileExistsBehavior();
        public static final /* enum */ DefaultFileExistsBehavior RESUME = new DefaultFileExistsBehavior();

        static {
            DefaultFileExistsBehavior[] defaultFileExistsBehaviorArray = new DefaultFileExistsBehavior[]{ASK, RENAME, REPLACE, RESUME};
            $VALUES = defaultFileExistsBehaviorArray;
        }

        public static DefaultFileExistsBehavior valueOf(String string2) {
            return Enum.valueOf(DefaultFileExistsBehavior.class, string2);
        }

        public static DefaultFileExistsBehavior[] values() {
            return (DefaultFileExistsBehavior[])$VALUES.clone();
        }
    }
}

