/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.downloadmanager;

import android.content.Context;
import android.preference.PreferenceManager;
import android.util.Log;
import cm.aptoide.ptdev.Aptoide;
import cm.aptoide.ptdev.downloadmanager.DownloadExecutor;
import cm.aptoide.ptdev.downloadmanager.DownloadManager;
import cm.aptoide.ptdev.downloadmanager.DownloadModel;
import cm.aptoide.ptdev.downloadmanager.DownloadThread;
import cm.aptoide.ptdev.downloadmanager.EnumDownloadFailReason;
import cm.aptoide.ptdev.downloadmanager.Utils;
import cm.aptoide.ptdev.downloadmanager.event.DownloadEvent;
import cm.aptoide.ptdev.downloadmanager.state.ActiveState;
import cm.aptoide.ptdev.downloadmanager.state.CompletedState;
import cm.aptoide.ptdev.downloadmanager.state.ErrorState;
import cm.aptoide.ptdev.downloadmanager.state.NoState;
import cm.aptoide.ptdev.downloadmanager.state.StatusState;
import cm.aptoide.ptdev.events.BusProvider;
import cm.aptoide.ptdev.model.Download;
import com.squareup.otto.Produce;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class DownloadInfo
implements Runnable,
Serializable {
    private static final int UPDATE_INTERVAL_MILLISECONDS = 1000;
    private Download download;
    private DownloadExecutor downloadExecutor;
    private DownloadManager downloadManager;
    private ArrayList<String> downloadingFilenames;
    private long id;
    private boolean isPaused = false;
    private String mDestination;
    private long mDownloadedSize;
    private long mETA;
    private List<DownloadModel> mFilesToDownload;
    private long mProgress = 0L;
    private long mSize;
    private double mSpeed;
    private StatusState mStatusState;
    private ArrayList<DownloadThread> threads = new ArrayList();

    public DownloadInfo(DownloadManager downloadManager, long l2) {
        this.downloadingFilenames = new ArrayList();
        this.id = l2;
        this.downloadManager = downloadManager;
        this.mStatusState = new NoState(this);
    }

    public DownloadInfo(DownloadManager downloadManager, List<DownloadModel> list, int n2, Download download) {
        this.downloadingFilenames = new ArrayList();
        this.downloadManager = downloadManager;
        this.mFilesToDownload = list;
        this.id = n2;
        this.download = download;
        this.download.setId(n2);
        this.download.setParent(this);
        this.mStatusState = new NoState(this);
    }

    static /* synthetic */ long access$002(DownloadInfo downloadInfo, long l2) {
        downloadInfo.mDownloadedSize = l2;
        return l2;
    }

    static /* synthetic */ long access$202(DownloadInfo downloadInfo, long l2) {
        downloadInfo.mProgress = l2;
        return l2;
    }

    static /* synthetic */ double access$402(DownloadInfo downloadInfo, double d2) {
        downloadInfo.mSpeed = d2;
        return d2;
    }

    static /* synthetic */ long access$502(DownloadInfo downloadInfo, long l2) {
        downloadInfo.mETA = l2;
        return l2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkDirectorySize(String string2) {
        block6: {
            block5: {
                File file = new File(string2);
                if (!file.exists() && !file.mkdirs()) break block5;
                double d2 = this.getDirSize(file) / 1024.0 / 1024.0;
                long l2 = Long.parseLong(PreferenceManager.getDefaultSharedPreferences((Context)Aptoide.getContext()).getString("maxFileCache", "200"));
                if (l2 < 50L) {
                    l2 = 50L;
                }
                if (l2 <= 0L || !(d2 > (double)l2)) break block5;
                File[] fileArray = file.listFiles();
                long l3 = System.currentTimeMillis();
                File file2 = null;
                for (File file3 : fileArray) {
                    long l4 = file3.lastModified();
                    if (l4 >= l3 || this.downloadingFilenames.contains(file3.getName())) continue;
                    l3 = l4;
                    file2 = file3;
                }
                if (file2 == null) break block5;
                Log.d((String)"TAG", (String)("Deleting " + file2.getName()));
                if (file2.delete()) break block6;
            }
            return;
        }
        this.checkDirectorySize(string2);
    }

    private long getAllDownloadedSize() {
        long l2 = 0L;
        Iterator<DownloadThread> iterator = this.threads.iterator();
        while (iterator.hasNext()) {
            l2 += iterator.next().getmDownloadedSize();
        }
        return l2;
    }

    private long getAllProgress() {
        long l2 = 0L;
        Iterator<DownloadThread> iterator = this.threads.iterator();
        while (iterator.hasNext()) {
            l2 += iterator.next().getmProgress();
        }
        return l2;
    }

    private long getAllThreadSize() {
        long l2 = 0L;
        Iterator<DownloadThread> iterator = this.threads.iterator();
        while (iterator.hasNext()) {
            l2 += iterator.next().getmFullSize();
        }
        return l2;
    }

    @Produce
    private Download getDownloadEvent() {
        return this.download;
    }

    public void autoExecute() {
        if (this.downloadExecutor != null) {
            Iterator<DownloadModel> iterator = this.mFilesToDownload.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().isAutoExecute()) continue;
                this.downloadExecutor.execute();
            }
        }
    }

    public void changeStatusState(StatusState statusState) {
        this.mStatusState.changeTo(statusState);
    }

    public void download() {
        this.mProgress = 0L;
        BusProvider.getInstance().post(new DownloadEvent(this.getId(), this.mStatusState));
        this.mStatusState.download();
    }

    public long getAllSizeRemaining() {
        long l2 = 0L;
        Iterator<DownloadThread> iterator = this.threads.iterator();
        while (iterator.hasNext()) {
            l2 += iterator.next().getmRemainingSize();
        }
        return l2;
    }

    public String getDestination() {
        return this.mDestination;
    }

    /*
     * Enabled aggressive block sorting
     */
    double getDirSize(File file) {
        double d2 = 0.0;
        if (file.isFile()) {
            if (this.downloadingFilenames.contains(file.getName())) return d2;
            return file.length();
        }
        File[] fileArray = file.listFiles();
        int n2 = fileArray.length;
        int n3 = 0;
        while (n3 < n2) {
            File file2 = fileArray[n3];
            if (file2.isFile()) {
                if (!this.downloadingFilenames.contains(file2.getName())) {
                    d2 += (double)file2.length();
                }
            } else {
                d2 += this.getDirSize(file2);
            }
            ++n3;
        }
        return d2;
    }

    public Download getDownload() {
        return this.download;
    }

    public DownloadManager getDownloadManager() {
        return this.downloadManager;
    }

    public long getEta() {
        return this.mETA;
    }

    public EnumDownloadFailReason getFailReason() {
        return ((ErrorState)this.mStatusState).getErrorMessage();
    }

    public long getId() {
        return this.id;
    }

    public int getPercentDownloaded() {
        if (this.mSize == 0L) {
            return 0;
        }
        return (int)(100L * this.mProgress / this.mSize);
    }

    public double getSpeed() {
        return 8.0 * this.mSpeed;
    }

    public StatusState getStatusState() {
        return this.mStatusState;
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    public void pause() {
        this.isPaused = true;
        this.mStatusState.pause();
    }

    public void remove() {
        this.changeStatusState(new CompletedState(this));
        if (this.mFilesToDownload == null) {
            return;
        }
        Iterator<DownloadModel> iterator = this.mFilesToDownload.iterator();
        while (iterator.hasNext()) {
            new File(iterator.next().getDestination()).delete();
        }
        this.mProgress = 0L;
        this.mSize = 0L;
        this.mFilesToDownload.clear();
        this.downloadManager.removeDownload(this);
        BusProvider.getInstance().post(new DownloadEvent(this.getId(), this.mStatusState));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        var1_1 = Executors.newSingleThreadExecutor();
        var2_2 = new Timer();
        try {
            var5_3 = this.mFilesToDownload.iterator();
            while (var5_3.hasNext()) {
                var6_4 = new DownloadThread(var5_3.next(), this);
                var1_1.submit(var6_4);
                this.threads.add(var6_4);
            }
        }
        catch (RuntimeException var4_5) {
            this.changeStatusState(new ErrorState(this, EnumDownloadFailReason.NO_REASON));
            var4_5.printStackTrace();
lbl16:
            // 4 sources

            while (true) {
                BusProvider.getInstance().post(new DownloadEvent(this.getId(), this.mStatusState));
                this.downloadManager.updatePendingList();
                this.threads.clear();
                this.mDownloadedSize = 0L;
                this.mSpeed = 0.0;
                this.mETA = 0L;
                return;
            }
        }
        try {
            this.checkDirectorySize(Aptoide.getConfiguration().getPathCacheApks());
            this.mSize = this.getAllThreadSize();
            var2_2.schedule(new TimerTask(){
                private long iMFirstTime;
                private long iMLastDownloadedSize;
                private long iMLastTime;
                public long mAvgSpeed;
                {
                    this.iMLastDownloadedSize = DownloadInfo.this.mDownloadedSize;
                    this.iMLastTime = System.currentTimeMillis();
                    this.iMFirstTime = System.currentTimeMillis();
                }

                @Override
                public void run() {
                    long l2 = DownloadInfo.this.getAllSizeRemaining();
                    DownloadInfo.access$002(DownloadInfo.this, DownloadInfo.this.getAllDownloadedSize());
                    DownloadInfo.access$202(DownloadInfo.this, DownloadInfo.this.getAllProgress());
                    long l3 = System.currentTimeMillis() - this.iMLastTime;
                    long l4 = System.currentTimeMillis() - this.iMFirstTime;
                    this.iMLastTime = System.currentTimeMillis();
                    long l5 = DownloadInfo.this.mDownloadedSize - this.iMLastDownloadedSize;
                    this.iMLastDownloadedSize = DownloadInfo.this.mDownloadedSize;
                    if (l3 > 0L && l4 > 0L) {
                        this.mAvgSpeed = 1000L * DownloadInfo.this.mDownloadedSize / l4;
                        DownloadInfo.access$402(DownloadInfo.this, 1000L * l5 / l3);
                    }
                    if (this.mAvgSpeed > 0L) {
                        DownloadInfo.access$502(DownloadInfo.this, 1000L * (l2 - DownloadInfo.this.mDownloadedSize) / this.mAvgSpeed);
                    }
                    Log.d((String)"DownloadManager", (String)("ETA: " + DownloadInfo.this.mETA + " Speed: " + DownloadInfo.this.mSpeed / 1000.0 + " Size: " + Utils.formatBytes(DownloadInfo.this.mSize) + " Downloaded: " + Utils.formatBytes(DownloadInfo.this.mDownloadedSize) + " Status: " + DownloadInfo.this.mStatusState + " TotalDownloaded: " + Utils.formatBytes(DownloadInfo.this.mProgress) + " " + System.identityHashCode(DownloadInfo.this)));
                    DownloadInfo.this.download.setSpeed(DownloadInfo.this.getSpeed());
                    DownloadInfo.this.download.setTimeLeft(DownloadInfo.this.mETA);
                    DownloadInfo.this.download.setProgress(DownloadInfo.this.getPercentDownloaded());
                    BusProvider.getInstance().post(DownloadInfo.this.getDownloadEvent());
                }
            }, 0L, 1000L);
            var1_1.shutdown();
            var1_1.awaitTermination(0x7FFFFFFFFFFFFFFFL, TimeUnit.SECONDS);
            var2_2.cancel();
            var2_2.purge();
            this.mSize = this.getAllThreadSize();
            this.mProgress = this.getAllProgress();
            Log.d((String)"TAG", (String)("Downloads done " + this.mSize + " " + this.mProgress + " " + this.mStatusState.getEnumState().name()));
            this.download.setSpeed(this.getSpeed());
            this.download.setProgress(this.getPercentDownloaded());
            if (!(this.mStatusState instanceof ActiveState)) ** GOTO lbl16
            this.changeStatusState(new CompletedState(this));
            this.autoExecute();
            ** GOTO lbl16
        }
        catch (Exception var3_6) {
            this.changeStatusState(new ErrorState(this, EnumDownloadFailReason.NO_REASON));
            var3_6.printStackTrace();
            ** continue;
        }
    }

    public void setDestination(String string2) {
        this.mDestination = string2;
    }

    public void setDownload(Download download) {
        this.download = download;
        this.download.setParent(this);
    }

    public void setDownloadExecutor(DownloadExecutor downloadExecutor) {
        this.downloadExecutor = downloadExecutor;
    }

    public void setDownloadManager(DownloadManager downloadManager) {
        this.downloadManager = downloadManager;
    }

    public void setFilesToDownload(List<DownloadModel> list) {
        this.mFilesToDownload = list;
    }

    public void setStatusState(StatusState statusState) {
        this.mStatusState = statusState;
    }
}

