/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.downloadmanager;

import android.util.Log;
import cm.aptoide.ptdev.downloadmanager.Md5FailedException;
import cm.aptoide.ptdev.utils.AptoideUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;

public class DownloadFile
implements Serializable {
    private final File file;
    private String mDestination;
    private String md5;

    public DownloadFile(String string2, String string3) throws FileNotFoundException {
        this.md5 = string3;
        this.mDestination = string2;
        this.file = new File(this.mDestination);
        File file = this.file.getParentFile();
        if (file != null && !file.isDirectory()) {
            file.mkdirs();
        }
    }

    public static long getFileLength(String string2) {
        File file = new File(string2);
        if (file.exists()) {
            return file.length();
        }
        return 0L;
    }

    public void checkMd5() throws Md5FailedException {
        synchronized (this) {
            String string2;
            String string3 = this.getMd5();
            if (string3.length() > 0 && !(string2 = AptoideUtils.Algorithms.md5Calc(new File(this.mDestination))).equals(string3)) {
                Log.d((String)"TAG", (String)("Failed Md5: " + this.mDestination + "   calculated " + string2 + " vs " + string3));
                throw new Md5FailedException();
            }
            return;
        }
    }

    public void close(RandomAccessFile randomAccessFile) {
        try {
            randomAccessFile.close();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }

    public void delete() {
        new File(this.mDestination).delete();
    }

    public String getDestination() {
        return this.mDestination;
    }

    public String getMd5() {
        return this.md5;
    }

    public RandomAccessFile getmFile() throws FileNotFoundException {
        return new RandomAccessFile(this.file, "rw");
    }

    public void setDownloadedSize(RandomAccessFile randomAccessFile, long l2) throws IOException {
        Log.d((String)"DownloadFile", (String)("Position is: " + l2));
        randomAccessFile.getChannel().position(l2);
    }
}

