/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.downloadmanager;

import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.preference.PreferenceManager;
import android.support.v4.app.NotificationCompat;
import android.util.DisplayMetrics;
import android.util.Log;
import cm.aptoide.ptdev.Aptoide;
import cm.aptoide.ptdev.R;
import cm.aptoide.ptdev.database.Database;
import cm.aptoide.ptdev.downloadmanager.DownloadExecutor;
import cm.aptoide.ptdev.downloadmanager.FinishedApk;
import cm.aptoide.ptdev.downloadmanager.PermissionsActivity;
import cm.aptoide.ptdev.model.RollBackItem;
import cm.aptoide.ptdev.utils.AptoideUtils;
import com.nostra13.universalimageloader.core.ImageLoader;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Locale;

public class DownloadExecutorImpl
implements DownloadExecutor,
Serializable {
    private final FinishedApk apk;
    private final String path;

    public DownloadExecutorImpl(FinishedApk finishedApk) {
        this.apk = finishedApk;
        this.path = finishedApk.getPath();
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int n2, int n3) {
        int n4 = options.outHeight;
        int n5 = options.outWidth;
        int n6 = 1;
        if (n4 > n3 || n5 > n2) {
            int n7 = n4 / 2;
            int n8 = n5 / 2;
            while (n7 / n6 > n3 && n8 / n6 > n2) {
                n6 *= 2;
            }
        }
        return n6;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean canRunRootCommands() {
        try {
            boolean bl2;
            boolean bl3;
            Process process = Runtime.getRuntime().exec("su");
            DataOutputStream dataOutputStream = new DataOutputStream(process.getOutputStream());
            DataInputStream dataInputStream = new DataInputStream(process.getInputStream());
            dataOutputStream.writeBytes("id\n");
            dataOutputStream.flush();
            String string2 = dataInputStream.readLine();
            if (string2 == null) {
                bl3 = false;
                bl2 = false;
                Log.d((String)"ROOT", (String)"Can't get root access or denied by user");
            } else if (string2.contains("uid=0")) {
                bl3 = true;
                bl2 = true;
                Log.d((String)"ROOT", (String)"Root access granted");
            } else {
                bl2 = true;
                Log.d((String)"ROOT", (String)("Root access rejected: " + string2));
                bl3 = false;
            }
            if (!bl2) return bl3;
            dataOutputStream.writeBytes("exit\n");
            dataOutputStream.flush();
            return bl3;
        }
        catch (Exception exception) {
            Log.d((String)"ROOT", (String)("Root access rejected [" + exception.getClass().getName() + "] : " + exception.getMessage()));
            return false;
        }
    }

    public static Bitmap decodeSampledBitmapFromResource(String string2, int n2, int n3) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)string2, (BitmapFactory.Options)options);
        options.inSampleSize = DownloadExecutorImpl.calculateInSampleSize(options, n2, n3);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)string2, (BitmapFactory.Options)options);
    }

    protected static int dpToPixels(Context context, int n2) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return (int)((float)n2 * displayMetrics.density);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void installWithRoot(final FinishedApk finishedApk) {
        try {
            DataOutputStream dataOutputStream;
            Process process;
            final Context context = Aptoide.getContext();
            final NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            if (!Aptoide.IS_SYSTEM) {
                process = Runtime.getRuntime().exec("su");
                dataOutputStream = new DataOutputStream(process.getOutputStream());
                dataOutputStream.writeBytes("pm install -r \"" + finishedApk.getPath() + "\"\n");
                dataOutputStream.flush();
            } else {
                process = Runtime.getRuntime().exec("pm install -r " + finishedApk.getPath());
                dataOutputStream = new DataOutputStream(process.getOutputStream());
            }
            NotificationCompat.Builder builder = new NotificationCompat.Builder(context);
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setFlags(0x10000000);
            intent.setDataAndType(Uri.fromFile((File)new File(finishedApk.getPath())), "application/vnd.android.package-archive");
            PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)intent, (int)0);
            NotificationCompat.Builder builder2 = builder.setContentTitle(Aptoide.getConfiguration().getMarketName());
            int n2 = R.string.installing;
            Object[] objectArray = new Object[]{finishedApk.getName()};
            builder2.setContentText(context.getString(n2, objectArray));
            int n3 = DownloadExecutorImpl.dpToPixels(context, 36);
            builder.setLargeIcon(DownloadExecutorImpl.decodeSampledBitmapFromResource(ImageLoader.getInstance().getDiscCache().get(finishedApk.getIconPath()).getAbsolutePath(), n3, n3));
            builder.setSmallIcon(0x1080081);
            builder.setContentIntent(pendingIntent);
            builder.setAutoCancel(true);
            notificationManager.notify((int)finishedApk.getAppHashId(), builder.build());
            new Thread(new Runnable(){

                /*
                 * Loose catch block
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    try {
                        int n2;
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                        char[] cArray = new char[4096];
                        StringBuilder stringBuilder = new StringBuilder();
                        while ((n2 = bufferedReader.read(cArray)) > 0) {
                            stringBuilder.append(cArray, 0, n2);
                        }
                        bufferedReader.close();
                        process.waitFor();
                        String string2 = stringBuilder.toString();
                        if (process.exitValue() != 255 && !string2.toLowerCase(Locale.ENGLISH).contains("failure") && !string2.toLowerCase(Locale.ENGLISH).contains("segmentation")) {
                            Log.e((String)"MYTAG-CENAS", (String)String.valueOf(process.exitValue() + " " + string2.toString()));
                            NotificationCompat.Builder builder = new NotificationCompat.Builder(context);
                            Intent intent = context.getPackageManager().getLaunchIntentForPackage(finishedApk.getApkid());
                            if (intent == null) {
                                notificationManager.cancel((int)finishedApk.getAppHashId());
                                intent = new Intent();
                                context.getPackageManager().getPackageInfo(finishedApk.getApkid(), 0);
                            }
                            PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)intent, (int)0);
                            NotificationCompat.Builder builder2 = builder.setContentTitle(Aptoide.getConfiguration().getMarketName());
                            Context context2 = context;
                            int n3 = R.string.finished_install;
                            Object[] objectArray = new Object[]{finishedApk.getName()};
                            builder2.setContentText(context2.getString(n3, objectArray));
                            int n4 = DownloadExecutorImpl.dpToPixels(context, 36);
                            builder.setLargeIcon(DownloadExecutorImpl.decodeSampledBitmapFromResource(ImageLoader.getInstance().getDiscCache().get(finishedApk.getIconPath()).getAbsolutePath(), n4, n4));
                            builder.setSmallIcon(17301634);
                            builder.setContentIntent(pendingIntent);
                            builder.setAutoCancel(true);
                            notificationManager.notify((int)finishedApk.getAppHashId(), builder.build());
                            if (Build.VERSION.SDK_INT < 11) return;
                            context.getPackageManager().setInstallerPackageName(finishedApk.getApkid(), context.getPackageName());
                            return;
                            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                                Log.e((String)"MYTAG-CENAS", (String)"Package not found");
                                Intent intent2 = new Intent("android.intent.action.VIEW");
                                intent2.setFlags(0x10000000);
                                intent2.setDataAndType(Uri.fromFile((File)new File(finishedApk.getPath())), "application/vnd.android.package-archive");
                                Log.d((String)"Aptoide", (String)("Installing app: " + finishedApk.getPath()));
                                context.startActivity(intent2);
                                return;
                            }
                        }
                        notificationManager.cancel((int)finishedApk.getAppHashId());
                        Intent intent = new Intent("android.intent.action.VIEW");
                        intent.setFlags(0x10000000);
                        intent.setDataAndType(Uri.fromFile((File)new File(finishedApk.getPath())), "application/vnd.android.package-archive");
                        Log.d((String)"Aptoide", (String)("Installing app: " + finishedApk.getPath()));
                        context.startActivity(intent);
                        return;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        notificationManager.cancel((int)finishedApk.getAppHashId());
                        Intent intent = new Intent("android.intent.action.VIEW");
                        intent.setFlags(0x10000000);
                        intent.setDataAndType(Uri.fromFile((File)new File(finishedApk.getPath())), "application/vnd.android.package-archive");
                        Log.d((String)"Aptoide", (String)("Installing app: " + finishedApk.getPath()));
                        context.startActivity(intent);
                        return;
                    }
                }
            }).start();
            if (Aptoide.IS_SYSTEM) return;
            dataOutputStream.writeBytes("exit\n");
            dataOutputStream.flush();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute() {
        Context context;
        block3: {
            context = Aptoide.getContext();
            Database database = new Database(Aptoide.getDb());
            try {
                PackageInfo packageInfo = context.getPackageManager().getPackageInfo(this.apk.getApkid(), 0);
                File file = new File(packageInfo.applicationInfo.sourceDir);
                String string2 = AptoideUtils.Algorithms.md5Calc(file);
                database.insertRollbackAction(new RollBackItem(this.apk.getName(), this.apk.getApkid(), this.apk.getVersion(), packageInfo.versionName, this.apk.getIconPath(), null, string2, RollBackItem.Action.UPDATING));
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                if (database.updateDowngradingAction(this.apk.getApkid())) break block3;
                database.insertRollbackAction(new RollBackItem(this.apk.getName(), this.apk.getApkid(), this.apk.getVersion(), null, this.apk.getIconPath(), null, null, RollBackItem.Action.INSTALLING));
            }
        }
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)Aptoide.getContext());
        if (Aptoide.IS_SYSTEM || sharedPreferences.getBoolean("allowRoot", true) && DownloadExecutorImpl.canRunRootCommands() && !this.apk.getApkid().equals(context.getPackageName())) {
            Intent intent = new Intent(context, PermissionsActivity.class);
            intent.setFlags(0x18000000);
            intent.putExtra("apk", (Parcelable)this.apk);
            intent.putStringArrayListExtra("permissions", this.apk.getPermissionsList());
            context.startActivity(intent);
            return;
        }
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setFlags(0x10000000);
        intent.setDataAndType(Uri.fromFile((File)new File(this.path)), "application/vnd.android.package-archive");
        Log.d((String)"Aptoide", (String)("Installing app: " + this.path));
        context.startActivity(intent);
    }
}

