/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.downloadmanager;

import android.util.Log;
import cm.aptoide.ptdev.Aptoide;
import cm.aptoide.ptdev.downloadmanager.CompletedDownloadException;
import cm.aptoide.ptdev.downloadmanager.ContentTypeNotApkException;
import cm.aptoide.ptdev.downloadmanager.DownloadConnection;
import cm.aptoide.ptdev.downloadmanager.IPBlackListedException;
import cm.aptoide.ptdev.downloadmanager.NotFoundException;
import cm.aptoide.ptdev.utils.AptoideUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import org.acra.ACRA;

public class DownloadConnectionImpl
extends DownloadConnection
implements Serializable {
    private static final int TIME_OUT = 30000;
    HttpURLConnection connection;
    private BufferedInputStream mStream;

    public DownloadConnectionImpl(URL uRL) throws IOException {
        super(uRL);
    }

    @Override
    public void close() {
        this.connection.disconnect();
    }

    @Override
    public void connect(long l2) throws IOException, CompletedDownloadException, NotFoundException, IPBlackListedException, ContentTypeNotApkException {
        this.connection = (HttpURLConnection)this.mURL.openConnection();
        this.connection.setConnectTimeout(30000);
        this.connection.setReadTimeout(30000);
        this.connection.setRequestProperty("User-Agent", AptoideUtils.NetworkUtils.getUserAgentString(Aptoide.getContext()));
        Log.d((String)"DownloadManager", (String)("Downloading from: " + this.mURL.toString() + " with " + AptoideUtils.NetworkUtils.getUserAgentString(Aptoide.getContext())));
        if (l2 > 0L) {
            this.connection.addRequestProperty("Range", "bytes=" + l2 + "-");
            int n2 = this.connection.getResponseCode();
            Log.d((String)"DownloadManager", (String)("Response Code is: " + n2));
            if (n2 == 416) {
                throw new CompletedDownloadException();
            }
            if (n2 != 206) {
                throw new IOException("Server doesn't support partial content.");
            }
        } else if (this.connection.getResponseCode() != 200) {
            int n3 = this.connection.getResponseCode();
            if (n3 == 404) {
                throw new NotFoundException();
            }
            if (n3 == 403) {
                ACRA.getErrorReporter().handleException(new Exception("403 on " + this.mURL.toString()));
                throw new IPBlackListedException();
            }
            throw new IOException("Cannot retrieve file from server.");
        }
        if ("application/json".equals(this.connection.getHeaderField("Content-Type"))) {
            throw new ContentTypeNotApkException();
        }
        this.mStream = new BufferedInputStream(this.connection.getInputStream(), 8192);
    }

    @Override
    public long getShallowSize() throws IOException {
        return this.mURL.openConnection().getContentLength();
    }

    @Override
    public BufferedInputStream getStream() {
        return this.mStream;
    }
}

