/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.dialogs;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.app.DialogFragment;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.Toast;
import cm.aptoide.ptdev.Aptoide;
import cm.aptoide.ptdev.R;
import cm.aptoide.ptdev.dialogs.AptoideDialog;
import cm.aptoide.ptdev.dialogs.ProgressDialogFragment;
import cm.aptoide.ptdev.downloadmanager.Utils;
import cm.aptoide.ptdev.model.Login;
import cm.aptoide.ptdev.model.ResponseCode;
import cm.aptoide.ptdev.model.Store;
import cm.aptoide.ptdev.services.CheckServerRequest;
import cm.aptoide.ptdev.services.HttpClientSpiceService;
import cm.aptoide.ptdev.utils.AptoideUtils;
import cm.aptoide.ptdev.utils.IconSizes;
import cm.aptoide.ptdev.webservices.GetRepositoryInfoRequest;
import cm.aptoide.ptdev.webservices.json.RepositoryInfoJson;
import com.octo.android.robospice.SpiceManager;
import com.octo.android.robospice.persistence.exception.SpiceException;
import com.octo.android.robospice.request.listener.PendingRequestListener;
import com.octo.android.robospice.request.listener.RequestCancellationListener;
import com.octo.android.robospice.request.listener.RequestListener;

public class AddStoreDialog
extends DialogFragment {
    private Callback callback;
    public ProgressDialogFragment.OnCancelListener cancelListener;
    private CheckServerRequest checkServerRequest;
    public Callback dummyCallback;
    private GetRepositoryInfoRequest getRepoInfoRequest;
    private Login login;
    private String repoName;
    private SpiceManager spiceManager = new SpiceManager(HttpClientSpiceService.class);
    private String url;

    public AddStoreDialog() {
        this.dummyCallback = new Callback(){

            @Override
            public void startParse(Store store) {
            }
        };
        this.cancelListener = new ProgressDialogFragment.OnCancelListener(){

            @Override
            public void onCancel() {
                Log.i((String)"Aptoide-", (String)("Canceling:" + AddStoreDialog.this.url + "rc"));
                Log.i((String)"Aptoide-", (String)("Canceling:" + AddStoreDialog.this.url + "repositoryInfo"));
                if (AddStoreDialog.this.checkServerRequest != null) {
                    AddStoreDialog.this.checkServerRequest.cancel();
                }
            }
        };
    }

    private void showDialog() {
        AptoideDialog.pleaseWaitDialog().show(this.getFragmentManager(), "addStoreProgress");
    }

    void dismissDialog() {
        this.setRetainInstance(false);
        DialogFragment dialogFragment = (DialogFragment)this.getFragmentManager().findFragmentByTag("addStoreProgress");
        if (dialogFragment != null) {
            dialogFragment.dismissAllowingStateLoss();
        }
    }

    void dismissDialog(String string2) {
        if (string2 != null) {
            // empty if block
        }
        this.dismissDialog();
    }

    public void get(String string2, Login login) {
        this.url = AptoideUtils.checkStoreUrl(string2);
        this.login = login;
        this.repoName = AptoideUtils.RepoUtils.split(this.url);
        this.checkServerRequest = new CheckServerRequest(this.url, login);
        CheckStoreListener checkStoreListener = new CheckStoreListener(login);
        this.setRetainInstance(true);
        this.spiceManager.execute(this.checkServerRequest, checkStoreListener);
        this.checkServerRequest.setRequestCancellationListener(new RequestCancellationListener(){

            @Override
            public void onRequestCancelled() {
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        Toast.makeText((Context)AddStoreDialog.this.getActivity(), (CharSequence)"Request2 was canceled", (int)1).show();
                    }
                });
            }
        });
        Log.i((String)"Aptoide-", (String)("Request:" + this.url + "rc"));
    }

    @Override
    public void onActivityResult(int n2, int n3, Intent intent) {
        super.onActivityResult(n2, n3, intent);
        switch (n2) {
            default: {
                return;
            }
            case 20: 
        }
        String string2 = intent.getStringExtra("username");
        String string3 = intent.getStringExtra("password");
        Login login = new Login();
        login.setUsername(string2.trim());
        login.setPassword(string3.trim());
        this.get(this.url, login);
        this.showDialog();
    }

    @Override
    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.callback = (Callback)activity;
    }

    @Override
    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        if (bundle != null) {
            this.url = bundle.getString("url");
            ProgressDialogFragment cfr_ignored_0 = (ProgressDialogFragment)this.getFragmentManager().findFragmentByTag("addStoreProgress");
        }
    }

    @Override
    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        if (this.getDialog() != null) {
            this.getDialog().getWindow().setTitle((CharSequence)this.getString(R.string.add_store));
        }
        return layoutInflater.inflate(R.layout.dialog_add_store, viewGroup, false);
    }

    @Override
    public void onDetach() {
        super.onDetach();
        this.callback = this.dummyCallback;
    }

    @Override
    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putString("url", this.url);
    }

    @Override
    public void onStart() {
        super.onStart();
        this.spiceManager.start((Context)this.getActivity());
        if (this.url != null) {
            this.spiceManager.addListenerIfPending(ResponseCode.class, (Object)(this.url + "rc"), new CheckStoreListener(this.login));
        }
    }

    @Override
    public void onStop() {
        if (this.spiceManager.isStarted()) {
            this.spiceManager.shouldStop();
        }
        super.onStop();
    }

    @Override
    public void onViewCreated(final View view, Bundle bundle) {
        super.onViewCreated(view, bundle);
        view.findViewById(R.id.button_dialog_add_store).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view2) {
                new Bundle();
                String string2 = ((EditText)view.findViewById(R.id.edit_store_uri)).getText().toString();
                AddStoreDialog.this.get(string2, null);
                AddStoreDialog.this.showDialog();
            }
        });
        view.findViewById(R.id.button_top_stores).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("http://m.aptoide.com/more/toprepos/q=" + Utils.filters((Context)AddStoreDialog.this.getActivity()))));
                if (AddStoreDialog.this.isAdded()) {
                    AddStoreDialog.this.dismiss();
                }
                AddStoreDialog.this.startActivity(intent);
            }
        });
    }

    public static interface Callback {
        public void startParse(Store var1);
    }

    public final class CheckStoreListener
    implements RequestListener<ResponseCode>,
    PendingRequestListener<ResponseCode> {
        private final Login login;

        public CheckStoreListener(Login login) {
            this.login = login;
        }

        @Override
        public void onRequestFailure(SpiceException spiceException) {
            AddStoreDialog.this.dismissDialog();
            Toast.makeText((Context)Aptoide.getContext(), (int)R.string.error_occured, (int)1).show();
        }

        @Override
        public void onRequestNotFound() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void onRequestSuccess(ResponseCode responseCode) {
            if (responseCode == null) return;
            Log.d((String)"Aptoide", (String)("Response was" + responseCode.responseCode));
            switch (responseCode.responseCode) {
                default: {
                    Toast.makeText((Context)Aptoide.getContext(), (int)R.string.error_occured, (int)1).show();
                    AddStoreDialog.this.dismissDialog();
                    return;
                }
                case 401: {
                    AddStoreDialog.this.dismissDialog("Private store found");
                    DialogFragment dialogFragment = AptoideDialog.passwordDialog();
                    dialogFragment.setTargetFragment(AddStoreDialog.this, 20);
                    dialogFragment.show(AddStoreDialog.this.getFragmentManager(), "passDialog");
                    return;
                }
                case -1: {
                    Toast.makeText((Context)Aptoide.getContext(), (int)R.string.error_occured, (int)1).show();
                    AddStoreDialog.this.dismissDialog("Invalid Store added.");
                    return;
                }
                case 0: 
            }
            if (!AddStoreDialog.this.url.endsWith(".store.aptoide.com/")) {
                Store store = new Store();
                store.setBaseUrl(AddStoreDialog.this.url);
                store.setName(AddStoreDialog.this.url);
                store.setLogin(this.login);
                AddStoreDialog.this.callback.startParse(store);
                AddStoreDialog.this.dismissDialog();
                return;
            }
            Store store = new Store();
            store.setLogin(this.login);
            store.setBaseUrl(AddStoreDialog.this.url);
            store.setName(AptoideUtils.RepoUtils.split(AddStoreDialog.this.url));
            AddStoreDialog.this.callback.startParse(store);
            AddStoreDialog.this.dismissDialog();
            AddStoreDialog.this.dismiss();
        }
    }

    public final class RepositoryRequestListener
    implements RequestListener<RepositoryInfoJson>,
    RequestCancellationListener {
        private final Login login;
        private final String url;

        public RepositoryRequestListener(String string2, Login login) {
            this.url = string2;
            this.login = login;
        }

        @Override
        public void onRequestCancelled() {
            Toast.makeText((Context)Aptoide.getContext(), (CharSequence)"Request was canceled", (int)1).show();
        }

        @Override
        public void onRequestFailure(SpiceException spiceException) {
            AddStoreDialog.this.dismissDialog("Unable to add store.");
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onRequestSuccess(RepositoryInfoJson repositoryInfoJson) {
            block6: {
                block5: {
                    Log.i((String)"Aptoide-", (String)"success");
                    if (repositoryInfoJson == null) break block5;
                    if (!"FAIL".equals(repositoryInfoJson.getStatus())) break block6;
                    AddStoreDialog.this.dismissDialog("Store doesn't exist.");
                }
                return;
            }
            Store store = new Store();
            store.setName(repositoryInfoJson.getListing().getName());
            store.setDownloads(repositoryInfoJson.getListing().getDownloads());
            if (repositoryInfoJson.getListing().getAvatar_hd() != null) {
                String string2 = IconSizes.generateSizeStringAvatar((Context)AddStoreDialog.this.getActivity());
                String[] stringArray = repositoryInfoJson.getListing().getAvatar_hd().split("\\.(?=[^\\.]+$)");
                store.setAvatar(stringArray[0] + "_" + string2 + "." + stringArray[1]);
            } else {
                store.setAvatar(repositoryInfoJson.getListing().getAvatar());
            }
            store.setDescription(repositoryInfoJson.getListing().getDescription());
            store.setTheme(repositoryInfoJson.getListing().getTheme());
            store.setView(repositoryInfoJson.getListing().getView());
            store.setItems(repositoryInfoJson.getListing().getItems());
            AddStoreDialog.this.callback.startParse(store);
        }
    }
}

