/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.database.schema;

import cm.aptoide.ptdev.database.schema.OnConflict;
import cm.aptoide.ptdev.database.schema.SQLType;
import cm.aptoide.ptdev.database.schema.anotations.ColumnDefinition;
import cm.aptoide.ptdev.database.schema.anotations.TableDefinition;

public class Schema {

    @TableDefinition(indexes={@TableDefinition.Index(index_name="nameIdx", keys={@TableDefinition.Key(descending=true, field="name")}), @TableDefinition.Index(index_name="repoIdx", keys={@TableDefinition.Key(field="id_repo")})}, uniques={@TableDefinition.Composite_Unique(fields={"package_name", "version_code", "id_repo"})})
    public static class Apk {
        @ColumnDefinition(type=SQLType.TEXT)
        public static final String COLUMN_APKID = "package_name";
        @ColumnDefinition(type=SQLType.TEXT)
        public static final String COLUMN_DATE = "date";
        @ColumnDefinition(type=SQLType.INTEGER)
        public static final String COLUMN_DOWNLOADS = "downloads";
        @ColumnDefinition(type=SQLType.TEXT)
        public static final String COLUMN_GLES = "gles";
        @ColumnDefinition(type=SQLType.TEXT)
        public static final String COLUMN_ICON = "icon";
        @ColumnDefinition(autoIncrement=true, primaryKey=true, type=SQLType.INTEGER)
        public static final String COLUMN_ID = "id_apk";
        @ColumnDefinition(type=SQLType.BOOLEAN)
        public static final String COLUMN_IS_COMPATIBLE = "is_compatible";
        @ColumnDefinition(type=SQLType.TEXT)
        public static final String COLUMN_MATURE = "mature";
        @ColumnDefinition(type=SQLType.TEXT)
        public static final String COLUMN_MD5 = "md5";
        @ColumnDefinition(defaultValue="", type=SQLType.TEXT)
        public static final String COLUMN_NAME = "name";
        @ColumnDefinition(type=SQLType.TEXT)
        public static final String COLUMN_PATH = "path";
        @ColumnDefinition(defaultValue="0", type=SQLType.FLOAT)
        public static final String COLUMN_PRICE = "price";
        @ColumnDefinition(type=SQLType.TEXT)
        public static final String COLUMN_RATING = "rating";
        @ColumnDefinition(type=SQLType.INTEGER)
        public static final String COLUMN_REPO_ID = "id_repo";
        @ColumnDefinition(type=SQLType.TEXT)
        public static final String COLUMN_SCREEN = "screen";
        @ColumnDefinition(type=SQLType.INTEGER)
        public static final String COLUMN_SDK = "sdk";
        @ColumnDefinition(defaultValue="", type=SQLType.TEXT)
        public static final String COLUMN_SIGNATURE = "signature";
        @ColumnDefinition(defaultValue="0", type=SQLType.INTEGER)
        public static final String COLUMN_VERCODE = "version_code";
        @ColumnDefinition(defaultValue="", type=SQLType.TEXT)
        public static final String COLUMN_VERNAME = "version_name";

        public static String getName() {
            return "apk";
        }
    }

    @TableDefinition(uniques={@TableDefinition.Composite_Unique(fields={"id_real_category", "id_repo", "id_category_parent"})})
    public static class Category {
        @ColumnDefinition(type=SQLType.INTEGER)
        public static final String COLUMN_APPS_COUNT = "apps_count";
        @ColumnDefinition(type=SQLType.INTEGER)
        public static final String COLUMN_ID_PARENT = "id_category_parent";
        @ColumnDefinition(type=SQLType.TEXT)
        public static final String COLUMN_NAME = "name";
        @ColumnDefinition(type=SQLType.INTEGER)
        public static final String COLUMN_REPO_ID = "id_repo";
        @ColumnDefinition(type=SQLType.INTEGER)
        public static final String COLUMN_RID = "id_real_category";

        public static String getName() {
            return "category";
        }
    }

    @TableDefinition(indexes={@TableDefinition.Index(index_name="category_apk_id_apk", keys={@TableDefinition.Key(field="id_apk")})}, uniques={@TableDefinition.Composite_Unique(fields={"id_real_category", "id_apk", "id_repo"})})
    public static class Category_Apk {
        @ColumnDefinition(type=SQLType.INTEGER)
        public static final String COLUMN_APK_ID = "id_apk";
        @ColumnDefinition(type=SQLType.INTEGER)
        public static final String COLUMN_CATEGORY_ID = "id_real_category";
        @ColumnDefinition(type=SQLType.INTEGER)
        public static final String COLUMN_REPO_ID = "id_repo";

        public static String getName() {
            return "category_apk";
        }
    }

    public static class Excluded {
        @ColumnDefinition(type=SQLType.TEXT)
        public static final String COLUMN_ICONPATH = "iconpath";
        @ColumnDefinition(type=SQLType.TEXT)
        public static final String COLUMN_NAME = "name";
        @ColumnDefinition(type=SQLType.TEXT)
        public static final String COLUMN_PACKAGE_NAME = "package_name";
        @ColumnDefinition(type=SQLType.INTEGER)
        public static final String COLUMN_VERCODE = "vercode";

        public static String getName() {
            return "excluded";
        }
    }

    @TableDefinition(uniques={@TableDefinition.Composite_Unique(fields={"id_editors", "id_apk"})})
    public static class Featured_Apk {
        @ColumnDefinition(type=SQLType.INTEGER)
        public static final String COLUMN_APK_ID = "id_apk";
        @ColumnDefinition(type=SQLType.TEXT)
        public static final String COLUMN_CATEGORY = "category";
        @ColumnDefinition(autoIncrement=true, primaryKey=true, type=SQLType.INTEGER)
        public static final String COLUMN_EDITORS_ID = "id_editors";
        @ColumnDefinition(type=SQLType.TEXT)
        public static final String COLUMN_TYPE = "type";

        public static String getName() {
            return "featured_apk";
        }
    }

    @TableDefinition(indexes={@TableDefinition.Index(index_name="installedIdx", keys={@TableDefinition.Key(field="package_name")})})
    public static class Installed {
        @ColumnDefinition(onConflict=OnConflict.REPLACE, type=SQLType.TEXT, unique=true)
        public static final String COLUMN_APKID = "package_name";
        @ColumnDefinition(autoIncrement=true, primaryKey=true, type=SQLType.INTEGER)
        public static final String COLUMN_ID = "id_installed";
        @ColumnDefinition(type=SQLType.TEXT)
        public static final String COLUMN_NAME = "name";
        @ColumnDefinition(defaultValue="", type=SQLType.TEXT)
        public static final String COLUMN_SIGNATURE = "signature";
        @ColumnDefinition(defaultValue="0", type=SQLType.INTEGER)
        public static final String COLUMN_VERCODE = "version_code";
        @ColumnDefinition(defaultValue="", type=SQLType.INTEGER)
        public static final String COLUMN_VERNAME = "version_name";

        public static String getName() {
            return "installed";
        }
    }

    public static class Repo {
        @ColumnDefinition(type=SQLType.TEXT)
        public static final String COLUMN_APK_PATH = "apk_path";
        @ColumnDefinition(type=SQLType.TEXT)
        public static final String COLUMN_AVATAR = "avatar_url";
        @ColumnDefinition(type=SQLType.TEXT)
        public static final String COLUMN_DESCRIPTION = "description";
        @ColumnDefinition(type=SQLType.INTEGER)
        public static final String COLUMN_DOWNLOADS = "downloads";
        @ColumnDefinition(type=SQLType.BOOLEAN)
        public static final String COLUMN_FAILED = "is_failed";
        @ColumnDefinition(type=SQLType.TEXT)
        public static final String COLUMN_HASH = "hash";
        @ColumnDefinition(type=SQLType.TEXT)
        public static final String COLUMN_ICONS_PATH = "icons_path";
        @ColumnDefinition(autoIncrement=true, primaryKey=true, type=SQLType.INTEGER)
        public static final String COLUMN_ID = "id_repo";
        @ColumnDefinition(type=SQLType.BOOLEAN)
        public static final String COLUMN_IS_USER = "is_user";
        @ColumnDefinition(type=SQLType.TEXT)
        public static final String COLUMN_ITEMS = "items";
        @ColumnDefinition(type=SQLType.INTEGER)
        public static final String COLUMN_LATEST_TIMESTAMP = "latest_timestamp";
        @ColumnDefinition(type=SQLType.TEXT)
        public static final String COLUMN_NAME = "name";
        @ColumnDefinition(type=SQLType.TEXT)
        public static final String COLUMN_PASSWORD = "password";
        @ColumnDefinition(type=SQLType.TEXT)
        public static final String COLUMN_THEME = "theme";
        @ColumnDefinition(type=SQLType.INTEGER)
        public static final String COLUMN_TOP_TIMESTAMP = "top_timestamp";
        @ColumnDefinition(type=SQLType.TEXT)
        public static final String COLUMN_URL = "url";
        @ColumnDefinition(type=SQLType.TEXT)
        public static final String COLUMN_USERNAME = "username";
        @ColumnDefinition(type=SQLType.TEXT)
        public static final String COLUMN_VIEW = "list";
        @ColumnDefinition(type=SQLType.TEXT)
        public static final String COLUMN_WEBSERVICES_PATH = "webservices_path";

        public static String getName() {
            return "repo";
        }
    }

    @TableDefinition(indexes={@TableDefinition.Index(index_name="RollbackIdx", keys={@TableDefinition.Key(field="package_name")})})
    public static class RollbackTbl {
        @ColumnDefinition(type=SQLType.TEXT)
        public static final String COLUMN_ACTION = "action";
        @ColumnDefinition(type=SQLType.TEXT)
        public static final String COLUMN_APKID = "package_name";
        @ColumnDefinition(type=SQLType.INTEGER)
        public static final String COLUMN_CONFIRMED = "confirmed";
        @ColumnDefinition(type=SQLType.TEXT)
        public static final String COLUMN_ICONPATH = "icon_path";
        @ColumnDefinition(defaultValue="", type=SQLType.TEXT)
        public static final String COLUMN_MD5 = "md5";
        @ColumnDefinition(type=SQLType.TEXT)
        public static final String COLUMN_NAME = "name";
        @ColumnDefinition(type=SQLType.TEXT)
        public static final String COLUMN_PREVIOUS_VERSION = "previous_version";
        @ColumnDefinition(type=SQLType.TEXT)
        public static final String COLUMN_TIMESTAMP = "timestamp";
        @ColumnDefinition(type=SQLType.TEXT)
        public static final String COLUMN_VERSION = "version";

        public static String getName() {
            return "rollbacktbl";
        }
    }

    public static class Scheduled {
        @ColumnDefinition(type=SQLType.TEXT)
        public static final String COLUMN_ICON = "icon";
        @ColumnDefinition(type=SQLType.TEXT)
        public static final String COLUMN_MD5 = "md5";
        @ColumnDefinition(type=SQLType.TEXT)
        public static final String COLUMN_NAME = "name";
        @ColumnDefinition(type=SQLType.TEXT)
        public static final String COLUMN_PACKAGE_NAME = "package_name";
        @ColumnDefinition(type=SQLType.TEXT)
        public static final String COLUMN_REPO = "repo_name";
        @ColumnDefinition(type=SQLType.TEXT)
        public static final String COLUMN_VERSION_NAME = "version_name";

        public static String getName() {
            return "scheduled";
        }
    }
}

