/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.database;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.preference.PreferenceManager;
import android.util.Log;
import cm.aptoide.ptdev.Aptoide;
import cm.aptoide.ptdev.database.schema.OnConflict;
import cm.aptoide.ptdev.database.schema.SQLType;
import cm.aptoide.ptdev.database.schema.Schema;
import cm.aptoide.ptdev.database.schema.anotations.ColumnDefinition;
import cm.aptoide.ptdev.database.schema.anotations.TableDefinition;
import cm.aptoide.ptdev.model.Login;
import cm.aptoide.ptdev.model.Server;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;

public class DatabaseHelper
extends SQLiteOpenHelper {
    private static final String TAG = "DatabaseHelper";
    private static DatabaseHelper sInstance;
    private boolean primaryKeyDefined;

    private DatabaseHelper(Context context) {
        super(context, "aptoide.db", null, 21);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void createDb(SQLiteDatabase sQLiteDatabase) throws IllegalAccessException {
        Class<?>[] classArray = Schema.class.getDeclaredClasses();
        int n2 = classArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Class<?> clazz = classArray[n3];
            this.primaryKeyDefined = false;
            Field[] fieldArray = clazz.getDeclaredFields();
            TableDefinition tableDefinition = clazz.getAnnotation(TableDefinition.class);
            String string2 = "CREATE TABLE " + clazz.getSimpleName().toLowerCase(Locale.ENGLISH) + " (";
            Iterator<Field> iterator = Arrays.asList(fieldArray).iterator();
            while (iterator.hasNext()) {
                Field field = iterator.next();
                ColumnDefinition columnDefinition = field.getAnnotation(ColumnDefinition.class);
                field.setAccessible(true);
                String string3 = string2 + field.get(null) + " " + (Object)((Object)field.getAnnotation(ColumnDefinition.class).type());
                if (!columnDefinition.defaultValue().equals("")) {
                    string3 = string3 + " DEFAULT \"" + columnDefinition.defaultValue() + "\"";
                }
                string2 = string3 + this.getColumnConstraints(columnDefinition);
                if (!iterator.hasNext()) continue;
                string2 = string2 + ", ";
            }
            if (!this.primaryKeyDefined) {
                if (tableDefinition != null && tableDefinition.primaryKey().length != 0) {
                    String string4 = string2 + ", ";
                    string2 = string4 + this.getPrimaryKey(tableDefinition);
                }
            } else if (tableDefinition != null && tableDefinition.primaryKey().length != 0) {
                throw new IllegalArgumentException("PRIMARY KEY defined twice, at column and table level!");
            }
            if (tableDefinition != null && tableDefinition.uniques().length != 0) {
                String string5 = string2 + ", ";
                string2 = string5 + this.getCompositeUniques(tableDefinition);
            }
            sQLiteDatabase.execSQL(string2 + ")");
            if (tableDefinition != null) {
                this.createTableIndexes(tableDefinition, clazz.getSimpleName(), sQLiteDatabase);
            }
            ++n3;
        }
        return;
    }

    private void createTableIndexes(TableDefinition tableDefinition, String string2, SQLiteDatabase sQLiteDatabase) {
        Iterator<TableDefinition.Index> iterator = Arrays.asList(tableDefinition.indexes()).iterator();
        while (iterator.hasNext()) {
            String string3 = "CREATE ";
            TableDefinition.Index index = iterator.next();
            if (index.unique()) {
                string3 = string3 + "UNIQUE ";
            }
            String string4 = string3 + "INDEX " + index.index_name() + " ON " + string2 + " (";
            Iterator<TableDefinition.Key> iterator2 = Arrays.asList(index.keys()).iterator();
            while (iterator2.hasNext()) {
                TableDefinition.Key key = iterator2.next();
                string4 = string4 + key.field();
                if (key.descending()) {
                    string4 = string4 + " DESC";
                }
                if (!iterator2.hasNext()) continue;
                string4 = string4 + ", ";
            }
            sQLiteDatabase.execSQL(string4 + ");");
        }
    }

    private void dropIndexes(SQLiteDatabase sQLiteDatabase) {
        Class<?>[] classArray = Schema.class.getDeclaredClasses();
        int n2 = classArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            TableDefinition tableDefinition = classArray[i2].getAnnotation(TableDefinition.class);
            if (tableDefinition == null) continue;
            for (TableDefinition.Index index : tableDefinition.indexes()) {
                sQLiteDatabase.execSQL("DROP INDEX IF EXISTS " + index.index_name());
            }
        }
    }

    private void dropTables(SQLiteDatabase sQLiteDatabase) {
        for (Class<?> clazz : Schema.class.getDeclaredClasses()) {
            sQLiteDatabase.execSQL("DROP TABLE IF EXISTS " + clazz.getSimpleName().toLowerCase(Locale.ENGLISH));
        }
    }

    private String getColumnConstraints(ColumnDefinition columnDefinition) {
        String string2 = "";
        if (columnDefinition.primaryKey()) {
            if (this.primaryKeyDefined) {
                throw new IllegalArgumentException("Can only define one PRIMARY KEY, to define a composite PRIMARY KEY, use @TableDefinition annotation");
            }
            this.primaryKeyDefined = true;
            string2 = string2 + " PRIMARY KEY";
        }
        if (columnDefinition.autoIncrement()) {
            if (!columnDefinition.primaryKey() || columnDefinition.type() != SQLType.INTEGER) {
                throw new IllegalArgumentException("AUTOINCREMENT only allowed to PRIMARY KEYs with type INTEGER");
            }
            string2 = string2 + " AUTOINCREMENT";
        }
        if (columnDefinition.unique()) {
            string2 = string2 + " UNIQUE";
        }
        if (columnDefinition.notNull()) {
            string2 = string2 + " NOT NULL";
        }
        if (!columnDefinition.onConflict().equals((Object)OnConflict.NONE)) {
            string2 = string2 + " ON CONFLICT " + columnDefinition.onConflict().name();
        }
        return string2;
    }

    private String getCompositeUniques(TableDefinition tableDefinition) {
        TableDefinition.Composite_Unique[] composite_UniqueArray = tableDefinition.uniques();
        String string2 = "";
        Iterator<TableDefinition.Composite_Unique> iterator = Arrays.asList(composite_UniqueArray).iterator();
        while (iterator.hasNext()) {
            String string3 = "UNIQUE (";
            Iterator<String> iterator2 = Arrays.asList(iterator.next().fields()).iterator();
            while (iterator2.hasNext()) {
                string3 = string3 + iterator2.next();
                if (!iterator2.hasNext()) continue;
                string3 = string3 + ", ";
            }
            string2 = string3 + ")";
            if (!iterator.hasNext()) continue;
            string2 = string2 + ", ";
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DatabaseHelper getInstance(Context context) {
        synchronized (DatabaseHelper.class) {
            if (sInstance == null) {
                sInstance = new DatabaseHelper(context.getApplicationContext());
            }
            return sInstance;
        }
    }

    private String getPrimaryKey(TableDefinition tableDefinition) {
        String[] stringArray = tableDefinition.primaryKey();
        String string2 = "PRIMARY KEY (";
        Iterator<String> iterator = Arrays.asList(stringArray).iterator();
        while (iterator.hasNext()) {
            string2 = string2 + iterator.next();
            if (!iterator.hasNext()) continue;
            string2 = string2 + ", ";
        }
        return string2 + ")";
    }

    private void removeSharedPreferences() {
        PreferenceManager.getDefaultSharedPreferences((Context)Aptoide.getContext()).edit().remove("editorschoiceTimestamp").remove("topappsTimestamp").commit();
    }

    public void onCreate(SQLiteDatabase sQLiteDatabase) {
        try {
            this.createDb(sQLiteDatabase);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n2, int n3) {
        Log.d((String)TAG, (String)"DatabaseHelper onUpgrade()");
        ArrayList<Server> arrayList = new ArrayList<Server>();
        if (n2 == 13) {
            try {
                Cursor cursor = sQLiteDatabase.query("repo", new String[]{"url", "name", "username", "password"}, null, null, null, null, null);
                cursor.moveToFirst();
                while (!cursor.isAfterLast()) {
                    Server server = new Server();
                    server.setUrl(cursor.getString(0));
                    server.setName(cursor.getString(1));
                    if (cursor.getString(2) != null) {
                        server.login = new Login();
                        server.login.setUsername(cursor.getString(2));
                        server.login.setPassword(cursor.getString(3));
                    }
                    arrayList.add(server);
                    cursor.moveToNext();
                }
                cursor.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.dropIndexes(sQLiteDatabase);
        this.dropTables(sQLiteDatabase);
        try {
            this.createDb(sQLiteDatabase);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        if (n2 == 13) {
            for (Server server : arrayList) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("name", server.getName());
                contentValues.put("is_user", Boolean.valueOf(true));
                contentValues.put("url", server.getUrl());
                if (server.login != null) {
                    contentValues.put("username", server.login.getUsername());
                    contentValues.put("password", server.login.getPassword());
                }
                sQLiteDatabase.insert(Schema.Repo.getName(), null, contentValues);
            }
        }
        this.removeSharedPreferences();
    }
}

