/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.database;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteStatement;
import android.preference.PreferenceManager;
import android.util.Log;
import cm.aptoide.ptdev.Aptoide;
import cm.aptoide.ptdev.StoreActivity;
import cm.aptoide.ptdev.database.StatementHelper;
import cm.aptoide.ptdev.database.schema.Schema;
import cm.aptoide.ptdev.fragments.HomeItem;
import cm.aptoide.ptdev.model.Apk;
import cm.aptoide.ptdev.model.Collection;
import cm.aptoide.ptdev.model.InstalledPackage;
import cm.aptoide.ptdev.model.Login;
import cm.aptoide.ptdev.model.RollBackItem;
import cm.aptoide.ptdev.model.Server;
import cm.aptoide.ptdev.model.Store;
import cm.aptoide.ptdev.utils.AptoideUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.joda.time.DateTime;
import org.joda.time.Weeks;

public class Database {
    private final SQLiteDatabase database;

    public Database(SQLiteDatabase sQLiteDatabase) {
        this.database = sQLiteDatabase;
        sQLiteDatabase.rawQuery("pragma synchronous = 0", null);
    }

    private long getAppsCount(long l2, long l3) {
        long l4 = 0L;
        SQLiteDatabase sQLiteDatabase = this.database;
        String[] stringArray = new String[]{String.valueOf(l2), String.valueOf(l3)};
        Cursor cursor = sQLiteDatabase.rawQuery("select id_real_category from category where id_category_parent = ? and id_repo = ?", stringArray);
        if (cursor.getCount() > 0) {
            while (cursor.moveToNext()) {
                l4 += this.getAppsCount(cursor.getLong(0), l3);
            }
        } else {
            SQLiteDatabase sQLiteDatabase2 = this.database;
            String[] stringArray2 = new String[]{String.valueOf(l2), String.valueOf(l3)};
            cursor = sQLiteDatabase2.rawQuery("select count(id_real_category) from category_apk where id_real_category = ? and id_repo = ?", stringArray2);
            if (cursor.moveToFirst()) {
                l4 = cursor.getInt(0);
            }
        }
        cursor.close();
        ContentValues contentValues = new ContentValues();
        contentValues.put("apps_count", Long.valueOf(l4));
        SQLiteDatabase sQLiteDatabase3 = this.database;
        String string2 = Schema.Category.getName();
        String[] stringArray3 = new String[]{String.valueOf(l2), String.valueOf(l3)};
        sQLiteDatabase3.update(string2, contentValues, "id_real_category = ? and id_repo = ?", stringArray3);
        return l4;
    }

    public void addToExcludeUpdate(long l2) {
        ContentValues contentValues = new ContentValues();
        Cursor cursor = null;
        try {
            cursor = this.getApkInfo(l2);
            if (cursor.moveToFirst()) {
                String string2 = cursor.getString(cursor.getColumnIndex("package_name"));
                int n2 = cursor.getInt(cursor.getColumnIndex("version_code"));
                String string3 = cursor.getString(cursor.getColumnIndex("name"));
                String string4 = cursor.getString(cursor.getColumnIndex("iconpath"));
                String string5 = cursor.getString(cursor.getColumnIndex("icon"));
                contentValues.put("package_name", string2);
                contentValues.put("vercode", Integer.valueOf(n2));
                contentValues.put("name", string3);
                contentValues.put("iconpath", string4 + string5);
                this.database.insert(Schema.Excluded.getName(), null, contentValues);
            }
            return;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    public Boolean clearCategories(long l2) {
        Log.d((String)"Aptoide-", (String)("Deleting categories " + l2));
        this.database.beginTransaction();
        SQLiteDatabase sQLiteDatabase = this.database;
        String[] stringArray = new String[]{String.valueOf(l2)};
        sQLiteDatabase.delete("category", "id_repo = ? and id_real_category != 500 and id_real_category != 501", stringArray);
        this.database.setTransactionSuccessful();
        this.database.endTransaction();
        return true;
    }

    public void clearInstalled() {
        this.database.delete(Schema.Installed.getName(), null, null);
    }

    public Boolean clearStore(long l2) {
        Log.d((String)"Aptoide-", (String)("Clearing " + l2));
        this.database.beginTransaction();
        SQLiteDatabase sQLiteDatabase = this.database;
        String[] stringArray = new String[]{String.valueOf(l2)};
        Cursor cursor = sQLiteDatabase.rawQuery("select id_real_category, name from category where id_repo = ? ", stringArray);
        cursor.moveToFirst();
        while (!cursor.isAfterLast()) {
            if (cursor.getString(1).equals("Top Apps") && cursor.getString(1).equals("Latest Apps")) {
                SQLiteDatabase sQLiteDatabase2 = this.database;
                String[] stringArray2 = new String[]{String.valueOf(cursor.getLong(0)), String.valueOf(l2)};
                sQLiteDatabase2.delete("category_apk", "id_real_category=? and id_repo = ?", stringArray2);
                Log.d((String)"Aptoide-", (String)("Deleting " + cursor.getLong(0)));
            }
            cursor.moveToNext();
        }
        cursor.close();
        this.database.setTransactionSuccessful();
        this.database.endTransaction();
        return true;
    }

    public List<SQLiteStatement> compileStatements(List<String> list) {
        ArrayList<SQLiteStatement> arrayList = new ArrayList<SQLiteStatement>(list.size());
        for (String string2 : list) {
            Log.d((String)"TAG1", (String)("Compiling statement: " + string2));
            arrayList.add(this.database.compileStatement(string2));
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void confirmRollBackAction(String string2, String string3, String string4) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("timestamp", Long.toString(System.currentTimeMillis() / 1000L));
        contentValues.put("action", string4);
        contentValues.put("confirmed", Integer.valueOf(1));
        int n2 = this.database.update(Schema.RollbackTbl.getName(), contentValues, "package_name = ? and action = ?", new String[]{string2, string3});
        StringBuilder stringBuilder = new StringBuilder().append("Trying to update ").append(string2).append(" with action completed ").append(string4).append(" RESULT: ");
        String string5 = n2 == 1 ? "Success" : "Fail";
        Log.d((String)"InstalledBroadcastReceiver", (String)stringBuilder.append(string5).toString());
    }

    public void deleteApk(String string2, int n2, long l2) {
        SQLiteDatabase sQLiteDatabase = this.database;
        String[] stringArray = new String[]{string2, String.valueOf(n2), String.valueOf(l2)};
        Cursor cursor = sQLiteDatabase.rawQuery("select id_apk from apk where package_name = ? and version_code = ? and id_repo = ?", stringArray);
        if (cursor.moveToFirst()) {
            SQLiteDatabase sQLiteDatabase2 = this.database;
            String string3 = Schema.Category_Apk.getName();
            String[] stringArray2 = new String[]{String.valueOf(cursor.getLong(cursor.getColumnIndex("id_apk")))};
            sQLiteDatabase2.delete(string3, "id_apk = ?", stringArray2);
        }
        SQLiteDatabase sQLiteDatabase3 = this.database;
        String string4 = Schema.Apk.getName();
        String[] stringArray3 = new String[]{string2, String.valueOf(n2), String.valueOf(l2)};
        sQLiteDatabase3.delete(string4, "package_name = ? and version_code = ? and id_repo = ?", stringArray3);
        cursor.close();
    }

    public void deleteFeatured(int n2) {
        Log.d((String)"Aptoide-Featured", (String)("Deleting featured " + n2));
        this.database.beginTransaction();
        SQLiteDatabase sQLiteDatabase = this.database;
        String string2 = Schema.Category_Apk.getName();
        String[] stringArray = new String[]{"id_apk"};
        String[] stringArray2 = new String[]{String.valueOf(n2)};
        Cursor cursor = sQLiteDatabase.query(string2, stringArray, "id_real_category = ?", stringArray2, null, null, null);
        cursor.moveToFirst();
        while (!cursor.isAfterLast()) {
            SQLiteDatabase sQLiteDatabase2 = this.database;
            String string3 = Schema.Apk.getName();
            String[] stringArray3 = new String[]{"id_repo"};
            String[] stringArray4 = new String[]{cursor.getString(0)};
            Cursor cursor2 = sQLiteDatabase2.query(string3, stringArray3, "id_apk = ?", stringArray4, null, null, null);
            if (cursor2.moveToFirst()) {
                SQLiteDatabase sQLiteDatabase3 = this.database;
                String string4 = Schema.Repo.getName();
                String[] stringArray5 = new String[]{cursor2.getString(0)};
                sQLiteDatabase3.delete(string4, "id_repo = ?", stringArray5);
                SQLiteDatabase sQLiteDatabase4 = this.database;
                String string5 = Schema.Apk.getName();
                String[] stringArray6 = new String[]{cursor.getString(0)};
                sQLiteDatabase4.delete(string5, "id_apk = ?", stringArray6);
                SQLiteDatabase sQLiteDatabase5 = this.database;
                String string6 = Schema.Category_Apk.getName();
                String[] stringArray7 = new String[]{cursor.getString(0)};
                sQLiteDatabase5.delete(string6, "id_apk = ?", stringArray7);
            }
            cursor2.close();
            cursor.moveToNext();
        }
        cursor.close();
        this.database.setTransactionSuccessful();
        this.database.endTransaction();
    }

    public void deleteFromExcludeUpdate(String string2, int n2) {
        SQLiteDatabase sQLiteDatabase = this.database;
        String string3 = Schema.Excluded.getName();
        String[] stringArray = new String[]{string2, n2 + ""};
        sQLiteDatabase.delete(string3, "package_name = ? and vercode = ?", stringArray);
    }

    public void deleteInstalledApk(String string2) {
        this.database.delete(Schema.Installed.getName(), "package_name = ?", new String[]{string2});
    }

    public void deleteLatest(long l2) {
        Log.e((String)"Aptoide-Database", (String)("Delete latest on repo " + l2));
        SQLiteDatabase sQLiteDatabase = this.database;
        String[] stringArray = new String[]{String.valueOf(l2), "Latest Apps"};
        Cursor cursor = sQLiteDatabase.rawQuery("select id_real_category from category where id_repo = ? and name = ?", stringArray);
        if (cursor.moveToFirst()) {
            long l3 = cursor.getLong(0);
            cursor.close();
            SQLiteDatabase sQLiteDatabase2 = this.database;
            String string2 = Schema.Category_Apk.getName();
            String[] stringArray2 = new String[]{String.valueOf(l3), String.valueOf(l2)};
            sQLiteDatabase2.delete(string2, "id_real_category = ? and id_repo = ?", stringArray2);
            SQLiteDatabase sQLiteDatabase3 = this.database;
            String string3 = Schema.Category.getName();
            String[] stringArray3 = new String[]{String.valueOf(l3), String.valueOf(l2)};
            sQLiteDatabase3.delete(string3, "id_real_category = ? and id_repo = ?", stringArray3);
        }
        cursor.close();
    }

    public void deleteRollbackItems() {
        this.database.delete(Schema.RollbackTbl.getName(), null, null);
    }

    public void deleteScheduledDownload(String string2) {
        this.database.delete(Schema.Scheduled.getName(), "md5 = ?", new String[]{string2});
    }

    public void deleteScheduledDownloadByPackageName(String string2) {
        this.database.delete(Schema.Scheduled.getName(), "package_name = ?", new String[]{string2});
    }

    public void deleteTop(long l2) {
        Log.e((String)"Aptoide-Database", (String)("Delete top on repo " + l2));
        SQLiteDatabase sQLiteDatabase = this.database;
        String[] stringArray = new String[]{String.valueOf(l2), "Top Apps"};
        Cursor cursor = sQLiteDatabase.rawQuery("select id_real_category from category where id_repo = ? and name = ?", stringArray);
        if (cursor.moveToFirst()) {
            long l3 = cursor.getLong(0);
            cursor.close();
            SQLiteDatabase sQLiteDatabase2 = this.database;
            String string2 = Schema.Category_Apk.getName();
            String[] stringArray2 = new String[]{String.valueOf(l3), String.valueOf(l2)};
            sQLiteDatabase2.delete(string2, "id_real_category = ? and id_repo = ?", stringArray2);
            SQLiteDatabase sQLiteDatabase3 = this.database;
            String string3 = Schema.Category.getName();
            String[] stringArray3 = new String[]{String.valueOf(l3), String.valueOf(l2)};
            sQLiteDatabase3.delete(string3, "id_real_category = ? and id_repo = ?", stringArray3);
        }
        cursor.close();
    }

    public void endTransaction() {
        this.database.setTransactionSuccessful();
        this.database.endTransaction();
    }

    public boolean existsServer(String string2) {
        Cursor cursor = null;
        try {
            cursor = this.database.rawQuery("select 1 from repo where url = ?", new String[]{string2});
            boolean bl2 = cursor.moveToFirst();
            return bl2;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public Cursor getAllStoreApks(long l2, StoreActivity.SortObject sortObject) {
        String string2 = "apk.name";
        switch (3.$SwitchMap$cm$aptoide$ptdev$StoreActivity$Sort[sortObject.getSort().ordinal()]) {
            case 1: {
                string2 = "apk.name collate nocase";
                break;
            }
            case 2: {
                string2 = "apk.date desc";
                break;
            }
            case 3: {
                string2 = "apk.downloads desc";
                break;
            }
            case 4: {
                string2 = "apk.rating desc";
                break;
            }
            case 5: {
                string2 = "apk.price desc";
            }
        }
        boolean bl2 = AptoideUtils.getSharedPreferences().getBoolean("hwspecsChkBox", true);
        boolean bl3 = AptoideUtils.getSharedPreferences().getBoolean("matureChkBox", true);
        SQLiteDatabase sQLiteDatabase = this.database;
        StringBuilder stringBuilder = new StringBuilder().append("select apk.name, apk.downloads, apk.rating, apk.price, apk.date ,apk.id_apk as _id, apk.downloads as count,apk.version_name ,'0' as type, apk.icon, repo.icons_path as iconpath, repo.theme as theme from apk join repo on apk.id_repo = repo.id_repo where apk.id_repo = ? ");
        String string3 = bl2 ? "and apk.is_compatible='1'" : "";
        StringBuilder stringBuilder2 = stringBuilder.append(string3).append(" ");
        String string4 = bl3 ? "and apk.mature='0'" : "";
        String string5 = stringBuilder2.append(string4).append(" order by ").append(string2).toString();
        String[] stringArray = new String[]{String.valueOf(l2)};
        Cursor cursor = sQLiteDatabase.rawQuery(string5, stringArray);
        cursor.getCount();
        return cursor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getApkFromPackage(String string2) {
        long l2;
        Cursor cursor;
        block5: {
            int n2;
            cursor = null;
            try {
                cursor = this.database.rawQuery("select id_apk from apk where package_name = ? and is_compatible = 1 order by version_code ", new String[]{string2});
                if (!cursor.moveToFirst()) break block5;
                n2 = cursor.getInt(0);
            }
            catch (Throwable throwable) {
                if (cursor == null) throw throwable;
                cursor.close();
                throw throwable;
            }
            l2 = n2;
            if (cursor == null) return l2;
            cursor.close();
            return l2;
        }
        l2 = 0L;
        if (cursor == null) return l2;
        cursor.close();
        return l2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getApkFromPackage(String string2, String string3) {
        long l2;
        Cursor cursor;
        block5: {
            int n2;
            cursor = null;
            try {
                cursor = this.database.rawQuery("select id_apk from apk join repo where package_name = ? and is_compatible = 1 and repo.name = ? order by version_code ", new String[]{string2, string3});
                if (!cursor.moveToFirst()) break block5;
                n2 = cursor.getInt(0);
            }
            catch (Throwable throwable) {
                if (cursor == null) throw throwable;
                cursor.close();
                throw throwable;
            }
            l2 = n2;
            if (cursor == null) return l2;
            cursor.close();
            return l2;
        }
        l2 = 0L;
        if (cursor == null) return l2;
        cursor.close();
        return l2;
    }

    public Cursor getApkInfo(long l2) {
        SQLiteDatabase sQLiteDatabase = this.database;
        String[] stringArray = new String[]{String.valueOf(l2)};
        Cursor cursor = sQLiteDatabase.rawQuery("select repo.apk_path as apk_path, apk.path as path, apk.md5, apk.version_code, apk.package_name, apk.name as name, apk.version_name, apk.rating, apk.downloads, apk.sdk, apk.screen, apk.icon as icon, repo.icons_path as iconpath, repo.name as reponame from apk join repo on apk.id_repo = repo.id_repo where apk.id_apk = ?", stringArray);
        cursor.moveToFirst();
        return cursor;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Cursor getApks(long l2, long l3, StoreActivity.SortObject sortObject) {
        Cursor cursor;
        String string2 = "apk.name";
        switch (3.$SwitchMap$cm$aptoide$ptdev$StoreActivity$Sort[sortObject.getSort().ordinal()]) {
            case 1: {
                string2 = "apk.name collate nocase";
                break;
            }
            case 2: {
                string2 = "apk.date desc";
                break;
            }
            case 3: {
                string2 = "apk.downloads desc";
                break;
            }
            case 4: {
                string2 = "apk.rating desc";
                break;
            }
            case 5: {
                string2 = "apk.price desc";
            }
        }
        boolean bl2 = AptoideUtils.getSharedPreferences().getBoolean("matureChkBox", true);
        boolean bl3 = AptoideUtils.getSharedPreferences().getBoolean("hwspecsChkBox", true);
        if (l2 > 0L) {
            SQLiteDatabase sQLiteDatabase = this.database;
            StringBuilder stringBuilder = new StringBuilder().append("select apk.name, apk.downloads, apk.rating, apk.price, apk.date ,apk.id_apk as _id, apk.downloads as count,apk.version_name ,'0' as type, apk.icon, repo.icons_path as iconpath, repo.theme as theme from apk join category_apk on apk.id_apk = category_apk.id_apk join repo on apk.id_repo = repo.id_repo where category_apk.id_real_category = ? and category_apk.id_repo = ? ");
            String string3 = bl3 ? "and apk.is_compatible='1'" : "";
            StringBuilder stringBuilder2 = stringBuilder.append(string3).append(" ");
            String string4 = bl2 ? "and apk.mature='0'" : "";
            String string5 = stringBuilder2.append(string4).append(" order by ").append(string2).toString();
            String[] stringArray = new String[]{String.valueOf(l3), String.valueOf(l2)};
            cursor = sQLiteDatabase.rawQuery(string5, stringArray);
        } else {
            SQLiteDatabase sQLiteDatabase = this.database;
            StringBuilder stringBuilder = new StringBuilder().append("select apk.name, apk.downloads, apk.rating, apk.price, apk.date ,apk.id_apk as _id, apk.downloads as count,apk.version_name ,'0' as type, apk.icon, repo.icons_path as iconpath, repo.theme as theme from apk, repo where apk.id_repo = repo.id_repo ");
            String string6 = bl3 ? "and apk.is_compatible='1'" : "";
            StringBuilder stringBuilder3 = stringBuilder.append(string6).append(" ");
            String string7 = bl2 ? "and apk.mature='0'" : "";
            cursor = sQLiteDatabase.rawQuery(stringBuilder3.append(string7).append(" group by apk.package_name order by ").append(string2).toString(), null);
        }
        cursor.getCount();
        return cursor;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public Cursor getCategories(long l2, long l3) {
        long l4 = l2 - 0L;
        long l5 = l4 == 0L ? 0 : (l4 < 0L ? -1 : 1);
        Cursor cursor = null;
        if (l5 <= 0) return cursor;
        SQLiteDatabase sQLiteDatabase = this.database;
        String[] stringArray = new String[]{String.valueOf(l2), String.valueOf(l3)};
        cursor = sQLiteDatabase.rawQuery("select cat.name as name, id_real_category as _id, apps_count as count, null as version_name, '1' as type, null as icon, null as iconpath, repo.theme as theme, repo.name as repo_name, repo.items as items from category as cat join repo on cat.id_repo = repo.id_repo where cat.id_repo = ? and id_category_parent = ? order by count desc", stringArray);
        cursor.getCount();
        if (l3 != 0L) return cursor;
        MatrixCursor matrixCursor = new MatrixCursor(new String[]{"name", "_id", "count", "version_name", "type", "icon", "iconpath", "theme", "repo_name"});
        boolean bl2 = cursor.moveToFirst();
        Object[] objectArray = null;
        if (bl2) {
            String string2 = cursor.getString(cursor.getColumnIndex("items"));
            if (string2 != null) {
                objectArray = string2.split(",");
            } else {
                Log.d((String)"Aptoide-Exception", (String)"Items is null");
                objectArray = null;
            }
        }
        cursor.moveToFirst();
        while (!cursor.isAfterLast()) {
            if (objectArray != null && ArrayUtils.contains(objectArray, cursor.getString(0).replaceAll(" ", "_").toLowerCase(Locale.ENGLISH))) {
                Object[] objectArray2 = new String[]{cursor.getString(0), cursor.getString(1), cursor.getString(2), cursor.getString(3), cursor.getString(4), cursor.getString(5), cursor.getString(6), cursor.getString(7), cursor.getString(8)};
                matrixCursor.addRow(objectArray2);
            } else if (objectArray == null) {
                Object[] objectArray3 = new String[]{cursor.getString(0), cursor.getString(1), cursor.getString(2), cursor.getString(3), cursor.getString(4), cursor.getString(5), cursor.getString(6), cursor.getString(7), cursor.getString(8)};
                matrixCursor.addRow(objectArray3);
            }
            cursor.moveToNext();
        }
        if (objectArray != null && ArrayUtils.contains(objectArray, "Latest Likes".replaceAll(" ", "_").toLowerCase(Locale.ENGLISH))) {
            matrixCursor.addRow((Object[])new String[]{"Latest Likes", "502", "0", "", "1", "", "", "", ""});
        }
        if (objectArray != null && ArrayUtils.contains(objectArray, "Latest Comments".replaceAll(" ", "_").toLowerCase(Locale.ENGLISH))) {
            matrixCursor.addRow((Object[])new String[]{"Latest Comments", "503", "0", "", "1", "", "", "", ""});
        }
        cursor.close();
        return matrixCursor;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ArrayList<HomeItem> getCollectionFeatured(int n2, int n3) {
        boolean bl2 = AptoideUtils.getSharedPreferences().getBoolean("matureChkBox", true);
        boolean bl3 = AptoideUtils.getSharedPreferences().getBoolean("hwspecsChkBox", true);
        SQLiteDatabase sQLiteDatabase = this.database;
        StringBuilder stringBuilder = new StringBuilder().append("select catname.id_real_category as mycatname, apk.id_apk as id, apk.downloads as downloads, apk.rating as rating, repo.icons_path as iconpath, apk.icon as icon, cat1.id_apk, catparentname.id_real_category as parentid, catname.name as catname,catname.id_real_category as catnameid, apk.name as name from category_apk as cat1 join category_apk as cat2 on cat1.id_apk = cat2.id_apk join category as catname on cat2.id_real_category = catname.id_real_category and catname.id_repo  = 0 join category as catparentname on catname.id_category_parent = catparentname.id_real_category and catparentname.id_repo = 0 join apk on cat1.id_apk = apk.id_apk join repo on apk.id_repo = repo.id_repo where cat1.id_real_category = 510 and cat2.id_real_category != 510 and catname.id_real_category = ? ");
        String string2 = bl3 ? " and apk.is_compatible='1'" : "";
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" ");
        String string3 = bl2 ? " and apk.mature='0'" : "";
        String string4 = stringBuilder2.append(string3).toString();
        String[] stringArray = new String[]{String.valueOf(n2)};
        Cursor cursor = sQLiteDatabase.rawQuery(string4, stringArray);
        ArrayList<HomeItem> arrayList = new ArrayList<HomeItem>();
        cursor.moveToFirst();
        for (int i2 = 0; !cursor.isAfterLast() && i2 < n3; ++i2) {
            String string5 = cursor.getString(cursor.getColumnIndex("iconpath"));
            String string6 = cursor.getString(cursor.getColumnIndex("icon"));
            long l2 = cursor.getLong(cursor.getColumnIndex("id"));
            arrayList.add(new HomeItem(cursor.getString(cursor.getColumnIndex("name")), cursor.getString(cursor.getColumnIndex("mycatname")), string5 + string6, l2, cursor.getString(cursor.getColumnIndex("downloads")), cursor.getFloat(cursor.getColumnIndex("rating"))));
            cursor.moveToNext();
        }
        cursor.close();
        return arrayList;
    }

    public SQLiteDatabase getDatabaseInstance() {
        return this.database;
    }

    public Cursor getExcludedApks() {
        return this.database.query(Schema.Excluded.getName(), null, null, null, null, null, null);
    }

    public ArrayList<Number> getFailedStores() {
        ArrayList<Number> arrayList = new ArrayList<Number>();
        Cursor cursor = this.database.rawQuery("select id_repo from repo where is_failed = 1 and hash IS NULL", null);
        cursor.moveToFirst();
        while (!cursor.isAfterLast()) {
            arrayList.add(cursor.getLong(cursor.getColumnIndex("id_repo")));
            cursor.moveToNext();
        }
        cursor.close();
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ArrayList<Collection> getFeatured(int n2, int n3) {
        boolean bl2 = AptoideUtils.getSharedPreferences().getBoolean("matureChkBox", true);
        boolean bl3 = AptoideUtils.getSharedPreferences().getBoolean("hwspecsChkBox", true);
        SQLiteDatabase sQLiteDatabase = this.database;
        StringBuilder stringBuilder = new StringBuilder().append("select catname.id_real_category as mycatname, apk.id_apk as id, catparentname.id_real_category as parentid, catparentname.name as catname, apk.name as name, repo.icons_path as iconpath, apk.icon as icon, apk.rating as rating, apk.downloads as downloads from category_apk as cat1 join category_apk as cat2 on cat1.id_apk = cat2.id_apk join category as catname on cat2.id_real_category = catname.id_real_category and catname.id_repo  = 0 join category as catparentname on catname.id_category_parent = catparentname.id_real_category and catparentname.id_repo = 0 join apk on cat1.id_apk = apk.id_apk join repo on apk.id_repo = repo.id_repo where cat1.id_real_category = 510 and cat2.id_real_category != 510 ");
        String string2 = bl3 ? "and apk.is_compatible='1'" : "";
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" ");
        String string3 = bl2 ? "and apk.mature='0'" : "";
        Cursor cursor = sQLiteDatabase.rawQuery(stringBuilder2.append(string3).append(" order by apk.date desc").toString(), null);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        HashMap hashMap2 = new HashMap();
        cursor.move(n3);
        while (!cursor.isAfterLast()) {
            String string4 = cursor.getString(cursor.getColumnIndex("catname"));
            if (!hashMap2.containsKey(string4)) {
                hashMap2.put(string4, new ArrayList());
                hashMap.put(string4, cursor.getInt(cursor.getColumnIndex("parentid")));
            }
            cursor.moveToNext();
        }
        cursor.moveToFirst();
        cursor.move(n3);
        while (!cursor.isAfterLast()) {
            String string5 = cursor.getString(cursor.getColumnIndex("catname"));
            if (((ArrayList)hashMap2.get(string5)).size() < n3) {
                String string6 = cursor.getString(cursor.getColumnIndex("iconpath"));
                String string7 = cursor.getString(cursor.getColumnIndex("icon"));
                long l2 = cursor.getLong(cursor.getColumnIndex("id"));
                ((ArrayList)hashMap2.get(string5)).add(new HomeItem(cursor.getString(cursor.getColumnIndex("name")), cursor.getString(cursor.getColumnIndex("mycatname")), string6 + string7, l2, cursor.getString(cursor.getColumnIndex("downloads")), cursor.getFloat(cursor.getColumnIndex("rating"))));
            }
            cursor.moveToNext();
        }
        hashMap2.put("New Editors' Choice", new ArrayList());
        hashMap.put("New Editors' Choice", -1);
        int n4 = 0;
        cursor.moveToFirst();
        while (!cursor.isAfterLast() && n4 < n3) {
            ++n4;
            if (((ArrayList)hashMap2.get("New Editors' Choice")).size() < n3) {
                String string8 = cursor.getString(cursor.getColumnIndex("iconpath"));
                String string9 = cursor.getString(cursor.getColumnIndex("icon"));
                long l3 = cursor.getLong(cursor.getColumnIndex("id"));
                ((ArrayList)hashMap2.get("New Editors' Choice")).add(new HomeItem(cursor.getString(cursor.getColumnIndex("name")), cursor.getString(cursor.getColumnIndex("mycatname")), string8 + string9, l3, cursor.getString(cursor.getColumnIndex("downloads")), cursor.getFloat(cursor.getColumnIndex("rating"))));
            }
            cursor.moveToNext();
        }
        cursor.close();
        ArrayList<Collection> arrayList = new ArrayList<Collection>();
        Iterator iterator = hashMap2.keySet().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                Collections.sort(arrayList, new Comparator<Collection>(){

                    @Override
                    public int compare(Collection collection, Collection collection2) {
                        return collection.getParentId() - collection2.getParentId();
                    }
                });
                return arrayList;
            }
            String string10 = (String)iterator.next();
            Collection collection = new Collection();
            collection.setName(string10);
            collection.setAppsList((ArrayList)hashMap2.get(string10));
            collection.setParentId((Integer)hashMap.get(string10));
            arrayList.add(collection);
        }
    }

    public Cursor getInstalled() {
        Cursor cursor = this.database.rawQuery("select 0 as _id , 'Installed' as name, null as count, null as version_name, null as icon, null as iconpath, null as package_name union select  apk.id_apk as _id,apk.name, apk.downloads as count, installed.version_name , apk.icon as icon, repo.icons_path as iconpath, apk.package_name as package_name from apk inner join installed on apk.package_name = installed.package_name join repo on apk.id_repo = repo.id_repo group by apk.package_name", null);
        cursor.getCount();
        return cursor;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ArrayList<Collection> getNewEditorsFeatured(int n2, int n3) {
        boolean bl2 = AptoideUtils.getSharedPreferences().getBoolean("matureChkBox", true);
        boolean bl3 = AptoideUtils.getSharedPreferences().getBoolean("hwspecsChkBox", true);
        SQLiteDatabase sQLiteDatabase = this.database;
        StringBuilder stringBuilder = new StringBuilder().append("select apk.date as timestamp, catname.id_real_category as mycatname, apk.id_apk as id, catparentname.id_real_category as parentid, catparentname.name as catname, apk.name as name, repo.icons_path as iconpath, apk.icon as icon, apk.rating as rating, apk.downloads as downloads from category_apk as cat1 join category_apk as cat2 on cat1.id_apk = cat2.id_apk join category as catname on cat2.id_real_category = catname.id_real_category and catname.id_repo  = 0 join category as catparentname on catname.id_category_parent = catparentname.id_real_category and catparentname.id_repo = 0 join apk on cat1.id_apk = apk.id_apk join repo on apk.id_repo = repo.id_repo where cat1.id_real_category = 510 and cat2.id_real_category != 510 ");
        String string2 = bl3 ? "and apk.is_compatible='1'" : "";
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" ");
        String string3 = bl2 ? "and apk.mature='0'" : "";
        Cursor cursor = sQLiteDatabase.rawQuery(stringBuilder2.append(string3).toString(), null);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        new ArrayList();
        HashMap hashMap2 = new HashMap();
        cursor.moveToFirst();
        while (!cursor.isAfterLast()) {
            int n4 = Weeks.weeksBetween(new DateTime(new Date(cursor.getLong(cursor.getColumnIndex("timestamp")))).withDayOfWeek(1), DateTime.now().withDayOfWeek(1)).getWeeks();
            String string4 = n4 + "";
            if (!hashMap2.containsKey(string4)) {
                hashMap2.put(string4, new ArrayList());
                hashMap.put(string4, -100);
            }
            cursor.moveToNext();
        }
        cursor.moveToFirst();
        while (!cursor.isAfterLast()) {
            int n5 = Weeks.weeksBetween(new DateTime(new Date(cursor.getLong(cursor.getColumnIndex("timestamp")))).withDayOfWeek(1), DateTime.now().withDayOfWeek(1)).getWeeks();
            String string5 = n5 + "";
            String string6 = cursor.getString(cursor.getColumnIndex("iconpath"));
            String string7 = cursor.getString(cursor.getColumnIndex("icon"));
            long l2 = cursor.getLong(cursor.getColumnIndex("id"));
            ((ArrayList)hashMap2.get(string5)).add(new HomeItem(cursor.getString(cursor.getColumnIndex("name")), cursor.getString(cursor.getColumnIndex("mycatname")), string6 + string7, l2, cursor.getString(cursor.getColumnIndex("downloads")), cursor.getColumnIndex("rating")));
            cursor.moveToNext();
        }
        cursor.close();
        Log.d((String)"Aptoide-EditorsChoice", (String)hashMap2.toString());
        ArrayList<Collection> arrayList = new ArrayList<Collection>();
        Iterator iterator = hashMap2.keySet().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                Collections.sort(arrayList, new Comparator<Collection>(){

                    @Override
                    public int compare(Collection collection, Collection collection2) {
                        return collection.getWeeks() - collection2.getWeeks();
                    }
                });
                return arrayList;
            }
            String string8 = (String)iterator.next();
            Collection collection = new Collection();
            collection.setName(string8);
            collection.setWeeks(Integer.parseInt(string8));
            collection.setAppsList((ArrayList)hashMap2.get(string8));
            collection.setParentId((Integer)hashMap.get(string8));
            collection.setHasMore(false);
            arrayList.add(collection);
        }
    }

    public String getNotConfirmedRollbackAction(String string2) {
        SQLiteDatabase sQLiteDatabase = this.database;
        String[] stringArray = new String[]{string2, Integer.toString(0)};
        Cursor cursor = sQLiteDatabase.rawQuery("select action from rollbacktbl where package_name = ? and confirmed = ?", stringArray);
        int n2 = cursor.getCount();
        String string3 = null;
        if (n2 != 0) {
            cursor.moveToFirst();
            string3 = cursor.getString(0);
        }
        cursor.close();
        return string3;
    }

    public Cursor getRollbackActions() {
        Cursor cursor = this.database.rawQuery("select rowid as _id, icon_path, version, previous_version, name, strftime('%d-%m-%Y', datetime(timestamp, 'unixepoch')) as cat_timestamp, action, package_name, md5, rollbacktbl.timestamp as real_timestamp from rollbacktbl  where rollbacktbl.confirmed = 1 order by rollbacktbl.timestamp desc", null);
        cursor.getCount();
        return cursor;
    }

    public Cursor getScheduledDownloads() {
        try {
            Cursor cursor = this.database.rawQuery("select rowid as _id, * from scheduled", null);
            return cursor;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public Cursor getSearchResults(String string2, StoreActivity.Sort sort) {
        boolean bl2 = AptoideUtils.getSharedPreferences().getBoolean("hwspecsChkBox", true);
        boolean bl3 = AptoideUtils.getSharedPreferences().getBoolean("matureChkBox", true);
        String string3 = "apk.name";
        switch (3.$SwitchMap$cm$aptoide$ptdev$StoreActivity$Sort[sort.ordinal()]) {
            case 1: {
                string3 = "apk.name collate nocase";
                break;
            }
            case 2: {
                string3 = "apk.date desc";
                break;
            }
            case 3: {
                string3 = "apk.downloads desc";
                break;
            }
            case 4: {
                string3 = "apk.rating desc";
                break;
            }
            case 5: {
                string3 = "apk.price desc";
            }
        }
        SQLiteDatabase sQLiteDatabase = this.database;
        StringBuilder stringBuilder = new StringBuilder().append("select  apk.price, apk.date, apk.name as name, apk.id_apk as _id, apk.downloads as count, apk.version_name as version_name,'0' as type, apk.icon as icon, repo.icons_path as iconpath, apk.rating as rating from apk  join repo on apk.id_repo = repo.id_repo where apk.name LIKE '%").append(string2).append("%' ");
        String string4 = bl2 ? "and apk.is_compatible='1'" : "";
        StringBuilder stringBuilder2 = stringBuilder.append(string4).append(" ");
        String string5 = bl3 ? "and apk.mature='0'" : "";
        Cursor cursor = sQLiteDatabase.rawQuery(stringBuilder2.append(string5).append(" group by apk.package_name order by ").append(string3).toString(), null);
        cursor.getCount();
        return cursor;
    }

    public Cursor getServers() {
        Cursor cursor = this.database.rawQuery("select * from repo where is_user = 1", null);
        cursor.getCount();
        return cursor;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ArrayList<Collection> getSpecificFeatured(int n2, int n3) {
        if (n2 == -1) {
            return this.getNewEditorsFeatured(n2, n3);
        }
        boolean bl2 = AptoideUtils.getSharedPreferences().getBoolean("matureChkBox", true);
        boolean bl3 = AptoideUtils.getSharedPreferences().getBoolean("hwspecsChkBox", true);
        SQLiteDatabase sQLiteDatabase = this.database;
        StringBuilder stringBuilder = new StringBuilder().append("select catname.id_real_category as mycatname, apk.id_apk as id, apk.downloads as downloads, apk.rating as rating, repo.icons_path as iconpath, apk.icon as icon, catname.id_real_category as parentid, catname.name as catname, apk.name as name from category_apk as cat1 join category_apk as cat2 on cat1.id_apk = cat2.id_apk join category as catname on cat2.id_real_category = catname.id_real_category and catname.id_repo  = 0 join category as catparentname on catname.id_category_parent = catparentname.id_real_category and catparentname.id_repo = 0 join apk on cat1.id_apk = apk.id_apk join repo on apk.id_repo = repo.id_repo where cat1.id_real_category = 510 and cat2.id_real_category != 510 and catparentname.id_real_category = ? ");
        String string2 = bl3 ? "and apk.is_compatible='1'" : "";
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" ");
        String string3 = bl2 ? "and apk.mature='0'" : "";
        String string4 = stringBuilder2.append(string3).toString();
        String[] stringArray = new String[]{String.valueOf(n2)};
        Cursor cursor = sQLiteDatabase.rawQuery(string4, stringArray);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap hashMap2 = new HashMap();
        cursor.moveToFirst();
        while (!cursor.isAfterLast()) {
            String string5 = cursor.getString(cursor.getColumnIndex("catname"));
            if (!hashMap2.containsKey(string5)) {
                hashMap2.put(string5, new ArrayList());
                hashMap.put(string5, cursor.getInt(cursor.getColumnIndex("parentid")));
            }
            cursor.moveToNext();
        }
        cursor.moveToFirst();
        while (!cursor.isAfterLast()) {
            String string6 = cursor.getString(cursor.getColumnIndex("catname"));
            if (((ArrayList)hashMap2.get(string6)).size() < n3) {
                String string7 = cursor.getString(cursor.getColumnIndex("iconpath"));
                String string8 = cursor.getString(cursor.getColumnIndex("icon"));
                long l2 = cursor.getLong(cursor.getColumnIndex("id"));
                ((ArrayList)hashMap2.get(string6)).add(new HomeItem(cursor.getString(cursor.getColumnIndex("name")), cursor.getString(cursor.getColumnIndex("mycatname")), string7 + string8, l2, cursor.getString(cursor.getColumnIndex("downloads")), cursor.getColumnIndex("rating")));
            } else {
                arrayList.add(string6);
            }
            cursor.moveToNext();
        }
        cursor.close();
        ArrayList<Collection> arrayList2 = new ArrayList();
        Iterator iterator = hashMap2.keySet().iterator();
        while (iterator.hasNext()) {
            String string9 = (String)iterator.next();
            Collection collection = new Collection();
            collection.setName(string9);
            collection.setAppsList((ArrayList)hashMap2.get(string9));
            collection.setParentId((Integer)hashMap.get(string9));
            collection.setHasMore(arrayList.contains(string9));
            arrayList2.add(collection);
        }
        return arrayList2;
    }

    public List<InstalledPackage> getStartupInstalled() {
        ArrayList<InstalledPackage> arrayList = new ArrayList<InstalledPackage>();
        Cursor cursor = this.database.rawQuery("select package_name, version_code from installed", null);
        cursor.moveToFirst();
        while (!cursor.isAfterLast()) {
            arrayList.add(new InstalledPackage(null, cursor.getString(0), cursor.getInt(1), null, null));
            cursor.moveToNext();
        }
        cursor.close();
        return arrayList;
    }

    public Cursor getStore(long l2) {
        SQLiteDatabase sQLiteDatabase = this.database;
        String[] stringArray = new String[]{String.valueOf(l2)};
        Cursor cursor = sQLiteDatabase.rawQuery("select * from repo where id_repo = ?", stringArray);
        cursor.getCount();
        return cursor;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ArrayList<HomeItem> getTopFeatured(int n2) {
        boolean bl2 = AptoideUtils.getSharedPreferences().getBoolean("matureChkBox", true);
        boolean bl3 = AptoideUtils.getSharedPreferences().getBoolean("hwspecsChkBox", true);
        SQLiteDatabase sQLiteDatabase = this.database;
        StringBuilder stringBuilder = new StringBuilder().append("select apk.id_apk as id, apk.name as name, apk.downloads as downloads, apk.rating as rating, repo.icons_path as iconpath, apk.icon as icon from category_apk as cat1  join apk on cat1.id_apk = apk.id_apk join repo on apk.id_repo = repo.id_repo where cat1.id_real_category = 511 ");
        String string2 = bl3 ? "and apk.is_compatible='1'" : "";
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" ");
        String string3 = bl2 ? "and apk.mature='0'" : "";
        Cursor cursor = sQLiteDatabase.rawQuery(stringBuilder2.append(string3).toString(), null);
        ArrayList<HomeItem> arrayList = new ArrayList<HomeItem>();
        cursor.moveToFirst();
        for (int i2 = 0; !cursor.isAfterLast() && i2 < n2; ++i2) {
            String string4 = cursor.getString(cursor.getColumnIndex("iconpath"));
            String string5 = cursor.getString(cursor.getColumnIndex("icon"));
            long l2 = cursor.getLong(cursor.getColumnIndex("id"));
            arrayList.add(new HomeItem(cursor.getString(cursor.getColumnIndex("name")), "", string4 + string5, l2, cursor.getString(cursor.getColumnIndex("downloads")), cursor.getFloat(cursor.getColumnIndex("rating"))));
            cursor.moveToNext();
        }
        cursor.close();
        return arrayList;
    }

    public String getUnistallingActionMd5(String string2) {
        SQLiteDatabase sQLiteDatabase = this.database;
        String[] stringArray = new String[]{string2, RollBackItem.Action.UNINSTALLING.toString()};
        Cursor cursor = sQLiteDatabase.rawQuery("select md5 from rollbacktbl  where package_name = ? and action = ?", stringArray);
        int n2 = cursor.getCount();
        String string3 = null;
        if (n2 != 0) {
            cursor.moveToFirst();
            string3 = cursor.getString(0);
        }
        cursor.close();
        return string3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Cursor getUpdates() {
        boolean bl2 = AptoideUtils.getSharedPreferences().getBoolean("matureChkBox", true);
        boolean bl3 = AptoideUtils.getSharedPreferences().getBoolean("hwspecsChkBox", true);
        SQLiteDatabase sQLiteDatabase = this.database;
        StringBuilder stringBuilder = new StringBuilder().append("select * from (select  (installed.version_code < apk.version_code) as is_update,  apk.id_apk as _id,  apk.name as name,  apk.version_code as version_code,  apk.package_name as package_name,  apk.downloads as count,  apk.version_name as version_name,  installed.version_name as installed_version_name,  apk.icon as icon,  repo.icons_path as iconpath  from apk inner  join installed on apk.package_name = installed.package_name  join repo on apk.id_repo = repo.id_repo where not exists (select 1 from excluded as d where apk.package_name = d.package_name ) ");
        String string2 = bl3 ? " and apk.is_compatible='1' " : " ";
        StringBuilder stringBuilder2 = stringBuilder.append(string2);
        String string3 = bl2 ? " and apk.mature='0' " : " ";
        Cursor cursor = sQLiteDatabase.rawQuery(stringBuilder2.append(string3).append(" and (installed.signature = apk.signature or apk.signature='') ").append(" order by apk.version_code asc) as firstQuery ").append(" group by package_name, is_update order by is_update desc, name collate nocase ").toString(), null);
        cursor.getCount();
        return cursor;
    }

    public void insertCategory(String string2, int n2, int n3, int n4, long l2) {
        Log.e((String)"Aptoide-Database", (String)("Inserting category " + string2 + " on " + l2));
        ContentValues contentValues = new ContentValues();
        contentValues.put("id_category_parent", Integer.valueOf(n2));
        contentValues.put("name", string2);
        contentValues.put("id_real_category", Integer.valueOf(n3));
        contentValues.put("id_repo", Long.valueOf(l2));
        this.database.insert(Schema.Category.getName(), null, contentValues);
    }

    public void insertInstalled(InstalledPackage installedPackage) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("package_name", installedPackage.getPackage_name());
        contentValues.put("name", installedPackage.getName());
        contentValues.put("version_code", Integer.valueOf(installedPackage.getVersion_code()));
        contentValues.put("version_name", installedPackage.getVersion_name());
        contentValues.put("signature", installedPackage.getSignature());
        this.database.insert(Schema.Installed.getName(), null, contentValues);
    }

    public void insertLegacyServer(Server server, Login login) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("name", server.getName());
        contentValues.put("is_user", Boolean.valueOf(true));
        contentValues.put("url", server.getUrl());
        if (login != null) {
            contentValues.put("username", login.getUsername());
            contentValues.put("password", login.getPassword());
        }
        this.database.insert(Schema.Repo.getName(), null, contentValues);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void insertRollbackAction(RollBackItem rollBackItem) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("name", rollBackItem.getName());
        contentValues.put("package_name", rollBackItem.getPackageName());
        contentValues.put("version", rollBackItem.getVersion());
        contentValues.put("previous_version", rollBackItem.getPreviousVersion());
        contentValues.put("icon_path", rollBackItem.getIconPath());
        contentValues.put("md5", rollBackItem.getMd5());
        String string2 = rollBackItem.getAction() == null ? "" : rollBackItem.getAction().toString();
        contentValues.put("action", string2);
        contentValues.put("confirmed", Integer.valueOf(0));
        SQLiteDatabase sQLiteDatabase = this.database;
        String[] stringArray = new String[]{rollBackItem.getPackageName()};
        Cursor cursor = sQLiteDatabase.rawQuery("select 1 from rollbacktbl  where package_name = ? and confirmed = 0", stringArray);
        if (cursor.getCount() == 0) {
            this.database.insert(Schema.RollbackTbl.getName(), null, contentValues);
        } else {
            SQLiteDatabase sQLiteDatabase2 = this.database;
            String string3 = Schema.RollbackTbl.getName();
            String[] stringArray2 = new String[]{rollBackItem.getPackageName()};
            sQLiteDatabase2.update(string3, contentValues, "package_name = ? and confirmed = 0", stringArray2);
        }
        cursor.close();
    }

    public void insertScheduledDownload(String string2, String string3, String string4, String string5, String string6, String string7) {
        SQLiteDatabase sQLiteDatabase = this.database;
        String string8 = Schema.Scheduled.getName();
        String[] stringArray = new String[]{string5, string3 + ""};
        Cursor cursor = sQLiteDatabase.query(string8, null, "repo_name = ? and md5 = ?", stringArray, null, null, null);
        if (cursor.moveToFirst()) {
            cursor.close();
            return;
        }
        cursor.close();
        ContentValues contentValues = new ContentValues();
        contentValues.put("name", string6);
        contentValues.put("package_name", string2);
        contentValues.put("version_name", string4);
        contentValues.put("repo_name", string5);
        contentValues.put("icon", string7);
        contentValues.put("md5", string3);
        PreferenceManager.getDefaultSharedPreferences((Context)Aptoide.getContext()).edit().putBoolean("schTrigger", true).commit();
        this.database.insert(Schema.Scheduled.getName(), null, contentValues);
    }

    public long insertServer(Server server) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("icons_path", server.getIconspath());
        contentValues.put("webservices_path", server.getWebservicespath());
        contentValues.put("apk_path", server.getApkpath());
        contentValues.put("name", server.getName());
        contentValues.put("is_user", Boolean.valueOf(false));
        contentValues.put("url", server.getUrl());
        try {
            long l2 = this.database.insert(Schema.Repo.getName(), null, contentValues);
            return l2;
        }
        catch (SQLiteException sQLiteException) {
            SQLiteDatabase sQLiteDatabase = this.database;
            String string2 = Schema.Repo.getName();
            String[] stringArray = new String[]{"id_repo"};
            String[] stringArray2 = new String[]{server.getUrl()};
            Cursor cursor = sQLiteDatabase.query(string2, stringArray, "url = ?", stringArray2, null, null, null);
            long l3 = cursor.getLong(0);
            cursor.close();
            return l3;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public long insertStore(Store store) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("url", store.getBaseUrl());
        contentValues.put("name", store.getName());
        contentValues.put("avatar_url", store.getAvatar());
        contentValues.put("downloads", store.getDownloads());
        contentValues.put("theme", store.getTheme());
        contentValues.put("description", store.getDescription());
        contentValues.put("items", store.getItems());
        contentValues.put("list", store.getView());
        if (store.getLogin() != null) {
            contentValues.put("username", store.getLogin().getUsername());
            contentValues.put("password", store.getLogin().getPassword());
        }
        boolean bl2 = store.getBaseUrl() + " " + store.getLogin() != null;
        Log.d((String)"Aptoide-Inserting store", (String)String.valueOf(bl2));
        contentValues.put("is_user", Boolean.valueOf(true));
        return this.database.insert(Schema.Repo.getName(), "error", contentValues);
    }

    public boolean isRepoParsed(long l2) {
        SQLiteDatabase sQLiteDatabase = this.database;
        String[] stringArray = new String[]{String.valueOf(l2)};
        Cursor cursor = sQLiteDatabase.rawQuery("select 1 from repo where id_repo = ? and hash IS NOT NULL", stringArray);
        boolean bl2 = cursor.moveToFirst();
        cursor.close();
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isScheduledDownload(String string2, String string3) {
        Cursor cursor;
        boolean bl2 = true;
        this.yield();
        try {
            Cursor cursor2;
            cursor = cursor2 = this.database.query(Schema.Scheduled.getName(), new String[]{"1"}, "repo_name = ? and md5 = ?", new String[]{string2, string3}, null, null, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        if (cursor == null || !cursor.moveToFirst()) {
            bl2 = false;
        }
        if (cursor == null) return bl2;
        cursor.close();
        return bl2;
    }

    public boolean isStoreError(long l2) {
        SQLiteDatabase sQLiteDatabase = this.database;
        String[] stringArray = new String[]{String.valueOf(l2)};
        Cursor cursor = sQLiteDatabase.rawQuery("select 1 from repo where id_repo = ? and is_failed = 1 and hash IS NULL", stringArray);
        boolean bl2 = cursor.moveToFirst();
        cursor.close();
        return bl2;
    }

    public void putCategoriesIds(HashMap<Integer, Integer> hashMap, long l2) {
        SQLiteDatabase sQLiteDatabase = this.database;
        String[] stringArray = new String[]{String.valueOf(l2)};
        Cursor cursor = sQLiteDatabase.rawQuery("select id_real_category, id_real_category from category where id_repo = ? ", stringArray);
        cursor.moveToFirst();
        while (!cursor.isAfterLast()) {
            hashMap.put(cursor.getInt(0), cursor.getInt(1));
            cursor.moveToNext();
        }
    }

    public void removeStore(long l2) {
        HashSet<Long> hashSet = new HashSet<Long>();
        hashSet.add(l2);
        this.removeStores(hashSet);
    }

    public Boolean removeStores(Set<Long> set) {
        Log.d((String)"Aptoide-", (String)("Deleting " + set));
        this.database.beginTransaction();
        for (Long l2 : set) {
            SQLiteDatabase sQLiteDatabase = this.database;
            String[] stringArray = new String[]{String.valueOf(l2)};
            Cursor cursor = sQLiteDatabase.rawQuery("select id_real_category from category where id_repo = ?", stringArray);
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                SQLiteDatabase sQLiteDatabase2 = this.database;
                String[] stringArray2 = new String[]{String.valueOf(cursor.getLong(0)), String.valueOf(l2)};
                sQLiteDatabase2.delete("category_apk", "id_real_category=? and id_repo = ?", stringArray2);
                Log.d((String)"Aptoide-", (String)("Deleting " + cursor.getLong(0)));
                cursor.moveToNext();
            }
            cursor.close();
            SQLiteDatabase sQLiteDatabase3 = this.database;
            String[] stringArray3 = new String[]{String.valueOf(l2)};
            sQLiteDatabase3.delete("category", " id_repo = ? ", stringArray3);
            SQLiteDatabase sQLiteDatabase4 = this.database;
            String[] stringArray4 = new String[]{String.valueOf(l2)};
            sQLiteDatabase4.delete("apk", " id_repo = ? ", stringArray4);
            SQLiteDatabase sQLiteDatabase5 = this.database;
            String[] stringArray5 = new String[]{String.valueOf(l2)};
            sQLiteDatabase5.delete("repo", "id_repo = ? ", stringArray5);
        }
        this.database.setTransactionSuccessful();
        this.database.endTransaction();
        return true;
    }

    public void setFailedRepo(long l2) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("is_failed", Integer.valueOf(1));
        SQLiteDatabase sQLiteDatabase = this.database;
        String string2 = Schema.Repo.getName();
        String[] stringArray = new String[]{String.valueOf(l2)};
        sQLiteDatabase.update(string2, contentValues, "id_repo = ?", stringArray);
    }

    public void setLatestTimestamp(long l2, long l3) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("latest_timestamp", Long.valueOf(l3));
        SQLiteDatabase sQLiteDatabase = this.database;
        String string2 = Schema.Repo.getName();
        String[] stringArray = new String[]{String.valueOf(l2)};
        sQLiteDatabase.update(string2, contentValues, "id_repo = ?", stringArray);
    }

    public void setTopTimestamp(long l2, long l3) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("top_timestamp", Long.valueOf(l3));
        SQLiteDatabase sQLiteDatabase = this.database;
        String string2 = Schema.Repo.getName();
        String[] stringArray = new String[]{String.valueOf(l2)};
        sQLiteDatabase.update(string2, contentValues, "id_repo = ?", stringArray);
    }

    public void startTransaction() {
        this.database.beginTransaction();
    }

    public void updateApkName(Apk apk, SQLiteStatement sQLiteStatement) {
        String[] stringArray = new String[]{apk.getName(), apk.getPackageName(), String.valueOf(apk.getRepoId())};
        StatementHelper.bindAllArgsAsStrings(sQLiteStatement, stringArray);
        sQLiteStatement.execute();
    }

    public void updateAppsCount(long l2) {
        SQLiteDatabase sQLiteDatabase = this.database;
        String[] stringArray = new String[]{String.valueOf(l2)};
        Cursor cursor = sQLiteDatabase.rawQuery("select id_real_category from category where id_category_parent = 0 and id_repo = ?", stringArray);
        while (cursor.moveToNext()) {
            this.getAppsCount(cursor.getLong(0), l2);
        }
        cursor.close();
    }

    public boolean updateDowngradingAction(String string2) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("action", RollBackItem.Action.DOWNGRADING.toString());
        return this.database.update(Schema.RollbackTbl.getName(), contentValues, "package_name = ? and action = ?", new String[]{string2, ""}) > 0;
    }

    public void updateServer(Server server, long l2) {
        ContentValues contentValues = new ContentValues();
        if (server.getApkpath() != null) {
            contentValues.put("apk_path", server.getApkpath());
        }
        if (server.getIconspath() != null) {
            contentValues.put("icons_path", server.getIconspath());
        }
        if (server.getWebservicespath() != null) {
            contentValues.put("webservices_path", server.getWebservicespath());
        }
        if (server.getHash() != null) {
            contentValues.put("hash", server.getHash());
        }
        if (contentValues.size() > 0) {
            SQLiteDatabase sQLiteDatabase = this.database;
            String string2 = Schema.Repo.getName();
            String[] stringArray = new String[]{String.valueOf(l2)};
            sQLiteDatabase.update(string2, contentValues, "id_repo = ?", stringArray);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public long updateStore(Store store) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("avatar_url", store.getAvatar());
        contentValues.put("downloads", store.getDownloads());
        contentValues.put("theme", store.getTheme());
        contentValues.put("description", store.getDescription());
        contentValues.put("items", store.getItems());
        contentValues.put("list", store.getView());
        if (store.getLogin() != null) {
            contentValues.put("username", store.getLogin().getUsername());
            contentValues.put("password", store.getLogin().getPassword());
        }
        boolean bl2 = store.getBaseUrl() + " " + store.getLogin() != null;
        Log.d((String)"Aptoide-Updating store", (String)String.valueOf(bl2));
        contentValues.put("is_user", Boolean.valueOf(true));
        SQLiteDatabase sQLiteDatabase = this.database;
        String string2 = Schema.Repo.getName();
        String[] stringArray = new String[]{String.valueOf(store.getId())};
        return sQLiteDatabase.update(string2, contentValues, "id_repo = ?", stringArray);
    }

    public void yield() {
        if (this.database.yieldIfContendedSafely(1000L)) {
            Log.d((String)"TAG1", (String)"Database yielded");
        }
    }
}

