/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.configuration;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import cm.aptoide.ptdev.Aptoide;
import cm.aptoide.ptdev.R;
import cm.aptoide.ptdev.Start;
import cm.aptoide.ptdev.configuration.Defaults;
import java.io.File;

public class AptoideConfiguration {
    private static String BRAND;
    private static String MARKETNAME;
    private static final String PREF_ALWAYS_UPDATE = "dev_mode_always_update";
    private static final String PREF_AUTO_UPDATE_URL = "dev_mode_auto_update_url";
    private static final String PREF_DEFAULT_STORE = "dev_mode_featured_store";
    private static final String PREF_EDITORS_PATH = "dev_mode_editors_path";
    private static final String PREF_PATH_CACHE = "dev_mode_path_cache";
    private static final String PREF_PATH_CACHE_APK = "dev_mode_path_cache_apks";
    private static final String PREF_PATH_CACHE_ICONS = "dev_mode_path_cache_icons";
    private static final String PREF_STORE_DOMAIN = "dev_mode_store_domain";
    private static final String PREF_TOP_PATH = "dev_mode_top_path";
    private static final String PREF_URI_SEARCH = "dev_mode_uri_search";
    private static final String PREF_WEBSERVICE_URL = "dev_mode_webservices_url";
    private static Context context;
    private static SharedPreferences sPref;
    private String webservicesPath;

    static {
        context = Aptoide.getContext();
        sPref = PreferenceManager.getDefaultSharedPreferences((Context)context);
        MARKETNAME = "Aptoide";
    }

    public String getAutoUpdateUrl() {
        return sPref.getString(PREF_AUTO_UPDATE_URL, "http://imgs.aptoide.com/latest_version.xml");
    }

    public String getBrand() {
        return BRAND;
    }

    public String getDefaultStore() {
        return sPref.getString(PREF_DEFAULT_STORE, "apps");
    }

    public String getDomainAptoideStore() {
        return sPref.getString(PREF_STORE_DOMAIN, ".store.aptoide.com/");
    }

    public String getEditorsPath() {
        return sPref.getString(PREF_EDITORS_PATH, "editors.xml");
    }

    public int getIcon() {
        return R.drawable.icon_brand_aptoide;
    }

    public String getMarketName() {
        return MARKETNAME;
    }

    public String getPathCache() {
        String string2 = sPref.getString(PREF_PATH_CACHE, Defaults.PATH_CACHE);
        new File(string2).mkdirs();
        return string2;
    }

    public String getPathCacheApks() {
        String string2 = sPref.getString(PREF_PATH_CACHE_APK, Defaults.PATH_CACHE_APKS);
        new File(string2).mkdirs();
        return string2;
    }

    public String getPathCacheIcons() {
        String string2 = sPref.getString(PREF_PATH_CACHE_ICONS, Defaults.PATH_CACHE_ICONS);
        new File(string2).mkdirs();
        return string2;
    }

    public Class getShortcutClass() {
        return Start.class;
    }

    public String getTopPath() {
        return sPref.getString(PREF_TOP_PATH, "top.xml");
    }

    public String getUriSearch() {
        return sPref.getString(PREF_URI_SEARCH, "http://m.aptoide.com/searchview.php?search=");
    }

    public String getWebServicesUri() {
        if (this.webservicesPath == null) {
            this.webservicesPath = sPref.getString(PREF_WEBSERVICE_URL, "http://webservices.aptoide.com/");
        }
        return this.webservicesPath;
    }

    public boolean isAlwaysUpdate() {
        return sPref.getBoolean(PREF_ALWAYS_UPDATE, false);
    }

    public void setAlwaysUpdate(boolean bl2) {
        sPref.edit().putBoolean(PREF_ALWAYS_UPDATE, bl2).commit();
    }

    public void setAutoUpdateUrl(String string2) {
        sPref.edit().putString(PREF_AUTO_UPDATE_URL, string2).commit();
    }

    public void setBrand(String string2) {
        BRAND = string2;
    }

    public void setDefaultStore(String string2) {
        sPref.edit().putString(PREF_DEFAULT_STORE, string2).commit();
    }

    public void setDomainStore(String string2) {
        sPref.edit().putString(PREF_STORE_DOMAIN, string2).commit();
    }

    public void setEditorsPath(String string2) {
        sPref.edit().putString(PREF_EDITORS_PATH, string2).commit();
    }

    public void setMARKETNAME(String string2) {
        MARKETNAME = string2;
    }

    public void setPathCache(String string2) {
        sPref.edit().putString(PREF_PATH_CACHE, string2).commit();
    }

    public void setPathCacheApks(String string2) {
        sPref.edit().putString(PREF_PATH_CACHE_APK, string2).commit();
    }

    public void setPathCacheIcons(String string2) {
        sPref.edit().putString(PREF_PATH_CACHE_ICONS, string2).commit();
    }

    public void setTopPath(String string2) {
        sPref.edit().putString(PREF_TOP_PATH, string2).commit();
    }

    public void setUriSearch(String string2) {
        sPref.edit().putString(PREF_URI_SEARCH, string2).commit();
    }

    public void setWebservicesUri(String string2) {
        this.webservicesPath = string2;
        sPref.edit().putString(PREF_WEBSERVICE_URL, string2).commit();
    }
}

