/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.adapters;

import android.content.Context;
import android.database.Cursor;
import android.database.DataSetObserver;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.TextView;
import android.widget.Toast;
import cm.aptoide.ptdev.R;
import cm.aptoide.ptdev.Start;
import cm.aptoide.ptdev.adapters.UpdatesAdapter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class UpdatesSectionListAdapter
extends BaseAdapter
implements ListAdapter,
AdapterView.OnItemClickListener {
    private Context context;
    private final Map<View, String> currentViewSections;
    private final DataSetObserver dataSetObserver = new DataSetObserver(){

        public void onChanged() {
            super.onChanged();
            UpdatesSectionListAdapter.this.updateSessionCache();
        }

        public void onInvalidated() {
            super.onInvalidated();
            UpdatesSectionListAdapter.this.updateSessionCache();
        }
    };
    protected final LayoutInflater inflater;
    private final Map<Integer, Integer> itemPositions;
    private final ListAdapter linkedAdapter;
    private AdapterView.OnItemClickListener linkedListener;
    private final Map<Integer, String> sectionPositions = new LinkedHashMap<Integer, String>();
    private View transparentSectionView;
    private int viewTypeCount;

    public UpdatesSectionListAdapter(Context context, LayoutInflater layoutInflater, ListAdapter listAdapter) {
        this.itemPositions = new LinkedHashMap<Integer, Integer>();
        this.currentViewSections = new HashMap<View, String>();
        this.context = context;
        this.linkedAdapter = listAdapter;
        this.inflater = layoutInflater;
        listAdapter.registerDataSetObserver(this.dataSetObserver);
        this.updateSessionCache();
    }

    private View getSectionView(View view, String string2) {
        View view2 = view;
        if (view2 == null) {
            view2 = this.createNewSectionView();
        }
        this.setSectionText(string2, view2);
        this.replaceSectionViewsInMaps(string2, view2);
        return view2;
    }

    private boolean isTheSame(String string2, String string3) {
        if (string2 == null) {
            return string3 == null;
        }
        return string2.equals(string3);
    }

    private void updateSessionCache() {
        synchronized (this) {
            Log.d((String)"Aptoide-SectionAdapter", (String)"Updating session cache");
            int n2 = 0;
            this.sectionPositions.clear();
            this.itemPositions.clear();
            this.viewTypeCount = 1 + this.linkedAdapter.getViewTypeCount();
            String string2 = null;
            int n3 = this.linkedAdapter.getCount();
            for (int i2 = 0; i2 < n3; ++i2) {
                block8: {
                    Cursor cursor = (Cursor)this.linkedAdapter.getItem(i2);
                    if (this.isTheSame(string2, cursor.getString(cursor.getColumnIndex("is_update")))) break block8;
                    this.sectionPositions.put(n2, cursor.getString(cursor.getColumnIndex("is_update")));
                    string2 = cursor.getString(cursor.getColumnIndex("is_update"));
                    ++n2;
                }
                this.itemPositions.put(n2, i2);
                ++n2;
                continue;
            }
            return;
        }
    }

    public boolean areAllItemsEnabled() {
        return this.linkedAdapter.areAllItemsEnabled();
    }

    protected View createNewSectionView() {
        return this.inflater.inflate(R.layout.separator_updates, null);
    }

    public int getCount() {
        synchronized (this) {
            int n2 = this.sectionPositions.size() + this.linkedAdapter.getCount();
            Log.d((String)"Aptoide-getCount", (String)String.valueOf(n2));
            return n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getItem(int n2) {
        synchronized (this) {
            block4: {
                if (!this.isSection(n2)) break block4;
                String string2 = this.sectionPositions.get(n2);
                return string2;
            }
            int n3 = this.getLinkedPosition(n2);
            Object object = this.linkedAdapter.getItem(n3);
            return object;
        }
    }

    public long getItemId(int n2) {
        if (this.isSection(n2)) {
            return this.sectionPositions.get(n2).hashCode();
        }
        return this.linkedAdapter.getItemId(this.getLinkedPosition(n2).intValue());
    }

    public int getItemViewType(int n2) {
        if (this.isSection(n2)) {
            return -1 + this.viewTypeCount;
        }
        return this.linkedAdapter.getItemViewType(this.getLinkedPosition(n2).intValue());
    }

    protected Integer getLinkedPosition(int n2) {
        if (this.itemPositions.get(n2) == null) {
            return 0;
        }
        return this.itemPositions.get(n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getSectionName(int n2) {
        synchronized (this) {
            if (!this.isSection(n2)) return null;
            return this.sectionPositions.get(n2);
        }
    }

    public View getTransparentSectionView() {
        synchronized (this) {
            if (this.transparentSectionView == null) {
                this.transparentSectionView = this.createNewSectionView();
            }
            View view = this.transparentSectionView;
            return view;
        }
    }

    public View getView(int n2, View view, ViewGroup viewGroup) {
        if (this.isSection(n2)) {
            return this.getSectionView(view, this.sectionPositions.get(n2));
        }
        return this.linkedAdapter.getView(this.getLinkedPosition(n2).intValue(), view, viewGroup);
    }

    public int getViewTypeCount() {
        return this.viewTypeCount;
    }

    public boolean hasStableIds() {
        return this.linkedAdapter.hasStableIds();
    }

    public boolean isEmpty() {
        return this.linkedAdapter.isEmpty();
    }

    public boolean isEnabled(int n2) {
        if (this.isSection(n2)) {
            return false;
        }
        return this.linkedAdapter.isEnabled(this.getLinkedPosition(n2).intValue());
    }

    public boolean isSection(int n2) {
        synchronized (this) {
            boolean bl2 = this.sectionPositions.containsKey(n2);
            return bl2;
        }
    }

    public void makeSectionInvisibleIfFirstInList(int n2) {
        String string2 = this.getSectionName(n2);
        boolean bl2 = false;
        for (Map.Entry<View, String> entry : this.currentViewSections.entrySet()) {
            if (entry.getValue().equals(string2) && !bl2) {
                entry.getKey().setVisibility(4);
                bl2 = true;
                continue;
            }
            entry.getKey().setVisibility(0);
        }
        Iterator<Map.Entry<Integer, String>> iterator = this.sectionPositions.entrySet().iterator();
        Map.Entry<Integer, String> entry;
        while (iterator.hasNext() && (entry = iterator.next()).getKey() <= n2 + 1) {
            this.setSectionText(entry.getValue(), this.getTransparentSectionView());
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onItemClick(AdapterView<?> adapterView, View view, int n2, long l2) {
        if (this.isSection(n2)) {
            this.sectionClicked(this.getSectionName(n2));
            return;
        } else {
            if (this.linkedListener == null) return;
            this.linkedListener.onItemClick(adapterView, view, this.getLinkedPosition(n2).intValue(), l2);
            return;
        }
    }

    public void registerDataSetObserver(DataSetObserver dataSetObserver) {
        this.linkedAdapter.registerDataSetObserver(dataSetObserver);
    }

    protected void replaceSectionViewsInMaps(String string2, View view) {
        synchronized (this) {
            if (this.currentViewSections.containsKey(view)) {
                this.currentViewSections.remove(view);
            }
            this.currentViewSections.put(view, string2);
            return;
        }
    }

    protected void sectionClicked(String string2) {
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener onItemClickListener) {
        this.linkedListener = onItemClickListener;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void setSectionText(String string2, View view) {
        TextView textView = (TextView)view.findViewById(R.id.separator_label);
        String string3 = "";
        switch (Integer.parseInt(string2)) {
            case 0: {
                string3 = this.context.getString(R.string.installed_tab);
                view.findViewById(R.id.more).setVisibility(8);
            }
            default: {
                break;
            }
            case 1: {
                string3 = this.context.getString(R.string.updates_tab);
                view.findViewById(R.id.more).setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        ((Start)UpdatesSectionListAdapter.this.context).updateAll(((UpdatesAdapter)UpdatesSectionListAdapter.this.linkedAdapter).getUpdateIds());
                        Toast.makeText((Context)UpdatesSectionListAdapter.this.context, (CharSequence)UpdatesSectionListAdapter.this.context.getString(R.string.starting_download), (int)1).show();
                    }
                });
                view.findViewById(R.id.more).setVisibility(0);
            }
        }
        textView.setText((CharSequence)string3);
    }

    public void unregisterDataSetObserver(DataSetObserver dataSetObserver) {
        this.linkedAdapter.unregisterDataSetObserver(dataSetObserver);
    }
}

