/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.adapters;

import android.content.Context;
import android.os.Bundle;
import android.support.v7.view.ActionMode;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import cm.aptoide.ptdev.R;
import cm.aptoide.ptdev.StoreItem;
import cm.aptoide.ptdev.fragments.Callback;
import cm.aptoide.ptdev.utils.AptoideUtils;
import com.manuelpeinado.multichoiceadapter.extras.actionbarcompat.MultiChoiceArrayAdapter;
import com.nostra13.universalimageloader.core.ImageLoader;
import java.util.ArrayList;

public class StoreAdapter
extends MultiChoiceArrayAdapter<StoreItem> {
    boolean allSelected;
    private Callback callback;
    private LayoutInflater inflater;

    public StoreAdapter(Bundle bundle, Context context, ArrayList<StoreItem> arrayList, Callback callback) {
        super(bundle, context, 0, arrayList);
        this.callback = callback;
        this.inflater = LayoutInflater.from((Context)context);
    }

    public long getItemId(int n2) {
        Log.d((String)"Aptoide-", (String)("Getting ItemId " + ((StoreItem)this.getItem(n2)).getId()));
        return ((StoreItem)this.getItem(n2)).getId();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public View getViewImpl(int n2, View view, ViewGroup viewGroup) {
        View view2;
        ImageView imageView;
        TextView textView;
        TextView textView2;
        StoreItem storeItem = (StoreItem)this.getItem(n2);
        if (view == null) {
            view = this.inflater.inflate(R.layout.row_stores, null);
            textView2 = (TextView)view.findViewById(R.id.store_name);
            textView = (TextView)view.findViewById(R.id.store_dwn_number);
            imageView = (ImageView)view.findViewById(R.id.store_avatar);
            view2 = view.findViewById(R.id.view_alpha);
            view.setTag((Object)new StoreViewHolder(textView2, imageView, textView, view2));
        } else {
            StoreViewHolder storeViewHolder = (StoreViewHolder)view.getTag();
            textView2 = storeViewHolder.getStoreName();
            textView = storeViewHolder.getStoreDwn();
            imageView = storeViewHolder.getAvatarImage();
            view2 = storeViewHolder.getAlphaView();
        }
        textView2.setText((CharSequence)storeItem.getName());
        if (storeItem.getDwnNumber() != null && storeItem.getDwnNumber().length() > 0) {
            Context context = this.getContext();
            int n3 = R.string.X_download_number;
            Object[] objectArray = new Object[]{AptoideUtils.withSuffix(storeItem.getDwnNumber())};
            textView.setText((CharSequence)context.getString(n3, objectArray));
        } else {
            textView.setText((CharSequence)"");
        }
        if (this.getItemId(n2) > 0L) {
            if (storeItem.getStoreAvatar() != null && storeItem.getStoreAvatar().length() > 0) {
                ImageLoader.getInstance().displayImage(storeItem.getStoreAvatar(), imageView);
            } else {
                ImageLoader.getInstance().displayImage("drawable://" + R.drawable.avatar_apps, imageView);
            }
        } else {
            imageView.setImageResource(R.drawable.avatar_apps);
        }
        view2.setBackgroundResource(storeItem.getTheme().getStoreAlphaColor());
        Log.d((String)"Aptoide-", (String)("BindView " + storeItem.getName()));
        return view;
    }

    @Override
    public boolean onActionItemClicked(ActionMode actionMode, MenuItem menuItem) {
        return this.callback.onActionItemClicked(actionMode, menuItem);
    }

    @Override
    public boolean onCreateActionMode(ActionMode actionMode, Menu menu2) {
        actionMode.getMenuInflater().inflate(R.menu.menu_action_mode, menu2);
        return true;
    }

    @Override
    public boolean onPrepareActionMode(ActionMode actionMode, Menu menu2) {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void selectAll() {
        boolean bl2 = !this.allSelected;
        this.allSelected = bl2;
        int n2 = 0;
        while (n2 < this.getCount()) {
            this.setItemChecked(n2, this.allSelected);
            ++n2;
        }
        return;
    }

    public static class StoreViewHolder {
        private View alphaView;
        private ImageView avatarImage;
        private TextView storeDwn;
        private TextView storeName;

        public StoreViewHolder(TextView textView, ImageView imageView, TextView textView2, View view) {
            this.storeName = textView;
            this.storeDwn = textView2;
            this.avatarImage = imageView;
            this.alphaView = view;
        }

        public View getAlphaView() {
            return this.alphaView;
        }

        public ImageView getAvatarImage() {
            return this.avatarImage;
        }

        public TextView getStoreDwn() {
            return this.storeDwn;
        }

        public TextView getStoreName() {
            return this.storeName;
        }
    }
}

