/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.adapters;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import android.widget.Toast;
import cm.aptoide.ptdev.R;
import cm.aptoide.ptdev.Start;
import cm.aptoide.ptdev.adapters.UpdateItem;
import cm.aptoide.ptdev.adapters.UpdatesAdapter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class SimpleSectionAdapter<T>
extends BaseAdapter {
    static final boolean DEBUG;
    static final String TAG;
    private static final int VIEW_TYPE_SECTION_HEADER;
    private Context mContext;
    private BaseAdapter mListAdapter;
    private int mSectionHeaderLayoutId;
    private int mSectionTitleTextViewId;
    private Sectionizer<UpdateItem> mSectionizer = new Sectionizer<UpdateItem>(){

        @Override
        public String getSectionTitleForItem(UpdateItem updateItem) {
            if (updateItem.isUpdate()) {
                return "1";
            }
            return "0";
        }
    };
    private LinkedHashMap<String, Integer> mSections;

    static {
        TAG = SimpleSectionAdapter.class.getSimpleName();
    }

    public SimpleSectionAdapter(Context context, BaseAdapter baseAdapter) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null.");
        }
        if (baseAdapter == null) {
            throw new IllegalArgumentException("listAdapter cannot be null.");
        }
        this.mContext = context;
        this.mListAdapter = baseAdapter;
        this.mSections = new LinkedHashMap();
        this.findSections();
    }

    private void findSections() {
        int n2 = this.mListAdapter.getCount();
        int n3 = 0;
        this.mSections.clear();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = this.mSectionizer.getSectionTitleForItem((UpdateItem)this.mListAdapter.getItem(i2));
            if (this.mSections.containsKey(string2)) continue;
            this.mSections.put(string2, i2 + n3);
            ++n3;
        }
    }

    private int getSectionCount() {
        return this.mSections.size();
    }

    private boolean isTextView(Context context, int n2, int n3) {
        return View.inflate((Context)context, (int)n2, null).findViewById(n3) instanceof TextView;
    }

    private String sectionTitleForPosition(int n2) {
        switch (this.mListAdapter.getItemViewType(this.getIndexForPosition(n2))) {
            default: {
                return null;
            }
            case 0: {
                return "0";
            }
            case 1: 
        }
        return "1";
    }

    public boolean areAllItemsEnabled() {
        boolean bl2 = this.mListAdapter.areAllItemsEnabled();
        boolean bl3 = false;
        if (bl2) {
            int n2 = this.mSections.size();
            bl3 = false;
            if (n2 == 0) {
                bl3 = true;
            }
        }
        return bl3;
    }

    public int getCount() {
        return this.mListAdapter.getCount() + this.getSectionCount();
    }

    public int getIndexForPosition(int n2) {
        int n3 = 0;
        Iterator<Map.Entry<String, Integer>> iterator = this.mSections.entrySet().iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getValue() >= n2) continue;
            ++n3;
        }
        return n2 - n3;
    }

    public Object getItem(int n2) {
        return this.mListAdapter.getItem(this.getIndexForPosition(n2));
    }

    public long getItemId(int n2) {
        return this.mListAdapter.getItemId(this.getIndexForPosition(n2));
    }

    public int getItemViewType(int n2) {
        int n3 = this.getIndexForPosition(n2);
        if (this.mSections.values().contains(n2)) {
            return 0;
        }
        return 1 + this.mListAdapter.getItemViewType(n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public View getView(int n2, View view, ViewGroup viewGroup) {
        View view2 = view;
        SectionHolder sectionHolder = null;
        switch (this.getItemViewType(n2)) {
            default: {
                view2 = this.mListAdapter.getView(this.getIndexForPosition(n2), view, viewGroup);
                break;
            }
            case 0: {
                if (view2 == null) {
                    view2 = View.inflate((Context)this.mContext, (int)R.layout.separator_updates, null);
                    sectionHolder = new SectionHolder();
                    sectionHolder.titleTextView = (TextView)view2.findViewById(R.id.separator_label);
                    sectionHolder.more = (TextView)view2.findViewById(R.id.more);
                    view2.setTag((Object)sectionHolder);
                    break;
                }
                sectionHolder = (SectionHolder)view2.getTag();
            }
        }
        if (sectionHolder != null) {
            String string2 = this.sectionTitleForPosition(n2);
            String string3 = "";
            switch (Integer.parseInt(string2)) {
                case 0: {
                    string3 = this.mContext.getString(R.string.installed_tab);
                    sectionHolder.more.findViewById(R.id.more).setVisibility(8);
                }
                default: {
                    break;
                }
                case 1: {
                    string3 = this.mContext.getString(R.string.updates_tab);
                    sectionHolder.more.findViewById(R.id.more).setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            ((Start)SimpleSectionAdapter.this.mContext).updateAll(((UpdatesAdapter)SimpleSectionAdapter.this.mListAdapter).getUpdateIds());
                            Toast.makeText((Context)SimpleSectionAdapter.this.mContext, (CharSequence)SimpleSectionAdapter.this.mContext.getString(R.string.starting_download), (int)1).show();
                        }
                    });
                    sectionHolder.more.findViewById(R.id.more).setVisibility(0);
                }
            }
            sectionHolder.titleTextView.setText((CharSequence)string3);
        }
        return view2;
    }

    public int getViewTypeCount() {
        return 1 + this.mListAdapter.getViewTypeCount();
    }

    public boolean isEnabled(int n2) {
        if (this.mSections.values().contains(n2)) {
            return false;
        }
        return this.mListAdapter.isEnabled(this.getIndexForPosition(n2));
    }

    public void notifyDataSetChanged() {
        this.mListAdapter.notifyDataSetChanged();
        this.findSections();
        super.notifyDataSetChanged();
    }

    static class SectionHolder {
        public TextView more;
        public TextView titleTextView;

        SectionHolder() {
        }
    }

    public static interface Sectionizer<T> {
        public String getSectionTitleForItem(T var1);
    }
}

