/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.adapters;

import android.content.Context;
import android.database.Cursor;
import android.support.v4.widget.CursorAdapter;
import android.support.v7.widget.PopupMenu;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RatingBar;
import android.widget.TextView;
import android.widget.Toast;
import cm.aptoide.ptdev.R;
import cm.aptoide.ptdev.SearchManager;
import cm.aptoide.ptdev.utils.IconSizes;
import com.nostra13.universalimageloader.core.ImageLoader;

public class SearchAdapter
extends CursorAdapter {
    private Context mContext;
    private final String sizeString;

    public SearchAdapter(Context context) {
        super(context, null, 2);
        this.sizeString = IconSizes.generateSizeString(context);
        this.mContext = context;
    }

    @Override
    public void bindView(View view, Context context, Cursor cursor) {
        AppViewHolder appViewHolder = (AppViewHolder)view.getTag();
        String string2 = cursor.getString(cursor.getColumnIndex("name"));
        cursor.getInt(cursor.getColumnIndex("count"));
        if (appViewHolder == null) {
            appViewHolder = new AppViewHolder();
            appViewHolder.appIcon = (ImageView)view.findViewById(R.id.app_icon);
            appViewHolder.overFlow = (ImageView)view.findViewById(R.id.ic_action);
            appViewHolder.appName = (TextView)view.findViewById(R.id.app_name);
            appViewHolder.versionName = (TextView)view.findViewById(R.id.app_version);
            appViewHolder.rating = (RatingBar)view.findViewById(R.id.app_rating);
            view.setTag((Object)appViewHolder);
        }
        final long l2 = cursor.getLong(cursor.getColumnIndex("_id"));
        appViewHolder.rating.setRating(cursor.getFloat(cursor.getColumnIndex("rating")));
        appViewHolder.overFlow.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                SearchAdapter.this.showPopup(view, l2);
            }
        });
        appViewHolder.appName.setText((CharSequence)Html.fromHtml((String)string2).toString());
        String string3 = cursor.getString(cursor.getColumnIndex("icon"));
        String string4 = cursor.getString(cursor.getColumnIndex("iconpath"));
        if (string3.contains("_icon")) {
            String[] stringArray = string3.split("\\.(?=[^\\.]+$)");
            string3 = stringArray[0] + "_" + this.sizeString + "." + stringArray[1];
        }
        ImageLoader.getInstance().displayImage(string4 + string3, appViewHolder.appIcon);
        appViewHolder.versionName.setText((CharSequence)cursor.getString(cursor.getColumnIndex("version_name")));
    }

    @Override
    public View newView(Context context, Cursor cursor, ViewGroup viewGroup) {
        return LayoutInflater.from((Context)context).inflate(R.layout.row_app_search_result, viewGroup, false);
    }

    public void showPopup(View view, long l2) {
        PopupMenu popupMenu = new PopupMenu(this.mContext, view);
        popupMenu.setOnMenuItemClickListener(new MenuListener(this.mContext, l2));
        popupMenu.inflate(R.menu.menu_actions);
        popupMenu.show();
    }

    public static class AppViewHolder {
        ImageView appIcon;
        TextView appName;
        TextView downloads;
        ImageView overFlow;
        RatingBar rating;
        TextView versionName;
    }

    static class MenuListener
    implements PopupMenu.OnMenuItemClickListener {
        Context context;
        long id;

        MenuListener(Context context, long l2) {
            this.context = context;
            this.id = l2;
        }

        @Override
        public boolean onMenuItemClick(MenuItem menuItem) {
            int n2 = menuItem.getItemId();
            if (n2 == R.id.menu_install) {
                ((SearchManager)this.context).installApp(this.id);
                Toast.makeText((Context)this.context, (CharSequence)this.context.getString(R.string.starting_download), (int)1).show();
                return true;
            }
            return n2 == R.id.menu_schedule;
        }
    }
}

