/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.adapters;

import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.support.v4.widget.CursorAdapter;
import android.text.Html;
import android.text.format.DateFormat;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import cm.aptoide.ptdev.AppViewActivity;
import cm.aptoide.ptdev.EnumRollbackState;
import cm.aptoide.ptdev.R;
import cm.aptoide.ptdev.RollbackActivity;
import cm.aptoide.ptdev.UninstallRetainFragment;
import cm.aptoide.ptdev.model.RollBackItem;
import com.nostra13.universalimageloader.core.ImageLoader;
import java.util.Date;
import java.util.Locale;

public class RollBackAdapter
extends CursorAdapter {
    private final RollbackActivity activity;

    public RollBackAdapter(RollbackActivity rollbackActivity) {
        super((Context)rollbackActivity, null, 2);
        this.activity = rollbackActivity;
    }

    private static String getActionFromState(String string2, Context context) {
        if (RollBackItem.Action.INSTALLED.toString().equals(string2)) {
            return context.getString(R.string.uninstall);
        }
        if (RollBackItem.Action.UNINSTALLED.toString().equals(string2)) {
            return context.getString(R.string.reinstall);
        }
        if (RollBackItem.Action.UPDATED.toString().equals(string2)) {
            return context.getString(R.string.downgrade);
        }
        if (RollBackItem.Action.DOWNGRADED.toString().equals(string2)) {
            return context.getString(R.string.update);
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void bindView(View view, final Context context, Cursor cursor) {
        int n2;
        RollBackViewHolder rollBackViewHolder = (RollBackViewHolder)view.getTag();
        if (rollBackViewHolder == null) {
            rollBackViewHolder = new RollBackViewHolder();
            rollBackViewHolder.name = (TextView)view.findViewById(R.id.app_name);
            rollBackViewHolder.icon = (ImageView)view.findViewById(R.id.app_icon);
            rollBackViewHolder.version = (TextView)view.findViewById(R.id.app_version);
            rollBackViewHolder.appState = (TextView)view.findViewById(R.id.app_state);
            rollBackViewHolder.action = (TextView)view.findViewById(R.id.ic_action);
            view.setTag((Object)rollBackViewHolder);
        }
        final String string2 = cursor.getString(cursor.getColumnIndex("name"));
        rollBackViewHolder.name.setText((CharSequence)Html.fromHtml((String)string2));
        final String string3 = cursor.getString(cursor.getColumnIndex("icon_path"));
        ImageLoader.getInstance().displayImage(string3, rollBackViewHolder.icon);
        final String string4 = cursor.getString(cursor.getColumnIndex("version"));
        rollBackViewHolder.version.setText((CharSequence)string4);
        long l2 = cursor.getLong(cursor.getColumnIndex("real_timestamp"));
        java.text.DateFormat dateFormat = DateFormat.getTimeFormat((Context)context);
        Date date = new Date(1000L * l2);
        final String string5 = cursor.getString(cursor.getColumnIndex("action"));
        String string6 = null;
        try {
            int n3;
            n2 = n3 = EnumRollbackState.states.get(cursor.getString(cursor.getColumnIndex("action"))).intValue();
        }
        catch (Exception exception) {
            string6 = cursor.getString(cursor.getColumnIndex("action"));
            Log.d((String)"Start-RollbackAdapter", (String)("RollbackAdapter App state " + string6));
            n2 = 0;
        }
        if (string6 == null) {
            string6 = context.getString(n2);
        }
        TextView textView = rollBackViewHolder.appState;
        StringBuilder stringBuilder = new StringBuilder().append(string6).append(" ");
        int n4 = R.string.at_time;
        Object[] objectArray = new Object[]{dateFormat.format(date)};
        textView.setText((CharSequence)stringBuilder.append(context.getString(n4, objectArray)).toString());
        final String string7 = cursor.getString(cursor.getColumnIndex("package_name"));
        final String string8 = cursor.getString(cursor.getColumnIndex("md5"));
        cursor.getString(cursor.getColumnIndex("previous_version"));
        rollBackViewHolder.action.setText((CharSequence)RollBackAdapter.getActionFromState(string5, context));
        rollBackViewHolder.action.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                RollBackItem.Action action = RollBackItem.Action.valueOf(string5.toUpperCase(Locale.ENGLISH));
                switch (action) {
                    default: {
                        Intent intent = new Intent(context, AppViewActivity.class);
                        intent.putExtra("fromRollback", true);
                        intent.putExtra("md5sum", string8);
                        context.startActivity(intent);
                        return;
                    }
                    case INSTALLED: 
                }
                UninstallRetainFragment uninstallRetainFragment = new UninstallRetainFragment(string2, string7, string4, string3);
                RollBackAdapter.this.activity.getSupportFragmentManager().beginTransaction().add(uninstallRetainFragment, "uninstall").commit();
            }
        });
    }

    @Override
    public View newView(Context context, Cursor cursor, ViewGroup viewGroup) {
        this.getItemViewType(cursor.getPosition());
        return LayoutInflater.from((Context)context).inflate(R.layout.row_app_rollback, viewGroup, false);
    }

    public static class RollBackViewHolder {
        public TextView action;
        public TextView appState;
        public ImageView icon;
        public TextView name;
        public TextView version;
    }
}

