/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.adapters;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import cm.aptoide.ptdev.AppViewActivity;
import cm.aptoide.ptdev.R;
import cm.aptoide.ptdev.adapters.BucketListAdapter;
import cm.aptoide.ptdev.utils.AptoideUtils;
import cm.aptoide.ptdev.utils.IconSizes;
import cm.aptoide.ptdev.webservices.json.RelatedApkJson;
import com.nostra13.universalimageloader.core.ImageLoader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class RelatedBucketAdapter
extends BucketListAdapter<RelatedApkJson.Item> {
    final SimpleDateFormat dateFormater = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private final String sizeString;

    public RelatedBucketAdapter(Activity activity, List<RelatedApkJson.Item> list) {
        super(activity, list);
        this.enableAutoMeasure(120.0f);
        this.sizeString = IconSizes.generateSizeString((Context)activity);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected View bindBucketElement(int n2, RelatedApkJson.Item item, View view, ViewGroup viewGroup) {
        View view2;
        ViewHolder viewHolder;
        if (view == null) {
            viewHolder = new ViewHolder();
            view2 = LayoutInflater.from((Context)this.ctx).inflate(R.layout.row_app_related, viewGroup, false);
            viewHolder.version = (TextView)view2.findViewById(R.id.app_version);
            viewHolder.name = (TextView)view2.findViewById(R.id.app_name);
            viewHolder.icon = (ImageView)view2.findViewById(R.id.app_icon);
            viewHolder.repo = (TextView)view2.findViewById(R.id.app_repo);
            viewHolder.timestamp = (TextView)view2.findViewById(R.id.app_timestamp);
            view2.setTag((Object)viewHolder);
        } else {
            view2 = view;
            viewHolder = (ViewHolder)view2.getTag();
        }
        final RelatedApkJson.Item item2 = (RelatedApkJson.Item)this.getItem(n2);
        Log.d((String)"Aptoide-Related", (String)("adding item " + item2.getName() + " " + item2.getVername() + " " + item2.getRepo()));
        viewHolder.name.setText((CharSequence)item2.getName());
        viewHolder.version.setText((CharSequence)item2.getVername());
        viewHolder.repo.setText((CharSequence)(this.getContext().getString(R.string.store) + ": " + item2.getRepo()));
        try {
            Date date = this.dateFormater.parse(item2.getTimestamp());
            viewHolder.timestamp.setText((CharSequence)AptoideUtils.DateDiffUtils.getDiffDate(this.getContext(), date));
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        Log.d((String)"Aptoide-Related", (String)(" item " + item2.getName() + " " + item2.getVername() + " " + item2.getRepo()));
        String string2 = item2.getIcon();
        if (string2.contains("_icon")) {
            String[] stringArray = string2.split("\\.(?=[^\\.]+$)");
            string2 = stringArray[0] + "_" + this.sizeString + "." + stringArray[1];
        }
        ImageLoader.getInstance().displayImage(string2, viewHolder.icon);
        view2.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Intent intent = new Intent(RelatedBucketAdapter.this.getContext(), AppViewActivity.class);
                intent.putExtra("fromRelated", true);
                intent.putExtra("appName", item2.getName());
                intent.putExtra("repoName", item2.getRepo());
                intent.putExtra("md5sum", item2.getMd5sum());
                RelatedBucketAdapter.this.getContext().startActivity(intent);
            }
        });
        return view2;
    }

    @Override
    public int getBucketSize() {
        return super.getBucketSize();
    }

    public boolean isEnabled(int n2) {
        return false;
    }

    static class ViewHolder {
        ImageView icon;
        TextView name;
        TextView repo;
        TextView timestamp;
        TextView version;

        ViewHolder() {
        }
    }
}

