/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.adapters;

import android.app.Activity;
import android.content.Context;
import android.support.v7.widget.PopupMenu;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Toast;
import cm.aptoide.ptdev.Aptoide;
import cm.aptoide.ptdev.DownloadInterface;
import cm.aptoide.ptdev.R;
import cm.aptoide.ptdev.database.Database;
import cm.aptoide.ptdev.model.Collection;
import cm.aptoide.ptdev.utils.IconSizes;
import java.util.ArrayList;

public class PrincipalLayoutAdapter
extends BaseAdapter {
    private boolean b;
    private final int bucketSize;
    private final Activity context;
    private float density;
    private final String iconSize;
    private ArrayList<Collection> list;
    private boolean mWasEndedAlready;

    public PrincipalLayoutAdapter(Activity activity, ArrayList<Collection> arrayList, boolean bl2) {
        this.context = activity;
        this.list = arrayList;
        this.b = bl2;
        this.bucketSize = (int)(this.getScreenWidthInDip() / 120.0f);
        this.iconSize = IconSizes.generateSizeString((Context)activity);
    }

    static /* synthetic */ boolean access$302(PrincipalLayoutAdapter principalLayoutAdapter, boolean bl2) {
        principalLayoutAdapter.mWasEndedAlready = bl2;
        return bl2;
    }

    public int getBucketSize() {
        return this.bucketSize;
    }

    public int getCount() {
        return this.list.size();
    }

    public Collection getItem(int n2) {
        return this.list.get(n2);
    }

    public long getItemId(int n2) {
        return 0L;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getItemViewType(int n2) {
        int n3 = this.list.get(n2).isExpanded() ? 0 : 1;
        Log.d((String)"Aptoide-HomeLayout", (String)("viewType is " + n3));
        return 0;
    }

    protected float getScreenWidthInDip() {
        WindowManager windowManager = this.context.getWindowManager();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        float f2 = (float)displayMetrics.widthPixels / displayMetrics.density;
        this.density = displayMetrics.density;
        return f2;
    }

    public View getView(int n2, View view, ViewGroup viewGroup) {
        Collection collection = this.getItem(n2);
        if (view == null || view.getTag() != null && !((AbstractItem)view.getTag()).getType().equals(((AbstractItem)collection).getType())) {
            view = ((AbstractItem)collection).inflateSelf((Context)this.context, this.bucketSize);
        }
        ((AbstractItem)collection).fillViewWithData((Context)this.context, view);
        view.setTag((Object)collection);
        return view;
    }

    public int getViewTypeCount() {
        return 1;
    }

    public boolean isEnabled(int n2) {
        return false;
    }

    public void showPopup(View view, long l2) {
        PopupMenu popupMenu = new PopupMenu((Context)this.context, view);
        popupMenu.setOnMenuItemClickListener(new MenuListener((Context)this.context, l2));
        popupMenu.inflate(R.menu.menu_actions);
        popupMenu.show();
    }

    public static abstract class AbstractItem {
        public abstract void fillViewWithData(Context var1, View var2);

        public abstract String getType();

        public abstract View inflateSelf(Context var1, int var2);
    }

    private class AnimationClickListener
    implements View.OnClickListener {
        private final ImageView iv;
        private final int parentId;
        private final int position;
        private final View view;

        public AnimationClickListener(ImageView imageView, View view, int n2, int n3) {
            this.position = n2;
            this.parentId = n3;
            this.view = view;
            this.iv = imageView;
        }

        public void onClick(View view) {
            Collection collection = PrincipalLayoutAdapter.this.getItem(this.position);
            if (!collection.isExpanded()) {
                collection.getAppsList().clear();
                collection.getAppsList().addAll(new Database(Aptoide.getDb()).getCollectionFeatured(this.parentId, 10));
            }
            if (!collection.isExpanded()) {
                int n2 = collection.getAppsList().size() / PrincipalLayoutAdapter.this.bucketSize;
                if (collection.getAppsList().size() % PrincipalLayoutAdapter.this.bucketSize != 0) {
                    ++n2;
                }
                Log.d((String)"Aptoide-HomeLayout", (String)("Size to grow is " + n2 + " " + collection.getAppsList().size()));
                int n3 = (int)(190.0f * PrincipalLayoutAdapter.this.density * (float)n2);
                Log.d((String)"Aptoide-HomeLayout", (String)("MaxMargin  is " + n3));
                int n4 = (int)((float)(-n3) + 190.0f * PrincipalLayoutAdapter.this.density);
                Log.d((String)"Aptoide-HomeLayout", (String)("MarginStart  is " + n4));
                collection.setMarginBottom(n4);
                PrincipalLayoutAdapter.this.notifyDataSetChanged();
            }
            LinearLayout linearLayout = (LinearLayout)this.view.findViewById(R.id.collectionList);
            linearLayout.startAnimation((Animation)new ExpandAnimation(this.iv, collection, (View)linearLayout, 150, collection.isExpanded()));
        }

        public class ExpandAnimation
        extends Animation {
            private Collection collection;
            private View mAnimatedView;
            private boolean mIsVisibleAfter = false;
            private int mMarginEnd;
            private int mMarginStart;
            private LinearLayout.LayoutParams mViewLayoutParams;

            /*
             * Enabled aggressive block sorting
             */
            public ExpandAnimation(ImageView imageView, Collection collection, View view, int n2, boolean bl2) {
                this.collection = collection;
                this.setDuration(n2);
                this.mAnimatedView = view;
                this.mViewLayoutParams = (LinearLayout.LayoutParams)view.getLayoutParams();
                int n3 = collection.getAppsList().size() / PrincipalLayoutAdapter.this.bucketSize;
                if (collection.getAppsList().size() % PrincipalLayoutAdapter.this.bucketSize != 0) {
                    ++n3;
                }
                int n4 = (int)(190.0f * PrincipalLayoutAdapter.this.density * (float)n3);
                if (!bl2) {
                    this.mMarginStart = (int)((float)(-n4) + 190.0f * PrincipalLayoutAdapter.this.density);
                    this.mMarginEnd = 0;
                    TypedValue typedValue = new TypedValue();
                    PrincipalLayoutAdapter.this.context.getTheme().resolveAttribute(R.attr.icCollapseDrawable, typedValue, true);
                    imageView.setImageResource(typedValue.resourceId);
                    collection.setExpanded2(true);
                } else {
                    this.mMarginEnd = (int)(190.0f * PrincipalLayoutAdapter.this.density) - n4;
                    this.mMarginStart = 0;
                    TypedValue typedValue = new TypedValue();
                    PrincipalLayoutAdapter.this.context.getTheme().resolveAttribute(R.attr.icExpandDrawable, typedValue, true);
                    imageView.setImageResource(typedValue.resourceId);
                    collection.setExpanded2(false);
                }
                PrincipalLayoutAdapter.access$302(PrincipalLayoutAdapter.this, false);
                view.setVisibility(0);
            }

            /*
             * Enabled aggressive block sorting
             */
            protected void applyTransformation(float f2, Transformation transformation) {
                super.applyTransformation(f2, transformation);
                if (f2 < 1.0f) {
                    LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)this.mAnimatedView.getLayoutParams();
                    layoutParams.bottomMargin = this.mMarginStart + (int)(f2 * (float)(this.mMarginEnd - this.mMarginStart));
                    Log.d((String)"Aptoide-HomeLayout", (String)("Applying transform: bottom margin is " + layoutParams.bottomMargin + " " + this.mMarginStart + " " + this.mMarginEnd));
                    this.mAnimatedView.requestLayout();
                    return;
                } else {
                    if (PrincipalLayoutAdapter.this.mWasEndedAlready) return;
                    ((LinearLayout.LayoutParams)this.mAnimatedView.getLayoutParams()).bottomMargin = this.mMarginEnd;
                    this.mAnimatedView.requestLayout();
                    this.collection.setMarginBottom(0);
                    if (this.collection.isExpanded()) {
                        this.collection.getAppsList().clear();
                        this.collection.getAppsList().addAll(new Database(Aptoide.getDb()).getCollectionFeatured(AnimationClickListener.this.parentId, PrincipalLayoutAdapter.this.bucketSize));
                        PrincipalLayoutAdapter.this.notifyDataSetChanged();
                    }
                    Collection collection = this.collection;
                    boolean bl2 = this.collection.isExpanded();
                    boolean bl3 = false;
                    if (!bl2) {
                        bl3 = true;
                    }
                    collection.setExpanded(bl3);
                    PrincipalLayoutAdapter.access$302(PrincipalLayoutAdapter.this, true);
                    return;
                }
            }
        }
    }

    static class MenuListener
    implements PopupMenu.OnMenuItemClickListener {
        Context context;
        long id;

        MenuListener(Context context, long l2) {
            this.context = context;
            this.id = l2;
        }

        @Override
        public boolean onMenuItemClick(MenuItem menuItem) {
            int n2 = menuItem.getItemId();
            if (n2 == R.id.menu_install) {
                ((DownloadInterface)this.context).installApp(this.id);
                Toast.makeText((Context)this.context, (CharSequence)this.context.getString(R.string.starting_download), (int)1).show();
                return true;
            }
            return n2 == R.id.menu_schedule;
        }
    }
}

