/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.adapters;

import android.content.Context;
import android.text.Html;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import cm.aptoide.ptdev.R;
import cm.aptoide.ptdev.downloadmanager.Utils;
import cm.aptoide.ptdev.model.Download;
import com.nostra13.universalimageloader.core.ImageLoader;
import java.util.ArrayList;

public class OngoingAdapter
extends ArrayAdapter<Download> {
    private Context context;
    private final ArrayList<Download> list;

    public OngoingAdapter(Context context, ArrayList<Download> arrayList) {
        super(context, 0, arrayList);
        this.context = context;
        this.list = arrayList;
    }

    public int getCount() {
        return this.list.size();
    }

    public Download getItem(int n2) {
        return this.list.get(n2);
    }

    public long getItemId(int n2) {
        return this.getItem(n2).getId();
    }

    /*
     * Enabled aggressive block sorting
     */
    public View getView(int n2, View view, ViewGroup viewGroup) {
        Log.d((String)"Aptoide", (String)"Updating view2");
        View view2 = view == null ? LayoutInflater.from((Context)this.context).inflate(R.layout.row_app_downloading, viewGroup, false) : view;
        final Download download = this.getItem(n2);
        ((TextView)view2.findViewById(R.id.app_name)).setText((CharSequence)Html.fromHtml((String)download.getName()).toString());
        ImageLoader.getInstance().displayImage(download.getIcon(), (ImageView)view2.findViewById(R.id.app_icon));
        ProgressBar progressBar = (ProgressBar)view2.findViewById(R.id.downloading_progress);
        progressBar.setIndeterminate(false);
        progressBar.setProgress(download.getProgress());
        View view3 = view2.findViewById(R.id.download_details_layout);
        view3.setVisibility(0);
        ((TextView)view3.findViewById(R.id.speed)).setText((CharSequence)(Utils.formatBits((long)download.getSpeed()) + "/s"));
        ((TextView)view3.findViewById(R.id.eta)).setText((CharSequence)Utils.formatEta(download.getTimeLeft(), this.context.getString(R.string.remaining_time)));
        ((TextView)view3.findViewById(R.id.progress)).setText((CharSequence)(download.getProgress() + "%"));
        view2.findViewById(R.id.manage_icon).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                download.getParent().remove();
            }
        });
        if (view2 == null) {
            Log.e((String)"Aptoide-Section", (String)"View is null");
        }
        return view2;
    }
}

