/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.adapters;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.v7.widget.PopupMenu;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RatingBar;
import android.widget.TextView;
import android.widget.Toast;
import cm.aptoide.ptdev.AppViewActivity;
import cm.aptoide.ptdev.DownloadInterface;
import cm.aptoide.ptdev.R;
import cm.aptoide.ptdev.adapters.BucketListAdapter;
import cm.aptoide.ptdev.fragments.HomeItem;
import cm.aptoide.ptdev.utils.AptoideUtils;
import cm.aptoide.ptdev.utils.IconSizes;
import com.nostra13.universalimageloader.core.ImageLoader;
import java.util.List;

public class HomeBucketAdapter
extends BucketListAdapter<HomeItem> {
    private final String sizeString;

    public HomeBucketAdapter(Activity activity, List<HomeItem> list) {
        super(activity, list);
        this.enableAutoMeasure(120.0f);
        this.sizeString = IconSizes.generateSizeString((Context)activity);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected View bindBucketElement(int n2, final HomeItem homeItem, View view, ViewGroup viewGroup) {
        View view2;
        ViewHolder viewHolder;
        if (view == null) {
            viewHolder = new ViewHolder();
            view2 = LayoutInflater.from((Context)this.ctx).inflate(R.layout.row_app_home, viewGroup, false);
            viewHolder.category = (TextView)view2.findViewById(R.id.app_category);
            viewHolder.name = (TextView)view2.findViewById(R.id.app_name);
            viewHolder.icon = (ImageView)view2.findViewById(R.id.app_icon);
            viewHolder.downloads = (TextView)view2.findViewById(R.id.app_downloads);
            viewHolder.rating = (RatingBar)view2.findViewById(R.id.app_rating);
            view2.setTag((Object)viewHolder);
        } else {
            view2 = view;
            viewHolder = (ViewHolder)view2.getTag();
        }
        viewHolder.name.setText((CharSequence)homeItem.getName());
        viewHolder.category.setText((CharSequence)homeItem.getCategory());
        String string2 = homeItem.getIcon();
        if (string2.contains("_icon")) {
            String[] stringArray = string2.split("\\.(?=[^\\.]+$)");
            string2 = stringArray[0] + "_" + this.sizeString + "." + stringArray[1];
        }
        ImageLoader.getInstance().displayImage(string2, viewHolder.icon);
        TextView textView = viewHolder.downloads;
        Context context = this.getContext();
        int n3 = R.string.X_download_number;
        Object[] objectArray = new Object[]{AptoideUtils.withSuffix(homeItem.getDownloads())};
        textView.setText((CharSequence)context.getString(n3, objectArray));
        if (homeItem.getName().length() > 10) {
            viewHolder.downloads.setMaxLines(1);
        } else {
            viewHolder.downloads.setMaxLines(2);
        }
        viewHolder.downloads.setVisibility(0);
        viewHolder.rating.setRating(homeItem.getRating());
        viewHolder.rating.setOnRatingBarChangeListener(null);
        ((ImageView)view2.findViewById(R.id.ic_action)).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                HomeBucketAdapter.this.showPopup(view, homeItem.getId());
            }
        });
        view2.setOnClickListener(new View.OnClickListener(){

            /*
             * Enabled aggressive block sorting
             */
            public void onClick(View view) {
                Intent intent = new Intent(HomeBucketAdapter.this.getContext(), AppViewActivity.class);
                if (homeItem.isRecommended()) {
                    intent.putExtra("fromRelated", true);
                    intent.putExtra("md5sum", homeItem.getMd5());
                    intent.putExtra("repoName", homeItem.getRepoName());
                } else {
                    intent.putExtra("id", homeItem.getId());
                }
                HomeBucketAdapter.this.getContext().startActivity(intent);
            }
        });
        return view2;
    }

    @Override
    public int getBucketSize() {
        return super.getBucketSize();
    }

    public boolean isEnabled(int n2) {
        return false;
    }

    public void showPopup(View view, long l2) {
        PopupMenu popupMenu = new PopupMenu(this.getContext(), view);
        popupMenu.setOnMenuItemClickListener(new MenuListener(this.getContext(), l2));
        popupMenu.inflate(R.menu.menu_actions);
        popupMenu.show();
    }

    static class MenuListener
    implements PopupMenu.OnMenuItemClickListener {
        Context context;
        long id;

        MenuListener(Context context, long l2) {
            this.context = context;
            this.id = l2;
        }

        @Override
        public boolean onMenuItemClick(MenuItem menuItem) {
            int n2 = menuItem.getItemId();
            if (n2 == R.id.menu_install) {
                ((DownloadInterface)this.context).installApp(this.id);
                Toast.makeText((Context)this.context, (CharSequence)this.context.getString(R.string.starting_download), (int)1).show();
                return true;
            }
            return n2 == R.id.menu_schedule;
        }
    }

    static class ViewHolder {
        TextView category;
        TextView downloads;
        ImageView icon;
        TextView name;
        RatingBar rating;

        ViewHolder() {
        }
    }
}

