/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.adapters;

import android.content.Context;
import android.database.Cursor;
import android.support.v4.widget.CursorAdapter;
import android.support.v7.widget.PopupMenu;
import android.text.Html;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RatingBar;
import android.widget.TextView;
import android.widget.Toast;
import cm.aptoide.ptdev.Category;
import cm.aptoide.ptdev.EnumCategories;
import cm.aptoide.ptdev.EnumStoreTheme;
import cm.aptoide.ptdev.R;
import cm.aptoide.ptdev.StoreActivity;
import cm.aptoide.ptdev.utils.IconSizes;
import com.nostra13.universalimageloader.core.ImageLoader;
import java.util.ArrayList;
import java.util.Locale;

public class CategoryGridAdapter
extends CursorAdapter {
    private final Context context;
    ArrayList<Category> items;
    private final String sizeString;

    public CategoryGridAdapter(Context context) {
        super(context, null, 2);
        this.context = context;
        this.sizeString = IconSizes.generateSizeString(context);
    }

    private int getItemViewType(Cursor cursor) {
        return cursor.getInt(cursor.getColumnIndex("type"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void bindView(View view, Context context, Cursor cursor) {
        EnumStoreTheme enumStoreTheme;
        String string2;
        String string3 = cursor.getString(cursor.getColumnIndex("name"));
        int n2 = cursor.getInt(cursor.getColumnIndex("count"));
        int n3 = this.getItemViewType(cursor);
        final int n4 = cursor.getInt(cursor.getColumnIndex("_id"));
        switch (n3) {
            default: {
                return;
            }
            case 0: {
                AppViewHolder appViewHolder = (AppViewHolder)view.getTag();
                if (appViewHolder == null) {
                    appViewHolder = new AppViewHolder();
                    appViewHolder.appIcon = (ImageView)view.findViewById(R.id.app_icon);
                    appViewHolder.overFlow = (ImageView)view.findViewById(R.id.ic_action);
                    appViewHolder.appName = (TextView)view.findViewById(R.id.app_name);
                    appViewHolder.versionName = (TextView)view.findViewById(R.id.app_version);
                    appViewHolder.rating = (RatingBar)view.findViewById(R.id.app_rating);
                    view.setTag((Object)appViewHolder);
                }
                ImageView imageView = appViewHolder.overFlow;
                View.OnClickListener onClickListener = new View.OnClickListener(){

                    public void onClick(View view) {
                        CategoryGridAdapter.this.showPopup(view, n4);
                    }
                };
                imageView.setOnClickListener(onClickListener);
                appViewHolder.appName.setText((CharSequence)Html.fromHtml((String)string3).toString());
                appViewHolder.rating.setRating(cursor.getFloat(cursor.getColumnIndex("rating")));
                String string4 = cursor.getString(cursor.getColumnIndex("icon"));
                String string5 = cursor.getString(cursor.getColumnIndex("iconpath"));
                if (string4.contains("_icon")) {
                    String[] stringArray = string4.split("\\.(?=[^\\.]+$)");
                    string4 = stringArray[0] + "_" + this.sizeString + "." + stringArray[1];
                }
                ImageLoader.getInstance().displayImage(string5 + string4, appViewHolder.appIcon);
                appViewHolder.versionName.setText((CharSequence)cursor.getString(cursor.getColumnIndex("version_name")));
                return;
            }
            case 1: 
        }
        ImageView imageView = (ImageView)view.findViewById(R.id.category_first_level_icon);
        try {
            string2 = context.getString(EnumCategories.getCategoryName(n4));
            Log.d((String)"CategoryGridAdapter-categ", (String)("Category Name: " + string2));
        }
        catch (Exception exception) {
            string2 = string3;
            Log.d((String)"CategoryGridAdapter-categ", (String)("Untranslated Category Name: " + string2));
        }
        ((TextView)view.findViewById(R.id.category_first_level_name)).setText((CharSequence)string2);
        if (n2 > 0) {
            ((TextView)view.findViewById(R.id.category_first_level_number)).setText((CharSequence)String.valueOf(n2));
        } else {
            ((TextView)view.findViewById(R.id.category_first_level_number)).setText((CharSequence)"");
        }
        String string6 = cursor.getString(cursor.getColumnIndex("theme")).toUpperCase(Locale.ENGLISH);
        String string7 = cursor.getString(cursor.getColumnIndex("repo_name")).toUpperCase(Locale.ENGLISH);
        try {
            EnumStoreTheme enumStoreTheme2;
            enumStoreTheme = enumStoreTheme2 = EnumStoreTheme.valueOf("APTOIDE_STORE_THEME_" + string6);
        }
        catch (Exception exception) {
            enumStoreTheme = EnumStoreTheme.APTOIDE_STORE_THEME_ORANGE;
        }
        switch (n4) {
            default: {
                String string8 = EnumCategories.getCategoryIcon(n4, string7);
                if (string8 == null) break;
                ImageLoader.getInstance().displayImage(string8, imageView);
                return;
            }
            case 1: {
                imageView.setImageResource(R.drawable.cat_applications);
                return;
            }
            case 2: {
                imageView.setImageResource(R.drawable.cat_games);
                return;
            }
            case 500: {
                imageView.setImageResource(R.drawable.cat_top_apps);
                return;
            }
            case 501: {
                imageView.setImageResource(R.drawable.cat_latest);
                return;
            }
            case 502: {
                imageView.setImageResource(R.drawable.cat_likes);
                return;
            }
            case 503: {
                imageView.setImageResource(R.drawable.cat_comments);
                return;
            }
            case 504: {
                imageView.setImageResource(R.drawable.cat_recommended);
                return;
            }
        }
        imageView.setImageResource(enumStoreTheme.getStoreCategoryDrawable());
    }

    public int getItemViewType(int n2) {
        return this.getItemViewType((Cursor)this.getItem(n2));
    }

    public int getViewTypeCount() {
        return 2;
    }

    @Override
    public View newView(Context context, Cursor cursor, ViewGroup viewGroup) {
        switch (this.getItemViewType(cursor)) {
            default: {
                return null;
            }
            case 0: {
                return LayoutInflater.from((Context)context).inflate(R.layout.row_app_standard_grid, viewGroup, false);
            }
            case 1: 
        }
        return LayoutInflater.from((Context)context).inflate(R.layout.row_item_category_first_level_grid, viewGroup, false);
    }

    public void showPopup(View view, long l2) {
        PopupMenu popupMenu = new PopupMenu(this.context, view);
        popupMenu.setOnMenuItemClickListener(new MenuListener(this.context, l2));
        popupMenu.inflate(R.menu.menu_actions);
        popupMenu.show();
    }

    public static class AppViewHolder {
        ImageView appIcon;
        TextView appName;
        TextView downloads;
        ImageView overFlow;
        RatingBar rating;
        TextView versionName;
    }

    static class MenuListener
    implements PopupMenu.OnMenuItemClickListener {
        Context context;
        long id;

        MenuListener(Context context, long l2) {
            this.context = context;
            this.id = l2;
        }

        @Override
        public boolean onMenuItemClick(MenuItem menuItem) {
            int n2 = menuItem.getItemId();
            if (n2 == R.id.menu_install) {
                ((StoreActivity)this.context).installApp(this.id);
                Toast.makeText((Context)this.context, (CharSequence)this.context.getString(R.string.starting_download), (int)1).show();
                return true;
            }
            return n2 == R.id.menu_schedule;
        }
    }
}

