/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev.adapters;

import android.app.Activity;
import android.content.Context;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.AbsListView;
import android.widget.ArrayAdapter;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import java.util.List;

public abstract class BucketListAdapter<T>
extends ArrayAdapter<T> {
    private static final String TAG = "BucketListAdapter";
    private final boolean DEBUG;
    protected Integer bucketSize;
    protected Activity ctx;

    public BucketListAdapter(Activity activity, List<T> list) {
        this(activity, list, 1);
    }

    public BucketListAdapter(Activity activity, List<T> list, Integer n2) {
        super((Context)activity, 0, list);
        this.DEBUG = true;
        this.ctx = activity;
        this.bucketSize = n2;
    }

    protected abstract View bindBucketElement(int var1, T var2, View var3, ViewGroup var4);

    public void enableAutoMeasure(float f2) {
        float f3 = this.getScreenWidthInDip();
        if (f2 >= f3) {
            this.bucketSize = 1;
            return;
        }
        this.bucketSize = (int)(f3 / f2);
    }

    public int getBucketSize() {
        return this.bucketSize;
    }

    public int getCount() {
        return (-1 + (super.getCount() + this.bucketSize)) / this.bucketSize;
    }

    public T getItem(int n2) {
        return (T)super.getItem(n2);
    }

    public long getItemId(int n2) {
        return n2;
    }

    public int getItemViewType(int n2) {
        if (n2 == -1 + this.getCount()) {
            return 0;
        }
        return 1;
    }

    protected float getScreenWidthInDip() {
        WindowManager windowManager = this.ctx.getWindowManager();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        return (float)displayMetrics.widthPixels / displayMetrics.density;
    }

    /*
     * Enabled aggressive block sorting
     */
    public View getView(int n2, View view, ViewGroup viewGroup) {
        LinearLayout linearLayout;
        if (view != null) {
            linearLayout = (LinearLayout)view;
            Log.i((String)TAG, (String)("Reusing bucket view of type " + this.getItemViewType(n2)));
        } else {
            linearLayout = new LinearLayout((Context)this.ctx);
            linearLayout.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, -1));
            linearLayout.setOrientation(0);
            Log.i((String)TAG, (String)"Instantiating new bucket view");
        }
        int n3 = 0;
        int n4 = linearLayout.getChildCount();
        int n5 = n2 * this.bucketSize;
        while (n5 < n2 * this.bucketSize + this.bucketSize) {
            if (n3 < n4) {
                FrameLayout frameLayout = (FrameLayout)linearLayout.getChildAt(n3);
                Log.i((String)TAG, (String)("Reusing bucketElementFrame view with " + n4 + " childs"));
                if (n5 < super.getCount()) {
                    this.bindBucketElement(n5, this.getItem(n5), frameLayout.getChildAt(0), (ViewGroup)frameLayout);
                    Log.i((String)TAG, (String)"Reusing element view");
                }
            } else {
                FrameLayout frameLayout = new FrameLayout((Context)this.ctx);
                frameLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 1.0f));
                if (n5 < super.getCount()) {
                    frameLayout.addView(this.bindBucketElement(n5, this.getItem(n5), null, (ViewGroup)frameLayout));
                }
                linearLayout.addView((View)frameLayout);
            }
            ++n3;
            ++n5;
        }
        return linearLayout;
    }

    public int getViewTypeCount() {
        return 2;
    }
}

