/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev;

import android.content.Context;
import android.database.MatrixCursor;
import android.net.Uri;
import android.util.Log;
import com.codebutler.android_websockets.WebSocketClient;
import java.net.URI;
import java.util.concurrent.BlockingQueue;
import org.json.JSONArray;
import org.json.JSONException;

public class WebSocketSingleton {
    private static WebSocketClient web_socket_client;
    private BlockingQueue blockingQueue;
    private String buffer;
    private WebSocketClient.Listener listener;
    private Context mContext;
    private Uri mNotificationUri;
    String[] matrix_columns = new String[]{"suggest_icon_1", "suggest_text_1", "suggest_intent_query", "_id"};
    private String query;

    private WebSocketSingleton() {
        this.listener = new WebSocketClient.Listener(){

            @Override
            public void onConnect() {
                Log.d((String)"TAG", (String)"On Connect");
            }

            @Override
            public void onDisconnect(int n2, String string2) {
                Log.d((String)"TAG", (String)string2);
            }

            @Override
            public void onError(Exception exception) {
                exception.printStackTrace();
            }

            @Override
            public void onMessage(String string2) {
                JSONArray jSONArray = new JSONArray(string2);
                MatrixCursor matrixCursor = new MatrixCursor(WebSocketSingleton.this.matrix_columns);
                int n2 = 0;
                while (true) {
                    if (n2 >= jSONArray.length()) break;
                    String string3 = jSONArray.get(n2).toString();
                    Log.d((String)"TAG", (String)("Suggestion " + string3));
                    WebSocketSingleton.this.addRow(matrixCursor, string3, n2);
                    ++n2;
                    continue;
                    break;
                }
                try {
                    if (jSONArray.length() == 0) {
                        WebSocketSingleton.access$102(WebSocketSingleton.this, WebSocketSingleton.this.query);
                    }
                    WebSocketSingleton.this.blockingQueue.add(matrixCursor);
                    return;
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                    return;
                }
            }

            @Override
            public void onMessage(byte[] byArray) {
                Log.d((String)"TAG", (String)byArray.toString());
            }
        };
    }

    static /* synthetic */ String access$102(WebSocketSingleton webSocketSingleton, String string2) {
        webSocketSingleton.buffer = string2;
        return string2;
    }

    private void addRow(MatrixCursor matrixCursor, String string2, int n2) {
        matrixCursor.newRow().add(null).add((Object)string2).add((Object)string2).add((Object)n2);
    }

    public static WebSocketSingleton getInstance() {
        return WebSocketHolder.INSTANCE;
    }

    public void connect() {
        if (web_socket_client == null) {
            web_socket_client = new WebSocketClient(URI.create("ws://buzz.webservices.aptoide.com:9000"), this.listener, null);
            web_socket_client.connect();
        }
        Log.d((String)"TAG", (String)"OnConnecting");
    }

    public void disconnect() {
        Log.d((String)"TAG", (String)"onDisconnect");
        if (web_socket_client != null) {
            web_socket_client.disconnect();
            web_socket_client = null;
        }
    }

    public void send(String string2) {
        this.query = string2;
        if (web_socket_client.isConnected() && string2.length() > 2 && (this.buffer == null || !string2.startsWith(this.buffer))) {
            web_socket_client.send("{\"query\":\"" + string2 + "\"}");
            Log.d((String)"TAG", (String)("Sending " + string2));
            return;
        }
        this.blockingQueue.add(null);
    }

    public void setBlockingQueue(BlockingQueue blockingQueue) {
        this.blockingQueue = blockingQueue;
    }

    public WebSocketSingleton setContext(Context context) {
        this.mContext = context;
        return this;
    }

    public WebSocketSingleton setNotificationUri(Uri uri) {
        this.mNotificationUri = uri;
        return this;
    }

    private static class WebSocketHolder {
        public static final WebSocketSingleton INSTANCE = new WebSocketSingleton();

        private WebSocketHolder() {
        }
    }
}

