/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.content.AbstractThreadedSyncAdapter;
import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SyncResult;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.util.Log;
import cm.aptoide.ptdev.AppViewActivity;
import cm.aptoide.ptdev.utils.AptoideUtils;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.GetResponse;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.impl.AMQConnection;
import com.rabbitmq.client.impl.ChannelN;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.json.JSONException;
import org.json.JSONObject;

public class WebInstallSyncAdapter
extends AbstractThreadedSyncAdapter {
    public WebInstallSyncAdapter(Context context, boolean bl2) {
        super(context, bl2);
    }

    void handleMessage(String string2) {
        try {
            Account account = AccountManager.get((Context)this.getContext()).getAccountsByType("cm.aptoide.pt")[0];
            JSONObject jSONObject = new JSONObject(string2);
            Intent intent = new Intent(this.getContext(), AppViewActivity.class);
            String string3 = ((Bundle)AccountManager.get((Context)this.getContext()).getAuthToken(account, "Full access", null, null, null, null).getResult()).getString("authtoken");
            String string4 = jSONObject.getString("repo");
            long l2 = jSONObject.getLong("id");
            String string5 = jSONObject.getString("md5sum");
            intent.putExtra("fromMyapp", true);
            intent.putExtra("repoName", string4);
            intent.putExtra("id", l2);
            intent.putExtra("md5sum", string5);
            String string6 = Settings.Secure.getString((ContentResolver)this.getContext().getContentResolver(), (String)"android_id");
            intent.setFlags(0x10000000);
            if (jSONObject.getString("hmac").equals(AptoideUtils.Algorithms.computeHmacSha1(string4 + l2 + string5, string3 + string6))) {
                this.getContext().startActivity(intent);
            }
            return;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return;
        }
        catch (AuthenticatorException authenticatorException) {
            authenticatorException.printStackTrace();
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            return;
        }
        catch (OperationCanceledException operationCanceledException) {
            operationCanceledException.printStackTrace();
            return;
        }
        catch (InvalidKeyException invalidKeyException) {
            invalidKeyException.printStackTrace();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void onPerformSync(Account account, Bundle bundle, String string2, ContentProviderClient contentProviderClient, SyncResult syncResult) {
        Log.d((String)"Aptoide-WebInstall", (String)"onPerformSync()");
        String string3 = PreferenceManager.getDefaultSharedPreferences((Context)this.getContext()).getString("queueName", "");
        ConnectionFactory connectionFactory = new ConnectionFactory();
        connectionFactory.setHost("amqp.webservices.aptoide.com");
        connectionFactory.setConnectionTimeout(20000);
        connectionFactory.setVirtualHost("webinstall");
        connectionFactory.setUsername("public");
        connectionFactory.setPassword("public");
        AMQConnection aMQConnection = null;
        ChannelN channelN = null;
        try {
            GetResponse getResponse;
            aMQConnection = (AMQConnection)connectionFactory.newConnection();
            channelN = (ChannelN)aMQConnection.createChannel();
            channelN.basicQos(0);
            while ((getResponse = channelN.basicGet(string3, false)) != null) {
                String string4 = new String(getResponse.getBody(), "UTF-8");
                Log.d((String)"syncAdapter", (String)("MESSAGE: " + string4));
                this.handleMessage(string4);
                channelN.basicAck(getResponse.getEnvelope().getDeliveryTag(), false);
            }
            channelN.close();
            aMQConnection.disconnectChannel(channelN);
            aMQConnection.close();
            return;
        }
        catch (ShutdownSignalException shutdownSignalException) {
            if (aMQConnection == null) return;
            if (channelN == null) return;
            aMQConnection.disconnectChannel(channelN);
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            if (aMQConnection == null) return;
            if (channelN == null) return;
            aMQConnection.disconnectChannel(channelN);
            return;
        }
    }
}

