/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev;

import android.app.Activity;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v7.app.ActionBarActivity;
import android.util.Log;
import cm.aptoide.ptdev.Aptoide;
import cm.aptoide.ptdev.adapters.UninstallHelper;
import cm.aptoide.ptdev.database.Database;
import cm.aptoide.ptdev.dialogs.AptoideDialog;
import cm.aptoide.ptdev.model.RollBackItem;
import cm.aptoide.ptdev.utils.AptoideUtils;
import java.io.File;

public class UninstallRetainFragment
extends Fragment {
    private ActionBarActivity activity;
    private String appName;
    private String iconPath;
    private long id;
    private String packageName;
    private RollBackItem.Action rollBackAction;
    private String versionName;
    private String versionToDowngrade;

    public UninstallRetainFragment(long l2) {
        this.id = l2;
        this.rollBackAction = RollBackItem.Action.UNINSTALLING;
    }

    public UninstallRetainFragment(String string2, String string3, String string4, String string5) {
        this.appName = string2;
        this.packageName = string3;
        this.versionName = string4;
        this.iconPath = string5;
        this.rollBackAction = RollBackItem.Action.UNINSTALLING;
    }

    public UninstallRetainFragment(String string2, String string3, String string4, String string5, String string6) {
        this.appName = string2;
        this.packageName = string3;
        this.versionName = string4;
        this.versionToDowngrade = string5;
        this.iconPath = string6;
        this.rollBackAction = RollBackItem.Action.DOWNGRADING;
    }

    static /* synthetic */ String access$202(UninstallRetainFragment uninstallRetainFragment, String string2) {
        uninstallRetainFragment.packageName = string2;
        return string2;
    }

    static /* synthetic */ String access$302(UninstallRetainFragment uninstallRetainFragment, String string2) {
        uninstallRetainFragment.appName = string2;
        return string2;
    }

    static /* synthetic */ String access$402(UninstallRetainFragment uninstallRetainFragment, String string2) {
        uninstallRetainFragment.versionName = string2;
        return string2;
    }

    static /* synthetic */ String access$502(UninstallRetainFragment uninstallRetainFragment, String string2) {
        uninstallRetainFragment.iconPath = string2;
        return string2;
    }

    @Override
    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.activity = (ActionBarActivity)activity;
    }

    @Override
    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.setRetainInstance(true);
        Log.d((String)"Aptoide-Uninstaller", (String)"Uninstalling");
        new UninstallTask().execute(new Void[0]);
    }

    @Override
    public void onDetach() {
        super.onDetach();
        this.activity = null;
    }

    private class UninstallTask
    extends AsyncTask<Void, Void, Void> {
        private UninstallTask() {
        }

        private String calcApkMd5(String string2) throws PackageManager.NameNotFoundException {
            return AptoideUtils.Algorithms.md5Calc(new File(((UninstallRetainFragment)UninstallRetainFragment.this).activity.getPackageManager().getPackageInfo((String)string2, (int)0).applicationInfo.sourceDir));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected Void doInBackground(Void ... voidArray) {
            Database database = new Database(Aptoide.getDb());
            try {
                RollBackItem rollBackItem;
                if (UninstallRetainFragment.this.id > 0L) {
                    Cursor cursor = database.getApkInfo(UninstallRetainFragment.this.id);
                    UninstallRetainFragment.access$202(UninstallRetainFragment.this, cursor.getString(cursor.getColumnIndex("package_name")));
                    UninstallRetainFragment.access$302(UninstallRetainFragment.this, cursor.getString(cursor.getColumnIndex("name")));
                    UninstallRetainFragment.access$402(UninstallRetainFragment.this, cursor.getString(cursor.getColumnIndex("version_name")));
                    String string2 = cursor.getString(cursor.getColumnIndex("icon"));
                    String string3 = cursor.getString(cursor.getColumnIndex("iconpath"));
                    UninstallRetainFragment.access$502(UninstallRetainFragment.this, string3 + string2);
                }
                switch (UninstallRetainFragment.this.rollBackAction) {
                    default: {
                        String string4 = database.getUnistallingActionMd5(UninstallRetainFragment.this.packageName);
                        if (database.getUnistallingActionMd5(UninstallRetainFragment.this.packageName) == null) {
                            string4 = this.calcApkMd5(UninstallRetainFragment.this.packageName);
                        }
                        rollBackItem = new RollBackItem(UninstallRetainFragment.this.appName, UninstallRetainFragment.this.packageName, UninstallRetainFragment.this.versionName, null, UninstallRetainFragment.this.iconPath, null, string4, RollBackItem.Action.UNINSTALLING);
                        break;
                    }
                    case DOWNGRADING: {
                        String string5 = this.calcApkMd5(UninstallRetainFragment.this.packageName);
                        rollBackItem = new RollBackItem(UninstallRetainFragment.this.appName, UninstallRetainFragment.this.packageName, UninstallRetainFragment.this.versionToDowngrade, UninstallRetainFragment.this.versionName, UninstallRetainFragment.this.iconPath, null, string5, null);
                        break;
                    }
                }
                database.insertRollbackAction(rollBackItem);
                return null;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                nameNotFoundException.printStackTrace();
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         */
        protected void onPostExecute(Void void_) {
            DialogFragment dialogFragment;
            super.onPostExecute((Object)void_);
            if (UninstallRetainFragment.this.activity != null) {
                if (UninstallRetainFragment.this.rollBackAction == RollBackItem.Action.DOWNGRADING) {
                    UninstallHelper.uninstall(UninstallRetainFragment.this.activity, UninstallRetainFragment.this.packageName, true);
                } else {
                    UninstallHelper.uninstall(UninstallRetainFragment.this.activity, UninstallRetainFragment.this.packageName, false);
                }
            }
            if ((dialogFragment = (DialogFragment)UninstallRetainFragment.this.getFragmentManager().findFragmentByTag("pleaseWaitDialog")) != null) {
                dialogFragment.dismissAllowingStateLoss();
            }
            UninstallRetainFragment.this.getFragmentManager().beginTransaction().remove(UninstallRetainFragment.this).commit();
        }

        protected void onPreExecute() {
            super.onPreExecute();
            AptoideDialog.pleaseWaitDialog().show(UninstallRetainFragment.this.getFragmentManager(), "pleaseWaitDialog");
        }
    }
}

