/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.database.Cursor;
import android.os.Bundle;
import android.os.IBinder;
import android.preference.PreferenceManager;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentBreadCrumbs;
import android.support.v7.app.ActionBarActivity;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import cm.aptoide.ptdev.Aptoide;
import cm.aptoide.ptdev.EnumStoreTheme;
import cm.aptoide.ptdev.R;
import cm.aptoide.ptdev.database.Database;
import cm.aptoide.ptdev.events.BusProvider;
import cm.aptoide.ptdev.events.RepoErrorEvent;
import cm.aptoide.ptdev.fragments.FragmentStore;
import cm.aptoide.ptdev.fragments.FragmentStoreGridCategories;
import cm.aptoide.ptdev.fragments.FragmentStoreHeader;
import cm.aptoide.ptdev.fragments.FragmentStoreListCategories;
import cm.aptoide.ptdev.fragments.callbacks.RepoCompleteEvent;
import cm.aptoide.ptdev.model.Login;
import cm.aptoide.ptdev.model.Store;
import cm.aptoide.ptdev.services.DownloadService;
import cm.aptoide.ptdev.services.ParserService;
import com.squareup.otto.Subscribe;
import java.util.concurrent.Executors;

public class StoreActivity
extends ActionBarActivity {
    public boolean categories;
    private ServiceConnection conn;
    private ServiceConnection conn2 = new ServiceConnection(){

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            StoreActivity.access$002(StoreActivity.this, ((DownloadService.LocalBinder)iBinder).getService());
        }

        public void onServiceDisconnected(ComponentName componentName) {
        }
    };
    private DownloadService downloadService;
    private boolean isRefreshing;
    private ParserService service;
    private boolean serviceIsBound;
    public Sort sort;
    private EnumStoreTheme storeTheme;
    private long storeid;

    public StoreActivity() {
        this.conn = new ServiceConnection(){

            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                StoreActivity.access$102(StoreActivity.this, ((ParserService.MainServiceBinder)iBinder).getService());
                StoreActivity.access$202(StoreActivity.this, StoreActivity.this.service.repoIsParsing(StoreActivity.this.storeid));
                FragmentStore fragmentStore = (FragmentStore)((Object)StoreActivity.this.getSupportFragmentManager().findFragmentByTag("fragStore"));
                if (StoreActivity.this.isRefreshing && fragmentStore != null) {
                    fragmentStore.setRefreshing(StoreActivity.this.isRefreshing);
                }
                StoreActivity.access$402(StoreActivity.this, true);
            }

            public void onServiceDisconnected(ComponentName componentName) {
                StoreActivity.access$402(StoreActivity.this, false);
            }
        };
    }

    static /* synthetic */ DownloadService access$002(StoreActivity storeActivity, DownloadService downloadService) {
        storeActivity.downloadService = downloadService;
        return downloadService;
    }

    static /* synthetic */ ParserService access$102(StoreActivity storeActivity, ParserService parserService) {
        storeActivity.service = parserService;
        return parserService;
    }

    static /* synthetic */ boolean access$202(StoreActivity storeActivity, boolean bl2) {
        storeActivity.isRefreshing = bl2;
        return bl2;
    }

    static /* synthetic */ boolean access$402(StoreActivity storeActivity, boolean bl2) {
        storeActivity.serviceIsBound = bl2;
        return bl2;
    }

    private void refreshList() {
        if (this.service != null) {
            this.isRefreshing = this.service.repoIsParsing(this.storeid);
            FragmentStore fragmentStore = (FragmentStore)((Object)this.getSupportFragmentManager().findFragmentByTag("fragStore"));
            fragmentStore.onRefresh();
            fragmentStore.setListShown(false);
            fragmentStore.setRefreshing(this.isRefreshing);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setFragment() {
        Fragment fragment = !this.getIntent().getBooleanExtra("list", true) ? new FragmentStoreListCategories() : new FragmentStoreGridCategories();
        FragmentStoreHeader fragmentStoreHeader = new FragmentStoreHeader();
        Log.d((String)"Aptoide-", (String)("StoreActivity id" + this.storeid));
        Bundle bundle = new Bundle();
        bundle.putLong("storeid", this.storeid);
        fragment.setArguments(bundle);
        fragmentStoreHeader.setArguments(bundle);
        this.getSupportFragmentManager().beginTransaction().add(R.id.content_layout, fragment, "fragStore").commit();
        if (this.storeid > 0L) {
            this.getSupportFragmentManager().beginTransaction().add(R.id.store_header_layout, fragmentStoreHeader, "fragStoreHeader").commit();
            return;
        }
        this.categories = true;
    }

    private void setSort(MenuItem menuItem) {
        this.supportInvalidateOptionsMenu();
        this.refreshList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SortObject getSort() {
        boolean bl2;
        Sort sort = this.sort;
        if (!this.categories) {
            bl2 = true;
            return new SortObject(sort, bl2);
        }
        bl2 = false;
        return new SortObject(sort, bl2);
    }

    public EnumStoreTheme getStoreTheme() {
        return this.storeTheme;
    }

    public void installApp(long l2) {
        this.downloadService.startDownloadFromAppId(l2);
    }

    public boolean isRefreshing() {
        return this.isRefreshing;
    }

    @Override
    protected void onCreate(Bundle bundle) {
        Aptoide.getThemePicker().setAptoideTheme((Context)this);
        super.onCreate(bundle);
        Intent intent = new Intent((Context)this, ParserService.class);
        this.setContentView(R.layout.page_store_list);
        this.sort = Sort.values()[PreferenceManager.getDefaultSharedPreferences((Context)this).getInt("order_list", 0)];
        this.storeid = this.getIntent().getLongExtra("storeid", 0L);
        this.categories = PreferenceManager.getDefaultSharedPreferences((Context)this).getBoolean("orderByCategory", true);
        FragmentBreadCrumbs fragmentBreadCrumbs = (FragmentBreadCrumbs)this.findViewById(R.id.breadcrumbs);
        fragmentBreadCrumbs.setActivity(this);
        fragmentBreadCrumbs.setTitle("Home", null);
        if (bundle == null) {
            this.setFragment();
        }
        this.getSupportActionBar().setHomeButtonEnabled(true);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.bindService(intent, this.conn, 1);
        this.bindService(new Intent((Context)this, DownloadService.class), this.conn2, 1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onCreateOptionsMenu(Menu menu2) {
        boolean bl2 = true;
        this.getMenuInflater().inflate(R.menu.menu_categories, menu2);
        switch (4.$SwitchMap$cm$aptoide$ptdev$StoreActivity$Sort[this.sort.ordinal()]) {
            case 1: {
                menu2.findItem(R.id.name).setChecked(bl2);
                break;
            }
            case 2: {
                menu2.findItem(R.id.download).setChecked(bl2);
                break;
            }
            case 3: {
                menu2.findItem(R.id.date).setChecked(bl2);
                break;
            }
            case 4: {
                menu2.findItem(R.id.price).setChecked(bl2);
                break;
            }
            case 5: {
                menu2.findItem(R.id.rating).setChecked(bl2);
            }
        }
        if (!this.categories) {
            menu2.findItem(R.id.show_all).setChecked(bl2);
        }
        MenuItem menuItem = menu2.findItem(R.id.show_all);
        if (PreferenceManager.getDefaultSharedPreferences((Context)Aptoide.getContext()).getBoolean("mergeStores", false)) {
            bl2 = false;
        }
        menuItem.setVisible(bl2);
        return super.onCreateOptionsMenu(menu2);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.serviceIsBound) {
            this.unbindService(this.conn);
        }
        if (this.downloadService != null) {
            this.unbindService(this.conn2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onOptionsItemSelected(MenuItem menuItem) {
        int n2 = menuItem.getItemId();
        if (n2 == 16908332) {
            this.finish();
        } else if (n2 == R.id.home) {
            this.finish();
        } else if (n2 == R.id.refresh_store) {
            this.refreshList();
        } else if (n2 == R.id.name) {
            this.sort = Sort.NAME;
            this.setSort(menuItem);
        } else if (n2 == R.id.date) {
            this.sort = Sort.DATE;
            this.setSort(menuItem);
        } else if (n2 == R.id.download) {
            this.sort = Sort.DOWNLOADS;
            this.setSort(menuItem);
        } else if (n2 == R.id.rating) {
            this.sort = Sort.RATING;
            this.setSort(menuItem);
        } else if (n2 == R.id.price) {
            this.sort = Sort.PRICE;
            this.setSort(menuItem);
        } else if (n2 == R.id.show_all) {
            boolean bl2 = !this.categories;
            this.categories = bl2;
            this.getSupportFragmentManager().popBackStackImmediate(null, 1);
            this.setSort(menuItem);
        }
        PreferenceManager.getDefaultSharedPreferences((Context)this).edit().putBoolean("orderByCategory", this.categories).putInt("order_list", this.sort.ordinal()).commit();
        return true;
    }

    public void onRefreshStarted() {
        if (!this.isRefreshing) {
            Executors.newSingleThreadExecutor().submit(new Runnable(){

                @Override
                public void run() {
                    Database database = new Database(Aptoide.getDb());
                    Store store = new Store();
                    Cursor cursor = database.getStore(StoreActivity.this.storeid);
                    if (cursor.moveToFirst()) {
                        store.setBaseUrl(cursor.getString(cursor.getColumnIndex("url")));
                        store.setTopTimestamp(cursor.getLong(cursor.getColumnIndex("top_timestamp")));
                        store.setLatestTimestamp(cursor.getLong(cursor.getColumnIndex("latest_timestamp")));
                        store.setDelta(cursor.getString(cursor.getColumnIndex("hash")));
                        store.setId(cursor.getLong(cursor.getColumnIndex("id_repo")));
                        if (cursor.getString(cursor.getColumnIndex("username")) != null) {
                            Login login = new Login();
                            login.setUsername(cursor.getString(cursor.getColumnIndex("username")));
                            login.setPassword(cursor.getString(cursor.getColumnIndex("password")));
                            store.setLogin(login);
                        }
                    }
                    cursor.close();
                    StoreActivity.this.service.startParse(database, store, false);
                }
            });
        }
    }

    @Override
    protected void onStart() {
        super.onStart();
        BusProvider.getInstance().register(this);
    }

    @Override
    protected void onStop() {
        super.onStop();
        BusProvider.getInstance().unregister(this);
    }

    @Subscribe
    public void onStoreCompleted(RepoCompleteEvent repoCompleteEvent) {
        if (repoCompleteEvent.getRepoId() == this.storeid) {
            this.refreshList();
        }
    }

    @Subscribe
    public void onStoreError(RepoErrorEvent repoErrorEvent) {
        if (repoErrorEvent.getRepoId() == this.storeid) {
            ((FragmentStore)((Object)this.getSupportFragmentManager().findFragmentByTag("fragStoreHeader"))).onError();
            FragmentStore fragmentStore = (FragmentStore)((Object)this.getSupportFragmentManager().findFragmentByTag("fragStore"));
            fragmentStore.onError();
            fragmentStore.onRefresh();
            fragmentStore.setRefreshing(this.service.repoIsParsing(this.storeid));
        }
    }

    public static final class Sort
    extends Enum<Sort> {
        private static final /* synthetic */ Sort[] $VALUES;
        public static final /* enum */ Sort DATE;
        public static final /* enum */ Sort DOWNLOADS;
        public static final /* enum */ Sort NAME;
        public static final /* enum */ Sort PRICE;
        public static final /* enum */ Sort RATING;

        static {
            NAME = new Sort();
            DOWNLOADS = new Sort();
            DATE = new Sort();
            PRICE = new Sort();
            RATING = new Sort();
            Sort[] sortArray = new Sort[]{NAME, DOWNLOADS, DATE, PRICE, RATING};
            $VALUES = sortArray;
        }

        public static Sort valueOf(String string2) {
            return Enum.valueOf(Sort.class, string2);
        }

        public static Sort[] values() {
            return (Sort[])$VALUES.clone();
        }
    }

    public static class SortObject {
        boolean noCategories;
        Sort sort;

        public SortObject(Sort sort, boolean bl2) {
            this.sort = sort;
            this.noCategories = bl2;
        }

        public Sort getSort() {
            return this.sort;
        }

        public boolean isNoCategories() {
            return this.noCategories;
        }
    }
}

