/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev;

import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v7.app.ActionBarActivity;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.widget.EditText;
import android.widget.Toast;
import cm.aptoide.ptdev.Aptoide;
import cm.aptoide.ptdev.R;
import cm.aptoide.ptdev.dialogs.AptoideDialog;
import cm.aptoide.ptdev.services.HttpClientSpiceService;
import cm.aptoide.ptdev.webservices.CreateUserRequest;
import cm.aptoide.ptdev.webservices.json.CreateUserJson;
import com.octo.android.robospice.SpiceManager;
import com.octo.android.robospice.persistence.exception.SpiceException;
import com.octo.android.robospice.request.listener.RequestListener;

public class SignUpActivity
extends ActionBarActivity {
    private String TAG = "SignUp";
    private EditText emailBox;
    private String mAccountType;
    private EditText passBox;
    private boolean showPassword = true;
    private SpiceManager spiceManager = new SpiceManager(HttpClientSpiceService.class);

    static /* synthetic */ boolean access$202(SignUpActivity signUpActivity, boolean bl2) {
        signUpActivity.showPassword = bl2;
        return bl2;
    }

    private void createAccount() {
        CreateUserRequest createUserRequest = new CreateUserRequest();
        createUserRequest.setEmail(this.emailBox.getText().toString());
        createUserRequest.setPass(this.passBox.getText().toString());
        AptoideDialog.pleaseWaitDialog().show(this.getSupportFragmentManager(), "pleaseWaitDialog");
        this.spiceManager.execute(createUserRequest, new RequestListener<CreateUserJson>(){

            @Override
            public void onRequestFailure(SpiceException spiceException) {
                DialogFragment dialogFragment = (DialogFragment)SignUpActivity.this.getSupportFragmentManager().findFragmentByTag("pleaseWaitDialog");
                if (dialogFragment != null) {
                    dialogFragment.dismiss();
                }
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onRequestSuccess(CreateUserJson createUserJson) {
                DialogFragment dialogFragment = (DialogFragment)SignUpActivity.this.getSupportFragmentManager().findFragmentByTag("pleaseWaitDialog");
                if (dialogFragment != null) {
                    dialogFragment.dismiss();
                }
                if ("OK".equals(createUserJson.getStatus())) {
                    Intent intent = new Intent();
                    intent.putExtra("password", SignUpActivity.this.passBox.getText().toString());
                    intent.putExtra("username", SignUpActivity.this.emailBox.getText().toString());
                    SignUpActivity.this.setResult(-1, intent);
                    SignUpActivity.this.finish();
                    return;
                } else {
                    for (String string2 : createUserJson.getErrors()) {
                        Toast.makeText((Context)SignUpActivity.this, (CharSequence)string2, (int)0).show();
                    }
                }
            }
        });
    }

    @Override
    protected void onCreate(Bundle bundle) {
        Aptoide.getThemePicker().setAptoideTheme((Context)this);
        super.onCreate(bundle);
        this.setContentView(R.layout.form_create_user);
        this.findViewById(R.id.submitCreateUser).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                SignUpActivity.this.createAccount();
            }
        });
        this.getSupportActionBar().setHomeButtonEnabled(true);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getSupportActionBar().setDisplayShowTitleEnabled(true);
        this.getSupportActionBar().setTitle(this.getString(R.string.register));
        this.emailBox = (EditText)this.findViewById(R.id.email_box);
        this.passBox = (EditText)this.findViewById(R.id.password_box);
        this.passBox.setTransformationMethod((TransformationMethod)new PasswordTransformationMethod());
        final Drawable drawable2 = this.getResources().getDrawable(R.drawable.ic_show_password);
        final Drawable drawable3 = this.getResources().getDrawable(R.drawable.ic_hide_password);
        this.passBox.setCompoundDrawablesWithIntrinsicBounds(null, null, drawable2, null);
        this.passBox.setOnTouchListener(new View.OnTouchListener(){

            /*
             * Enabled aggressive block sorting
             */
            public boolean onTouch(View view, MotionEvent motionEvent) {
                if (SignUpActivity.this.passBox.getCompoundDrawables()[2] == null || motionEvent.getAction() == 1 || !(motionEvent.getX() > (float)(SignUpActivity.this.passBox.getWidth() - SignUpActivity.this.passBox.getPaddingRight() - drawable2.getIntrinsicWidth()))) {
                    return false;
                }
                if (SignUpActivity.this.showPassword) {
                    SignUpActivity.access$202(SignUpActivity.this, false);
                    SignUpActivity.this.passBox.setTransformationMethod(null);
                    SignUpActivity.this.passBox.setCompoundDrawablesWithIntrinsicBounds(null, null, drawable3, null);
                    return false;
                }
                SignUpActivity.access$202(SignUpActivity.this, true);
                SignUpActivity.this.passBox.setTransformationMethod((TransformationMethod)new PasswordTransformationMethod());
                SignUpActivity.this.passBox.setCompoundDrawablesWithIntrinsicBounds(null, null, drawable2, null);
                return false;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onOptionsItemSelected(MenuItem menuItem) {
        int n2 = menuItem.getItemId();
        if (n2 == 16908332) {
            this.setResult(0);
            this.finish();
            return super.onOptionsItemSelected(menuItem);
        }
        if (n2 != R.id.home) return super.onOptionsItemSelected(menuItem);
        this.setResult(0);
        this.finish();
        return super.onOptionsItemSelected(menuItem);
    }

    @Override
    protected void onStart() {
        super.onStart();
        this.spiceManager.start((Context)this);
    }

    @Override
    protected void onStop() {
        super.onStop();
        this.spiceManager.shouldStop();
    }
}

