/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev;

import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.os.Bundle;
import android.preference.EditTextPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceManager;
import android.view.MenuItem;
import android.widget.Toast;
import cm.aptoide.ptdev.Aptoide;
import cm.aptoide.ptdev.R;
import cm.aptoide.ptdev.preferences.ManagerPreferences;
import cm.aptoide.ptdev.utils.AptoideUtils;
import java.io.File;
import java.text.DecimalFormat;

public class Settings
extends PreferenceActivity
implements SharedPreferences.OnSharedPreferenceChangeListener {
    String aptoide_path = Aptoide.getConfiguration().getPathCache();
    String icon_path = this.aptoide_path + "icons/";
    Context mctx;
    ManagerPreferences preferences;
    private boolean unlocked = false;

    static /* synthetic */ boolean access$002(Settings settings, boolean bl2) {
        settings.unlocked = bl2;
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean deleteDirectory(File file) {
        File[] fileArray;
        if (file.exists() && (fileArray = file.listFiles()) != null) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    Settings.deleteDirectory(file2);
                    continue;
                }
                file2.delete();
            }
        }
        return true;
    }

    private void redrawSizes(Double[] doubleArray) {
        Preference preference = this.findPreference("clearapk");
        StringBuilder stringBuilder = new StringBuilder().append(this.getString(R.string.clearcontent_sum)).append(" (");
        int n2 = R.string.cache_using_X_mb;
        Object[] objectArray = new Object[]{new DecimalFormat("#.##").format(doubleArray[0])};
        preference.setSummary((CharSequence)stringBuilder.append(this.getString(n2, objectArray)).append(")").toString());
        Preference preference2 = this.findPreference("clearcache");
        StringBuilder stringBuilder2 = new StringBuilder().append(this.getString(R.string.clearcache_sum)).append(" (");
        int n3 = R.string.cache_using_X_mb;
        Object[] objectArray2 = new Object[]{new DecimalFormat("#.##").format(doubleArray[1])};
        preference2.setSummary((CharSequence)stringBuilder2.append(this.getString(n3, objectArray2)).append(")").toString());
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.addPreferencesFromResource(R.xml.preferences);
        this.mctx = this;
        GetDirSize getDirSize = new GetDirSize();
        Object[] objectArray = new File[]{new File(this.aptoide_path), new File(this.icon_path)};
        getDirSize.execute(objectArray);
        this.preferences = new ManagerPreferences(this.mctx);
        this.findPreference("clearcache").setOnPreferenceClickListener(new Preference.OnPreferenceClickListener(){

            public boolean onPreferenceClick(Preference preference) {
                if (Settings.this.unlocked) {
                    DeleteDir deleteDir = new DeleteDir();
                    Object[] objectArray = new File[]{new File(Settings.this.icon_path)};
                    deleteDir.execute(objectArray);
                }
                return false;
            }
        });
        this.findPreference("clearapk").setOnPreferenceClickListener(new Preference.OnPreferenceClickListener(){

            public boolean onPreferenceClick(Preference preference) {
                if (Settings.this.unlocked) {
                    DeleteDir deleteDir = new DeleteDir();
                    Object[] objectArray = new File[]{new File(Settings.this.aptoide_path)};
                    deleteDir.execute(objectArray);
                }
                return false;
            }
        });
        PreferenceManager.getDefaultSharedPreferences((Context)this).registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
        Preference preference = this.findPreference("hwspecs");
        this.findPreference("theme").setOnPreferenceChangeListener(new Preference.OnPreferenceChangeListener(){

            public boolean onPreferenceChange(Preference preference, Object object) {
                Toast.makeText((Context)Settings.this, (CharSequence)Settings.this.getString(R.string.restart_aptoide), (int)1).show();
                return true;
            }
        });
        preference.setOnPreferenceClickListener(new Preference.OnPreferenceClickListener(){

            public boolean onPreferenceClick(Preference preference) {
                AlertDialog.Builder builder = new AlertDialog.Builder(Settings.this.mctx);
                builder.setTitle((CharSequence)Settings.this.getString(R.string.setting_hwspecstitle));
                builder.setIcon(17301569).setMessage((CharSequence)(Settings.this.getString(R.string.setting_sdk_version) + ": " + AptoideUtils.HWSpecifications.getSdkVer() + "\n" + Settings.this.getString(R.string.setting_screen_size) + ": " + AptoideUtils.HWSpecifications.getScreenSize(Settings.this.mctx) + "\n" + Settings.this.getString(R.string.setting_esgl_version) + ": " + AptoideUtils.HWSpecifications.getGlEsVer(Settings.this.mctx) + "\n" + Settings.this.getString(R.string.screenCode) + ": " + AptoideUtils.HWSpecifications.getNumericScreenSize(Settings.this.mctx) + "/" + AptoideUtils.HWSpecifications.getDensityDpi(Settings.this.mctx) + "\n" + Settings.this.getString(R.string.cpuAbi) + ": " + AptoideUtils.HWSpecifications.getCpuAbi() + " " + AptoideUtils.HWSpecifications.getCpuAbi2())).setCancelable(false).setNeutralButton((CharSequence)Settings.this.getString(17039370), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int n2) {
                    }
                });
                builder.create().show();
                return true;
            }
        });
        EditTextPreference editTextPreference = (EditTextPreference)this.findPreference("maxFileCache");
        editTextPreference.getEditText().setInputType(2);
        editTextPreference.setOnPreferenceClickListener(new Preference.OnPreferenceClickListener(){

            public boolean onPreferenceClick(Preference preference) {
                ((EditTextPreference)preference).getEditText().setText((CharSequence)PreferenceManager.getDefaultSharedPreferences((Context)Settings.this.mctx).getString("maxFileCache", "200"));
                return false;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onOptionsItemSelected(MenuItem menuItem) {
        int n2 = menuItem.getItemId();
        if (n2 == 16908332) {
            this.finish();
            return super.onOptionsItemSelected(menuItem);
        }
        if (n2 != R.id.home) return super.onOptionsItemSelected(menuItem);
        this.finish();
        return super.onOptionsItemSelected(menuItem);
    }

    public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String string2) {
    }

    public class DeleteDir
    extends AsyncTask<File, Void, Void> {
        ProgressDialog pd;

        protected Void doInBackground(File ... fileArray) {
            Settings.deleteDirectory(fileArray[0]);
            return null;
        }

        protected void onPostExecute(Void void_) {
            super.onPostExecute((Object)void_);
            this.pd.dismiss();
            Toast.makeText((Context)Settings.this.mctx, (CharSequence)Settings.this.mctx.getString(R.string.clear_cache_sucess), (int)0).show();
            GetDirSize getDirSize = new GetDirSize();
            Object[] objectArray = new File[]{new File(Settings.this.aptoide_path), new File(Settings.this.icon_path)};
            getDirSize.execute(objectArray);
        }

        protected void onPreExecute() {
            super.onPreExecute();
            this.pd = new ProgressDialog(Settings.this.mctx);
            this.pd.setMessage((CharSequence)Settings.this.getString(R.string.please_wait));
            this.pd.show();
        }
    }

    public class GetDirSize
    extends AsyncTask<File, Void, Double[]> {
        protected Double[] doInBackground(File ... fileArray) {
            Double[] doubleArray = new Double[2];
            for (int i2 = 0; i2 != doubleArray.length; ++i2) {
                doubleArray[i2] = this.getDirSize(fileArray[i2]) / 1024.0 / 1024.0;
            }
            return doubleArray;
        }

        double getDirSize(File file) {
            double d2 = 0.0;
            if (file.isFile()) {
                return file.length();
            }
            File[] fileArray = file.listFiles();
            int n2 = fileArray.length;
            int n3 = 0;
            while (true) {
                block7: {
                    block8: {
                        if (n3 >= n2) break block8;
                        try {
                            File file2 = fileArray[n3];
                            if (file2.isFile()) {
                                d2 += (double)file2.length();
                            } else {
                                double d3 = this.getDirSize(file2);
                                d2 += d3;
                            }
                            break block7;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    return d2;
                }
                ++n3;
            }
        }

        protected void onPostExecute(Double[] doubleArray) {
            super.onPostExecute((Object)doubleArray);
            Settings.this.redrawSizes(doubleArray);
            Settings.access$002(Settings.this, true);
        }
    }
}

