/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev;

import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.provider.SearchRecentSuggestions;
import android.support.v4.app.ListFragment;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.support.v4.widget.CursorAdapter;
import android.support.v7.app.ActionBarActivity;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import cm.aptoide.ptdev.AppViewActivity;
import cm.aptoide.ptdev.Aptoide;
import cm.aptoide.ptdev.DownloadServiceConnected;
import cm.aptoide.ptdev.R;
import cm.aptoide.ptdev.StoreActivity;
import cm.aptoide.ptdev.adapters.SearchAdapter;
import cm.aptoide.ptdev.database.Database;
import cm.aptoide.ptdev.downloadmanager.Utils;
import cm.aptoide.ptdev.events.BusProvider;
import cm.aptoide.ptdev.services.DownloadService;
import cm.aptoide.ptdev.utils.SimpleCursorLoader;
import com.commonsware.cwac.merge.MergeAdapter;

public class SearchManager
extends ActionBarActivity {
    private CursorAdapter adapter;
    private ServiceConnection conn2 = new ServiceConnection(){

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            SearchManager.access$302(SearchManager.this, ((DownloadService.LocalBinder)iBinder).getService());
            BusProvider.getInstance().post(new DownloadServiceConnected());
        }

        public void onServiceDisconnected(ComponentName componentName) {
        }
    };
    private DownloadService downloadService;

    static /* synthetic */ DownloadService access$302(SearchManager searchManager, DownloadService downloadService) {
        searchManager.downloadService = downloadService;
        return downloadService;
    }

    public void installApp(long l2) {
        this.downloadService.startDownloadFromAppId(l2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onCreate(Bundle bundle) {
        Aptoide.getThemePicker().setAptoideTheme((Context)this);
        super.onCreate(bundle);
        this.adapter = new SearchAdapter((Context)this);
        this.setContentView(R.layout.page_search);
        Bundle bundle2 = new Bundle();
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getSupportActionBar().setDisplayShowTitleEnabled(true);
        String string2 = this.getIntent().hasExtra("search") ? this.getIntent().getExtras().getString("search") : this.getIntent().getExtras().getString("query").replaceAll("\\s{2,}|\\W", " ").trim().replaceAll("\\s{2,}", " ");
        new SearchRecentSuggestions((Context)this, "cm.aptoide.pt.SuggestionProvider", 1).saveRecentQuery(string2, null);
        bundle2.putString("query", string2);
        this.getSupportActionBar().setTitle("'" + string2 + "'");
        SearchFragment searchFragment = new SearchFragment();
        searchFragment.setArguments(bundle2);
        this.getSupportFragmentManager().beginTransaction().replace(R.id.fragContainer, searchFragment).commit();
        this.bindService(new Intent((Context)this, DownloadService.class), this.conn2, 1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onOptionsItemSelected(MenuItem menuItem) {
        int n2 = menuItem.getItemId();
        if (n2 == 16908332) {
            this.finish();
            return super.onOptionsItemSelected(menuItem);
        }
        if (n2 != 16908332) return super.onOptionsItemSelected(menuItem);
        this.finish();
        return super.onOptionsItemSelected(menuItem);
    }

    public static class SearchFragment
    extends ListFragment
    implements LoaderManager.LoaderCallbacks<Cursor> {
        private MergeAdapter adapter;
        private CursorAdapter cursorAdapter;
        TextView more;
        private String query;
        private StoreActivity.Sort sort = StoreActivity.Sort.DOWNLOADS;
        private View v;

        private View.OnClickListener getSearchListener() {
            return new View.OnClickListener(){

                public void onClick(View view) {
                    try {
                        String string2 = Aptoide.getConfiguration().getUriSearch() + SearchFragment.this.query + "&q=" + Utils.filters((Context)SearchFragment.this.getActivity());
                        Log.d((String)"TAG", (String)("Searching for:" + string2));
                        Intent intent = new Intent("android.intent.action.VIEW");
                        intent.setData(Uri.parse((String)string2.replaceAll(" ", "%20")));
                        SearchFragment.this.startActivity(intent);
                        return;
                    }
                    catch (ActivityNotFoundException activityNotFoundException) {
                        Toast.makeText((Context)Aptoide.getContext(), (CharSequence)SearchFragment.this.getString(R.string.error_occured), (int)1).show();
                        return;
                    }
                }
            };
        }

        @Override
        public void onCreate(Bundle bundle) {
            super.onCreate(bundle);
            this.adapter = new MergeAdapter();
            this.v = LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.separator_search, null);
            this.adapter.addView(this.v);
            this.cursorAdapter = new SearchAdapter((Context)this.getActivity());
            this.adapter.addAdapter((ListAdapter)this.cursorAdapter);
            this.query = this.getArguments().getString("query");
            this.setHasOptionsMenu(true);
        }

        @Override
        public Loader<Cursor> onCreateLoader(int n2, final Bundle bundle) {
            return new SimpleCursorLoader((Context)this.getActivity()){

                @Override
                public Cursor loadInBackground() {
                    return new Database(Aptoide.getDb()).getSearchResults(bundle.getString("query"), SearchFragment.this.sort);
                }
            };
        }

        @Override
        public void onCreateOptionsMenu(Menu menu2, MenuInflater menuInflater) {
            super.onCreateOptionsMenu(menu2, menuInflater);
            menuInflater.inflate(R.menu.menu_categories, menu2);
            menu2.findItem(R.id.show_all).setVisible(false);
            menu2.findItem(R.id.download).setChecked(true);
        }

        @Override
        public void onDetach() {
            super.onDetach();
            this.getLoaderManager().destroyLoader(60);
        }

        @Override
        public void onListItemClick(ListView listView, View view, int n2, long l2) {
            super.onListItemClick(listView, view, n2, l2);
            Intent intent = new Intent((Context)this.getActivity(), AppViewActivity.class);
            intent.putExtra("id", l2);
            this.startActivity(intent);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onLoadFinished(Loader<Cursor> loader, final Cursor cursor) {
            this.cursorAdapter.swapCursor(cursor);
            TextView textView = (TextView)this.v.findViewById(R.id.results);
            this.more = (TextView)this.v.findViewById(R.id.more);
            if (cursor.getCount() > 0) {
                int n2 = R.string.found_results;
                Object[] objectArray = new Object[]{cursor.getCount()};
                textView.setText((CharSequence)this.getString(n2, objectArray));
            } else {
                int n3 = R.string.no_search_result;
                Object[] objectArray = new Object[]{this.query};
                textView.setText((CharSequence)this.getString(n3, objectArray));
            }
            this.setListAdapter((ListAdapter)this.adapter);
            this.setListShown(true);
            int n4 = R.string.no_search_result;
            Object[] objectArray = new Object[]{this.query};
            this.setEmptyText(this.getString(n4, objectArray));
            new Handler().post(new Runnable(){

                @Override
                public void run() {
                    if (SearchFragment.this.getListView().getLastVisiblePosition() - SearchFragment.this.getListView().getFirstVisiblePosition() < cursor.getCount()) {
                        SearchFragment.this.more.setVisibility(0);
                        SearchFragment.this.more.setOnClickListener(SearchFragment.this.getSearchListener());
                        return;
                    }
                    SearchFragment.this.more.setVisibility(8);
                }
            });
        }

        @Override
        public void onLoaderReset(Loader<Cursor> loader) {
            this.cursorAdapter.swapCursor(null);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onOptionsItemSelected(MenuItem menuItem) {
            int n2 = menuItem.getItemId();
            if (n2 == R.id.name) {
                this.setListShown(false);
                this.sort = StoreActivity.Sort.NAME;
            } else if (n2 == R.id.date) {
                this.setListShown(false);
                this.sort = StoreActivity.Sort.DATE;
            } else if (n2 == R.id.download) {
                this.setListShown(false);
                this.sort = StoreActivity.Sort.DOWNLOADS;
            } else if (n2 == R.id.rating) {
                this.setListShown(false);
                this.sort = StoreActivity.Sort.RATING;
            } else if (n2 == R.id.price) {
                this.setListShown(false);
                this.sort = StoreActivity.Sort.PRICE;
            }
            this.getLoaderManager().restartLoader(60, this.getArguments(), this);
            menuItem.setChecked(true);
            return super.onOptionsItemSelected(menuItem);
        }

        @Override
        public void onViewCreated(View view, Bundle bundle) {
            super.onViewCreated(view, bundle);
            this.getListView().setDivider(null);
            this.getListView().setCacheColorHint(this.getResources().getColor(17170445));
            View view2 = LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.footer_search, null);
            ((Button)view2.findViewById(R.id.search)).setOnClickListener(this.getSearchListener());
            this.getListView().addFooterView(view2);
            this.getLoaderManager().initLoader(60, this.getArguments(), this);
        }
    }
}

