/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.ServiceConnection;
import android.database.Cursor;
import android.os.Bundle;
import android.os.IBinder;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.support.v4.widget.CursorAdapter;
import android.support.v7.app.ActionBarActivity;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import cm.aptoide.ptdev.Aptoide;
import cm.aptoide.ptdev.R;
import cm.aptoide.ptdev.database.Database;
import cm.aptoide.ptdev.dialogs.AptoideDialog;
import cm.aptoide.ptdev.model.Download;
import cm.aptoide.ptdev.services.DownloadService;
import cm.aptoide.ptdev.services.HttpClientSpiceService;
import cm.aptoide.ptdev.utils.SimpleCursorLoader;
import cm.aptoide.ptdev.webservices.GetApkInfoRequestFromMd5;
import cm.aptoide.ptdev.webservices.json.GetApkInfoJson;
import com.nostra13.universalimageloader.core.ImageLoader;
import com.octo.android.robospice.SpiceManager;
import com.octo.android.robospice.persistence.exception.SpiceException;
import com.octo.android.robospice.request.listener.RequestListener;
import java.util.HashMap;
import java.util.Iterator;

public class ScheduledDownloadsActivity
extends ActionBarActivity
implements LoaderManager.LoaderCallbacks<Cursor> {
    private CursorAdapter adapter;
    private ServiceConnection conn;
    private Database db;
    private DownloadService downloadService;
    private int i;
    private ListView lv;
    private HashMap<Long, ScheduledDownload> scheduledDownloadsHashMap = new HashMap();
    private SpiceManager spiceManager = new SpiceManager(HttpClientSpiceService.class);

    public ScheduledDownloadsActivity() {
        this.conn = new ServiceConnection(){

            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                ScheduledDownloadsActivity.access$002(ScheduledDownloadsActivity.this, ((DownloadService.LocalBinder)iBinder).getService());
            }

            public void onServiceDisconnected(ComponentName componentName) {
            }
        };
    }

    static /* synthetic */ DownloadService access$002(ScheduledDownloadsActivity scheduledDownloadsActivity, DownloadService downloadService) {
        scheduledDownloadsActivity.downloadService = downloadService;
        return downloadService;
    }

    static /* synthetic */ int access$208(ScheduledDownloadsActivity scheduledDownloadsActivity) {
        int n2 = scheduledDownloadsActivity.i;
        scheduledDownloadsActivity.i = n2 + 1;
        return n2;
    }

    private boolean isAllChecked() {
        if (this.scheduledDownloadsHashMap.isEmpty()) {
            return false;
        }
        for (Long l2 : this.scheduledDownloadsHashMap.keySet()) {
            if (!this.scheduledDownloadsHashMap.get(l2).checked) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void onCreate(Bundle bundle) {
        Aptoide.getThemePicker().setAptoideTheme((Context)this);
        super.onCreate(bundle);
        this.setContentView(R.layout.page_sch_downloads);
        this.getSupportActionBar().setHomeButtonEnabled(true);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getSupportActionBar().setDisplayShowTitleEnabled(true);
        this.getSupportActionBar().setTitle(this.getString(R.string.setting_schdwntitle));
        this.lv = (ListView)this.findViewById(16908298);
        this.lv.setDivider(null);
        this.db = new Database(Aptoide.getDb());
        this.bindService(new Intent((Context)this, DownloadService.class), this.conn, 1);
        this.adapter = new CursorAdapter((Context)this, null, 2){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void bindView(View view, Context context, Cursor cursor) {
                ImageView imageView;
                CheckBox checkBox;
                TextView textView;
                TextView textView2;
                ScheduledDownload scheduledDownload = (ScheduledDownload)ScheduledDownloadsActivity.this.scheduledDownloadsHashMap.get(cursor.getLong(cursor.getColumnIndex("_id")));
                if (view.getTag() == null) {
                    textView2 = (TextView)view.findViewById(R.id.name);
                    textView = (TextView)view.findViewById(R.id.appversion);
                    checkBox = (CheckBox)view.findViewById(R.id.schDwnChkBox);
                    imageView = (ImageView)view.findViewById(R.id.appicon);
                    view.setTag((Object)new Holder(textView2, textView, checkBox, imageView));
                    checkBox.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            CheckBox checkBox = (CheckBox)view;
                            ((ScheduledDownload)checkBox.getTag()).setChecked(checkBox.isChecked());
                        }
                    });
                } else {
                    Holder holder = (Holder)view.getTag();
                    checkBox = holder.checkBoxScheduled;
                    textView = holder.textViewVersion;
                    textView2 = holder.textViewName;
                    imageView = holder.imageViewIcon;
                }
                checkBox.setTag((Object)scheduledDownload);
                checkBox.setChecked(scheduledDownload.isChecked());
                textView2.setText((CharSequence)scheduledDownload.getName());
                textView.setText((CharSequence)scheduledDownload.getVername());
                ImageLoader.getInstance().displayImage(scheduledDownload.getIconPath(), imageView);
            }

            @Override
            public View newView(Context context, Cursor cursor, ViewGroup viewGroup) {
                return LayoutInflater.from((Context)context).inflate(R.layout.row_sch_download, null);
            }
        };
        this.getSupportLoaderManager().initLoader(0, null, this);
        this.lv.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int n2, long l2) {
                ScheduledDownload scheduledDownload = (ScheduledDownload)((Holder)view.getTag()).checkBoxScheduled.getTag();
                scheduledDownload.toggleChecked();
                ((Holder)view.getTag()).checkBoxScheduled.setChecked(scheduledDownload.isChecked());
            }
        });
        DialogFragment dialogFragment = new DialogFragment(){

            @Override
            public Dialog onCreateDialog(Bundle bundle) {
                AlertDialog alertDialog = new AlertDialog.Builder((Context)ScheduledDownloadsActivity.this).create();
                alertDialog.setTitle(this.getText(R.string.schDwnBtn));
                alertDialog.setIcon(17301543);
                alertDialog.setCancelable(false);
                alertDialog.setMessage(this.getText(R.string.schDown_install));
                alertDialog.setButton(-1, (CharSequence)this.getString(17039379), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int n2) {
                        AptoideDialog.pleaseWaitDialog().show(ScheduledDownloadsActivity.this.getSupportFragmentManager(), "pleaseWaitDialog");
                        for (Long l2 : ScheduledDownloadsActivity.this.scheduledDownloadsHashMap.keySet()) {
                            final ScheduledDownload scheduledDownload = (ScheduledDownload)ScheduledDownloadsActivity.this.scheduledDownloadsHashMap.get(l2);
                            GetApkInfoRequestFromMd5 getApkInfoRequestFromMd5 = new GetApkInfoRequestFromMd5((Context)ScheduledDownloadsActivity.this);
                            getApkInfoRequestFromMd5.setRepoName(scheduledDownload.getRepoName());
                            getApkInfoRequestFromMd5.setMd5Sum(scheduledDownload.getMd5());
                            ScheduledDownloadsActivity.this.spiceManager.execute(getApkInfoRequestFromMd5, new RequestListener<GetApkInfoJson>(){

                                @Override
                                public void onRequestFailure(SpiceException spiceException) {
                                }

                                /*
                                 * Enabled aggressive block sorting
                                 */
                                @Override
                                public void onRequestSuccess(GetApkInfoJson getApkInfoJson) {
                                    block3: {
                                        block2: {
                                            if (getApkInfoJson == null) break block2;
                                            Download download = new Download();
                                            download.setId(scheduledDownload.getId());
                                            download.setName(scheduledDownload.getName());
                                            download.setVersion(scheduledDownload.getVername());
                                            download.setIcon(scheduledDownload.getIconPath());
                                            download.setPackageName(scheduledDownload.getApkid());
                                            ScheduledDownloadsActivity.this.downloadService.startDownloadFromJson(getApkInfoJson, scheduledDownload.getId(), download);
                                            ScheduledDownloadsActivity.access$208(ScheduledDownloadsActivity.this);
                                            if (ScheduledDownloadsActivity.this.i == ScheduledDownloadsActivity.this.scheduledDownloadsHashMap.size()) break block3;
                                        }
                                        return;
                                    }
                                    ScheduledDownloadsActivity.this.finish();
                                }
                            });
                        }
                    }
                });
                alertDialog.setButton(-2, (CharSequence)this.getString(17039369), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int n2) {
                        ScheduledDownloadsActivity.this.finish();
                    }
                });
                return alertDialog;
            }
        };
        if (this.getIntent().hasExtra("downloadAll")) {
            dialogFragment.show(this.getSupportFragmentManager(), "installAllScheduled");
        }
        ((Button)this.findViewById(R.id.sch_down)).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (ScheduledDownloadsActivity.this.isAllChecked()) {
                    for (Long l2 : ScheduledDownloadsActivity.this.scheduledDownloadsHashMap.keySet()) {
                        if (!((ScheduledDownload)ScheduledDownloadsActivity.this.scheduledDownloadsHashMap.get(l2)).checked) continue;
                        final ScheduledDownload scheduledDownload = (ScheduledDownload)ScheduledDownloadsActivity.this.scheduledDownloadsHashMap.get(l2);
                        GetApkInfoRequestFromMd5 getApkInfoRequestFromMd5 = new GetApkInfoRequestFromMd5((Context)ScheduledDownloadsActivity.this);
                        getApkInfoRequestFromMd5.setRepoName(scheduledDownload.getRepoName());
                        getApkInfoRequestFromMd5.setMd5Sum(scheduledDownload.getMd5());
                        ScheduledDownloadsActivity.this.spiceManager.execute(getApkInfoRequestFromMd5, new RequestListener<GetApkInfoJson>(){

                            @Override
                            public void onRequestFailure(SpiceException spiceException) {
                            }

                            @Override
                            public void onRequestSuccess(GetApkInfoJson getApkInfoJson) {
                                Download download = new Download();
                                download.setId(scheduledDownload.getId());
                                download.setName(scheduledDownload.getName());
                                download.setVersion(scheduledDownload.getVername());
                                download.setIcon(scheduledDownload.getIconPath());
                                download.setPackageName(scheduledDownload.getApkid());
                                ScheduledDownloadsActivity.this.downloadService.startDownloadFromJson(getApkInfoJson, scheduledDownload.getId(), download);
                                Toast.makeText((Context)ScheduledDownloadsActivity.this.getApplicationContext(), (CharSequence)ScheduledDownloadsActivity.this.getApplicationContext().getString(R.string.starting_download), (int)1).show();
                            }
                        });
                    }
                } else {
                    Toast.makeText((Context)ScheduledDownloadsActivity.this, (int)R.string.schDown_nodownloadselect, (int)0).show();
                }
            }
        });
        this.lv.setAdapter((ListAdapter)this.adapter);
    }

    @Override
    public Loader<Cursor> onCreateLoader(int n2, Bundle bundle) {
        return new SimpleCursorLoader((Context)this){

            @Override
            public Cursor loadInBackground() {
                return ScheduledDownloadsActivity.this.db.getScheduledDownloads();
            }
        };
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.menu_scheduled_downloads, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onLoadFinished(Loader<Cursor> loader, Cursor cursor) {
        this.scheduledDownloadsHashMap.clear();
        if (cursor.getCount() == 0) {
            this.findViewById(16908292).setVisibility(0);
        } else {
            this.findViewById(16908292).setVisibility(8);
        }
        cursor.moveToFirst();
        while (true) {
            if (cursor.isAfterLast()) {
                this.adapter.swapCursor(cursor);
                return;
            }
            ScheduledDownload scheduledDownload = new ScheduledDownload(cursor.getLong(cursor.getColumnIndex("_id")), true);
            scheduledDownload.setApkid(cursor.getString(cursor.getColumnIndex("package_name")));
            scheduledDownload.setMd5(cursor.getString(cursor.getColumnIndex("md5")));
            scheduledDownload.setName(cursor.getString(cursor.getColumnIndex("name")));
            scheduledDownload.setVername(cursor.getString(cursor.getColumnIndex("version_name")));
            scheduledDownload.setRepoName(cursor.getString(cursor.getColumnIndex("repo_name")));
            scheduledDownload.setIconPath(cursor.getString(cursor.getColumnIndex("icon")));
            this.scheduledDownloadsHashMap.put(cursor.getLong(cursor.getColumnIndex("_id")), scheduledDownload);
            cursor.moveToNext();
        }
    }

    @Override
    public void onLoaderReset(Loader<Cursor> loader) {
        this.adapter.swapCursor(null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onOptionsItemSelected(MenuItem menuItem) {
        int n2 = menuItem.getItemId();
        if (n2 == 16908332) {
            this.finish();
            return super.onOptionsItemSelected(menuItem);
        }
        if (n2 == R.id.home) {
            this.finish();
            return super.onOptionsItemSelected(menuItem);
        }
        if (n2 == R.id.menu_remove) {
            Log.d((String)"ScheduledDownloadsActivity-onOptionsItemSelected", (String)"remove");
            Iterator<Long> iterator = this.scheduledDownloadsHashMap.keySet().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    this.getSupportLoaderManager().restartLoader(0, null, this);
                    return super.onOptionsItemSelected(menuItem);
                }
                Long l2 = iterator.next();
                if (!this.scheduledDownloadsHashMap.get(l2).checked) continue;
                this.db.deleteScheduledDownload(this.scheduledDownloadsHashMap.get(l2).md5);
            }
        }
        if (n2 != R.id.menu_invert) return super.onOptionsItemSelected(menuItem);
        Iterator<Long> iterator = this.scheduledDownloadsHashMap.keySet().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.adapter.notifyDataSetChanged();
                return super.onOptionsItemSelected(menuItem);
            }
            Long l3 = iterator.next();
            ScheduledDownload scheduledDownload = this.scheduledDownloadsHashMap.get(l3);
            boolean bl2 = !this.scheduledDownloadsHashMap.get(l3).checked;
            ScheduledDownload.access$502(scheduledDownload, bl2);
        }
    }

    @Override
    protected void onStart() {
        super.onStart();
        this.spiceManager.start((Context)this);
    }

    @Override
    protected void onStop() {
        super.onStop();
        this.spiceManager.shouldStop();
    }

    private static class Holder {
        public CheckBox checkBoxScheduled;
        public ImageView imageViewIcon;
        public TextView textViewName;
        public TextView textViewVersion;

        public Holder(TextView textView, TextView textView2, CheckBox checkBox, ImageView imageView) {
            this.checkBoxScheduled = checkBox;
            this.textViewName = textView;
            this.textViewVersion = textView2;
            this.imageViewIcon = imageView;
        }
    }

    private static class ScheduledDownload {
        private String apkid = "";
        private boolean checked = false;
        private String iconPath = "";
        private long id;
        private String md5 = "";
        private String name = "";
        private String repoName;
        private int vercode = 0;
        private String vername = "";

        public ScheduledDownload(long l2, boolean bl2) {
            this.id = l2;
            this.checked = bl2;
        }

        static /* synthetic */ boolean access$502(ScheduledDownload scheduledDownload, boolean bl2) {
            scheduledDownload.checked = bl2;
            return bl2;
        }

        public String getApkid() {
            return this.apkid;
        }

        public String getIconPath() {
            return this.iconPath;
        }

        public long getId() {
            return this.id;
        }

        public String getMd5() {
            return this.md5;
        }

        public String getName() {
            return this.name;
        }

        public String getRepoName() {
            return this.repoName;
        }

        public int getVercode() {
            return this.vercode;
        }

        public String getVername() {
            return this.vername;
        }

        public boolean isChecked() {
            return this.checked;
        }

        public void setApkid(String string2) {
            this.apkid = string2;
        }

        public void setChecked(boolean bl2) {
            this.checked = bl2;
        }

        public void setIconPath(String string2) {
            this.iconPath = string2;
        }

        public void setId(long l2) {
            this.id = l2;
        }

        public void setMd5(String string2) {
            this.md5 = string2;
        }

        public void setName(String string2) {
            this.name = string2;
        }

        public void setRepoName(String string2) {
            this.repoName = string2;
        }

        public void setVercode(int n2) {
            this.vercode = n2;
        }

        public void setVername(String string2) {
            this.vername = string2;
        }

        public String toString() {
            return this.name;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void toggleChecked() {
            boolean bl2 = !this.checked;
            this.checked = bl2;
        }
    }
}

