/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev;

import android.content.Context;
import android.database.Cursor;
import android.os.Bundle;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.support.v7.app.ActionBarActivity;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.ListAdapter;
import android.widget.ListView;
import cm.aptoide.ptdev.Aptoide;
import cm.aptoide.ptdev.InstalledApkEvent;
import cm.aptoide.ptdev.R;
import cm.aptoide.ptdev.UnInstalledApkEvent;
import cm.aptoide.ptdev.adapters.RollBackAdapter;
import cm.aptoide.ptdev.adapters.RollbackSectionListAdapter;
import cm.aptoide.ptdev.database.Database;
import cm.aptoide.ptdev.events.BusProvider;
import cm.aptoide.ptdev.utils.SimpleCursorLoader;
import com.squareup.otto.Subscribe;

public class RollbackActivity
extends ActionBarActivity
implements LoaderManager.LoaderCallbacks<Cursor> {
    private RollBackAdapter rollBackAdapter;

    @Override
    public void onCreate(Bundle bundle) {
        Aptoide.getThemePicker().setAptoideTheme((Context)this);
        super.onCreate(bundle);
        this.setContentView(R.layout.page_rollback);
        this.rollBackAdapter = new RollBackAdapter(this);
        ListView listView = (ListView)this.findViewById(R.id.rollback_list);
        listView.setDivider(null);
        listView.setAdapter((ListAdapter)new RollbackSectionListAdapter(this.getLayoutInflater(), (ListAdapter)this.rollBackAdapter));
        this.getSupportActionBar().setHomeButtonEnabled(true);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getSupportActionBar().setDisplayShowTitleEnabled(true);
        this.getSupportActionBar().setTitle(this.getString(R.string.rollback));
    }

    @Override
    public Loader<Cursor> onCreateLoader(int n2, Bundle bundle) {
        return new SimpleCursorLoader((Context)this){

            @Override
            public Cursor loadInBackground() {
                return new Database(Aptoide.getDb()).getRollbackActions();
            }
        };
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.menu_rollback_activity, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    @Subscribe
    public void onInstalledApkEvent(InstalledApkEvent installedApkEvent) {
        this.refreshRollbackList();
    }

    @Override
    public void onLoadFinished(Loader<Cursor> loader, Cursor cursor) {
        this.rollBackAdapter.swapCursor(cursor);
        if (cursor.getCount() == 0) {
            this.findViewById(R.id.empty).setVisibility(0);
            return;
        }
        this.findViewById(R.id.empty).setVisibility(8);
    }

    @Override
    public void onLoaderReset(Loader<Cursor> loader) {
        this.rollBackAdapter.swapCursor(null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onOptionsItemSelected(MenuItem menuItem) {
        int n2 = menuItem.getItemId();
        if (n2 == 16908332) {
            this.finish();
            return super.onOptionsItemSelected(menuItem);
        }
        if (n2 == R.id.home) {
            this.finish();
            return super.onOptionsItemSelected(menuItem);
        }
        if (n2 != R.id.menu_clear_rollback) return super.onOptionsItemSelected(menuItem);
        new Database(Aptoide.getDb()).deleteRollbackItems();
        this.getSupportLoaderManager().restartLoader(17, null, this);
        return super.onOptionsItemSelected(menuItem);
    }

    @Override
    protected void onPause() {
        super.onPause();
        BusProvider.getInstance().unregister(this);
    }

    @Override
    protected void onResume() {
        super.onResume();
        BusProvider.getInstance().register(this);
        this.getSupportLoaderManager().restartLoader(17, null, this);
    }

    @Subscribe
    public void onUnistalledApkEvent(UnInstalledApkEvent unInstalledApkEvent) {
        this.refreshRollbackList();
    }

    public void refreshRollbackList() {
        this.getSupportLoaderManager().restartLoader(17, null, this);
    }
}

