/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.database.Cursor;
import android.os.IBinder;
import android.util.Log;
import cm.aptoide.ptdev.Aptoide;
import cm.aptoide.ptdev.database.Database;
import cm.aptoide.ptdev.model.Login;
import cm.aptoide.ptdev.model.Store;
import cm.aptoide.ptdev.services.HttpClientSpiceService;
import cm.aptoide.ptdev.services.ParserService;
import cm.aptoide.ptdev.webservices.RepositoryChangeRequest;
import cm.aptoide.ptdev.webservices.json.RepositoryChangeJson;
import com.octo.android.robospice.SpiceManager;
import com.octo.android.robospice.persistence.exception.SpiceException;
import com.octo.android.robospice.request.listener.RequestListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.http.message.BasicNameValuePair;

public class ParserHelper {
    private ServiceConnection conn = new ServiceConnection(){

        /*
         * Enabled aggressive block sorting
         */
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            ParserHelper.access$002(ParserHelper.this, ((ParserService.MainServiceBinder)iBinder).getService());
            ParserHelper.this.spiceManager.start(ParserHelper.this.context);
            if (!ParserHelper.this.storesToCheck.isEmpty()) {
                ParserHelper.this.spiceManager.execute(ParserHelper.this.request, (ParserHelper.this.repos.toString() + ParserHelper.this.hashes.toString()).hashCode(), 3600000L, new RequestListener<RepositoryChangeJson>(){

                    @Override
                    public void onRequestFailure(SpiceException spiceException) {
                        if (ParserHelper.this.spiceManager.isStarted()) {
                            ParserHelper.this.spiceManager.shouldStop();
                        }
                    }

                    @Override
                    public void onRequestSuccess(RepositoryChangeJson repositoryChangeJson) {
                        for (RepositoryChangeJson.Listing listing : repositoryChangeJson.listing) {
                            if (!Boolean.parseBoolean(listing.getHasupdates())) continue;
                            ParserHelper.this.spiceManager.removeDataFromCache(RepositoryChangeJson.class);
                            final Store store = new Store();
                            Cursor cursor = ParserHelper.this.database.getStore((Long)ParserHelper.this.storesIds.get(listing.getRepo()));
                            if (cursor.moveToFirst()) {
                                store.setBaseUrl(cursor.getString(cursor.getColumnIndex("url")));
                                store.setTopTimestamp(cursor.getLong(cursor.getColumnIndex("top_timestamp")));
                                store.setLatestTimestamp(cursor.getLong(cursor.getColumnIndex("latest_timestamp")));
                                store.setDelta(cursor.getString(cursor.getColumnIndex("hash")));
                                store.setId(cursor.getLong(cursor.getColumnIndex("id_repo")));
                                if (cursor.getString(cursor.getColumnIndex("username")) != null) {
                                    Login login = new Login();
                                    login.setUsername(cursor.getString(cursor.getColumnIndex("username")));
                                    login.setPassword(cursor.getString(cursor.getColumnIndex("password")));
                                    store.setLogin(login);
                                }
                            }
                            cursor.close();
                            if (ParserHelper.this.spiceManager.isStarted()) {
                                ParserHelper.this.spiceManager.shouldStop();
                            }
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    ParserHelper.this.service.setShowNotification(true);
                                    ParserHelper.this.service.startParse(ParserHelper.this.database, store, false);
                                }
                            }).start();
                        }
                        ParserHelper.this.context.unbindService(ParserHelper.this.conn);
                    }
                });
                return;
            } else {
                if (!ParserHelper.this.spiceManager.isStarted()) return;
                ParserHelper.this.spiceManager.shouldStop();
                return;
            }
        }

        public void onServiceDisconnected(ComponentName componentName) {
        }
    };
    private Context context;
    private Database database;
    private StringBuilder hashes;
    private StringBuilder repos;
    private RepositoryChangeRequest request;
    private ParserService service;
    SpiceManager spiceManager = new SpiceManager(HttpClientSpiceService.class);
    private HashMap<String, Long> storesIds;
    private ArrayList<BasicNameValuePair> storesToCheck;

    static /* synthetic */ ParserService access$002(ParserHelper parserHelper, ParserService parserService) {
        parserHelper.service = parserService;
        return parserService;
    }

    public void parse(Context context) {
        Log.d((String)"Aptoide-UpdateSync", (String)"parse");
        this.context = context;
        this.database = new Database(Aptoide.getDb());
        Cursor cursor = this.database.getServers();
        this.storesToCheck = new ArrayList();
        this.storesIds = new HashMap();
        cursor.moveToFirst();
        while (!cursor.isAfterLast()) {
            this.storesToCheck.add(new BasicNameValuePair(cursor.getString(cursor.getColumnIndex("name")), cursor.getString(cursor.getColumnIndex("hash"))));
            this.storesIds.put(cursor.getString(cursor.getColumnIndex("name")), cursor.getLong(cursor.getColumnIndex("id_repo")));
            cursor.moveToNext();
        }
        cursor.close();
        this.repos = new StringBuilder();
        this.hashes = new StringBuilder();
        Iterator<BasicNameValuePair> iterator = this.storesToCheck.iterator();
        while (iterator.hasNext()) {
            BasicNameValuePair basicNameValuePair = iterator.next();
            this.repos.append(basicNameValuePair.getName());
            this.hashes.append(basicNameValuePair.getValue());
            if (!iterator.hasNext()) continue;
            this.repos.append(",");
            this.hashes.append(",");
        }
        this.request = new RepositoryChangeRequest();
        this.request.setRepos(this.repos.toString());
        this.request.setHashes(this.hashes.toString());
        context.bindService(new Intent(context, ParserService.class), this.conn, 1);
    }
}

