/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.IBinder;
import android.preference.PreferenceManager;
import cm.aptoide.ptdev.Aptoide;
import cm.aptoide.ptdev.database.Database;
import cm.aptoide.ptdev.downloadmanager.EnumDownloadFailReason;
import cm.aptoide.ptdev.downloadmanager.state.EnumState;
import cm.aptoide.ptdev.events.BusProvider;
import cm.aptoide.ptdev.fragments.callbacks.RepoCompleteEvent;
import cm.aptoide.ptdev.model.Download;
import cm.aptoide.ptdev.model.Login;
import cm.aptoide.ptdev.model.Store;
import cm.aptoide.ptdev.services.DownloadService;
import cm.aptoide.ptdev.services.ParserService;
import java.io.IOException;

public class NetworkStateListener
extends BroadcastReceiver {
    private ServiceConnection conn = new ServiceConnection(){

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            Database database = new Database(Aptoide.getDb());
            NetworkStateListener.this.service = ((ParserService.MainServiceBinder)iBinder).getService();
            for (Number number : database.getFailedStores()) {
                Store store = new Store();
                Cursor cursor = database.getStore(number.longValue());
                if (cursor.moveToFirst()) {
                    store.setBaseUrl(cursor.getString(cursor.getColumnIndex("url")));
                    store.setTopTimestamp(cursor.getLong(cursor.getColumnIndex("top_timestamp")));
                    store.setLatestTimestamp(cursor.getLong(cursor.getColumnIndex("latest_timestamp")));
                    store.setDelta(cursor.getString(cursor.getColumnIndex("hash")));
                    store.setId(cursor.getLong(cursor.getColumnIndex("id_repo")));
                    if (cursor.getString(cursor.getColumnIndex("username")) != null) {
                        Login login = new Login();
                        login.setUsername(cursor.getString(cursor.getColumnIndex("username")));
                        login.setPassword(cursor.getString(cursor.getColumnIndex("password")));
                        store.setLogin(login);
                    }
                    NetworkStateListener.this.service.startParse(database, store, false);
                    BusProvider.getInstance().post(new RepoCompleteEvent(store.getId()));
                }
                cursor.close();
            }
            new Thread(new Runnable(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)Aptoide.getContext());
                    if (sharedPreferences.getLong("editorschoiceTimestamp", 0L) == 0L) {
                        try {
                            NetworkStateListener.this.service.parseEditorsChoice(new Database(Aptoide.getDb()), "http://apps.store.aptoide.com/editors_more.xml?country=us");
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                    if (sharedPreferences.getLong("topappsTimestamp", 0L) != 0L) return;
                    try {
                        NetworkStateListener.this.service.parseTopApps(new Database(Aptoide.getDb()), "http://apps.store.aptoide.com/top.xml");
                        return;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        return;
                    }
                }
            }).start();
            Aptoide.getContext().unbindService(NetworkStateListener.this.conn);
        }

        public void onServiceDisconnected(ComponentName componentName) {
        }
    };
    private ServiceConnection downloadConn;
    private DownloadService downloadService;
    private Object lock = new Object();
    ParserService service;

    public NetworkStateListener() {
        this.downloadConn = new ServiceConnection(){

            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                NetworkStateListener.access$102(NetworkStateListener.this, ((DownloadService.LocalBinder)iBinder).getService());
                for (Download download : NetworkStateListener.this.downloadService.getAllNotActiveDownloads()) {
                    if (!download.getDownloadState().equals((Object)EnumState.ERROR) || !download.getParent().getFailReason().equals((Object)EnumDownloadFailReason.TIMEOUT) && !download.getParent().getFailReason().equals((Object)EnumDownloadFailReason.CONNECTION_ERROR)) continue;
                    download.getParent().download();
                }
            }

            public void onServiceDisconnected(ComponentName componentName) {
            }
        };
    }

    static /* synthetic */ DownloadService access$102(NetworkStateListener networkStateListener, DownloadService downloadService) {
        networkStateListener.downloadService = downloadService;
        return downloadService;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onReceive(Context context, Intent intent) {
        NetworkInfo networkInfo = ((ConnectivityManager)context.getSystemService("connectivity")).getNetworkInfo(1);
        if (networkInfo != null && networkInfo.getState() == NetworkInfo.State.CONNECTED && this.service == null) {
            Object object = this.lock;
            synchronized (object) {
                Aptoide.getContext().bindService(new Intent(Aptoide.getContext(), ParserService.class), this.conn, 1);
            }
        }
        if (networkInfo != null && networkInfo.getState() == NetworkInfo.State.CONNECTED && this.downloadService == null) {
            Object object = this.lock;
            synchronized (object) {
                Aptoide.getContext().bindService(new Intent(Aptoide.getContext(), DownloadService.class), this.downloadConn, 1);
            }
        }
    }
}

