/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AccountManagerCallback;
import android.accounts.AccountManagerFuture;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.support.v7.app.ActionBarActivity;
import android.util.Log;
import android.view.MenuItem;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import cm.aptoide.ptdev.Aptoide;
import cm.aptoide.ptdev.R;
import cm.aptoide.ptdev.services.RabbitMqService;
import com.facebook.Session;
import com.facebook.SessionState;
import com.facebook.UiLifecycleHelper;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.plus.PlusClient;

public class MyAccountActivity
extends ActionBarActivity
implements GooglePlayServicesClient.ConnectionCallbacks,
GooglePlayServicesClient.OnConnectionFailedListener {
    private AccountManager mAccountManager;
    private PlusClient mPlusClient;
    private Session.StatusCallback statusCallback = new Session.StatusCallback(){

        @Override
        public void call(Session session, SessionState sessionState, Exception exception) {
        }
    };
    private UiLifecycleHelper uiLifecycleHelper;

    private void addAccount() {
        this.mAccountManager.addAccount("cm.aptoide.pt", "Full access", null, null, (Activity)this, (AccountManagerCallback)new AccountManagerCallback<Bundle>(){

            public void run(AccountManagerFuture<Bundle> accountManagerFuture) {
                try {
                    Bundle bundle = (Bundle)accountManagerFuture.getResult();
                    if (bundle.containsKey("authtoken")) {
                        MyAccountActivity.this.setContentView(R.layout.form_logout);
                        Toast.makeText((Context)MyAccountActivity.this, (CharSequence)"Account was created", (int)1).show();
                        Log.d((String)"udinic", (String)("AddNewAccount Bundle is " + bundle));
                        return;
                    }
                    MyAccountActivity.this.finish();
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
            }
        }, null);
    }

    @Override
    public void onConnected(Bundle bundle) {
    }

    @Override
    public void onConnectionFailed(ConnectionResult connectionResult) {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onCreate(Bundle bundle) {
        Aptoide.getThemePicker().setAptoideTheme((Context)this);
        super.onCreate(bundle);
        this.uiLifecycleHelper = new UiLifecycleHelper(this, this.statusCallback);
        this.uiLifecycleHelper.onCreate(bundle);
        this.mPlusClient = new PlusClient.Builder((Context)this, this, this).build();
        this.mAccountManager = AccountManager.get((Context)this);
        if (this.mAccountManager.getAccountsByType("cm.aptoide.pt").length > 0) {
            this.setContentView(R.layout.form_logout);
            final Account account = this.mAccountManager.getAccountsByType("cm.aptoide.pt")[0];
            ((TextView)this.findViewById(R.id.username)).setText((CharSequence)account.name);
            this.findViewById(R.id.button_logout).setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    Session session = Session.getActiveSession();
                    if (session != null && session.isOpened()) {
                        session.closeAndClearTokenInformation();
                    }
                    if (MyAccountActivity.this.mPlusClient.isConnected()) {
                        MyAccountActivity.this.mPlusClient.clearDefaultAccount();
                        MyAccountActivity.this.mPlusClient.disconnect();
                    }
                    PreferenceManager.getDefaultSharedPreferences((Context)MyAccountActivity.this.getApplicationContext()).edit().remove("queueName").commit();
                    MyAccountActivity.this.stopService(new Intent((Context)MyAccountActivity.this, RabbitMqService.class));
                    MyAccountActivity.this.mAccountManager.removeAccount(account, (AccountManagerCallback)new AccountManagerCallback<Boolean>(){

                        public void run(AccountManagerFuture<Boolean> accountManagerFuture) {
                            MyAccountActivity.this.finish();
                        }
                    }, null);
                }
            });
        } else {
            this.addAccount();
            this.finish();
        }
        this.getSupportActionBar().setTitle(this.getString(R.string.sign_out));
        this.getSupportActionBar().setDisplayShowTitleEnabled(true);
        this.getSupportActionBar().setHomeButtonEnabled(true);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (Build.VERSION.SDK_INT >= 8) {
            this.uiLifecycleHelper.onDestroy();
        }
    }

    @Override
    public void onDisconnected() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onOptionsItemSelected(MenuItem menuItem) {
        int n2 = menuItem.getItemId();
        if (n2 == 16908332) {
            this.finish();
            return super.onOptionsItemSelected(menuItem);
        }
        if (n2 != R.id.home) return super.onOptionsItemSelected(menuItem);
        this.finish();
        return super.onOptionsItemSelected(menuItem);
    }

    @Override
    public void onPause() {
        super.onPause();
        if (Build.VERSION.SDK_INT >= 8) {
            this.uiLifecycleHelper.onPause();
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        if (Build.VERSION.SDK_INT >= 8) {
            this.uiLifecycleHelper.onResume();
        }
    }

    @Override
    protected void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        if (Build.VERSION.SDK_INT >= 8) {
            this.uiLifecycleHelper.onSaveInstanceState(bundle);
        }
    }

    @Override
    protected void onStart() {
        super.onStart();
        if (Build.VERSION.SDK_INT >= 8) {
            this.mPlusClient.connect();
        }
    }

    @Override
    protected void onStop() {
        super.onStop();
        if (Build.VERSION.SDK_INT >= 8) {
            this.mPlusClient.disconnect();
        }
    }
}

