/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.support.v4.app.ListFragment;
import android.support.v7.app.ActionBarActivity;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.ListAdapter;
import android.widget.TextView;
import cm.aptoide.ptdev.Aptoide;
import cm.aptoide.ptdev.R;
import cm.aptoide.ptdev.adapters.RelatedBucketAdapter;
import cm.aptoide.ptdev.services.HttpClientSpiceService;
import cm.aptoide.ptdev.webservices.ListRelatedApkRequest;
import cm.aptoide.ptdev.webservices.json.RelatedApkJson;
import com.commonsware.cwac.merge.MergeAdapter;
import com.octo.android.robospice.SpiceManager;
import com.octo.android.robospice.persistence.exception.SpiceException;
import com.octo.android.robospice.request.listener.RequestListener;
import java.util.ArrayList;
import java.util.List;

public class MoreRelatedActivity
extends ActionBarActivity {
    @Override
    protected void onCreate(Bundle bundle) {
        Aptoide.getThemePicker().setAptoideTheme((Context)this);
        super.onCreate(bundle);
        this.setContentView(R.layout.page_store);
        FragmentRelatedMore fragmentRelatedMore = new FragmentRelatedMore();
        fragmentRelatedMore.setArguments(this.getIntent().getExtras());
        this.getSupportFragmentManager().beginTransaction().replace(R.id.fragment_container, fragmentRelatedMore).commit();
        this.getSupportActionBar().setHomeButtonEnabled(true);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getSupportActionBar().setDisplayShowTitleEnabled(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onOptionsItemSelected(MenuItem menuItem) {
        int n2 = menuItem.getItemId();
        if (n2 == 16908332) {
            this.finish();
            return super.onOptionsItemSelected(menuItem);
        }
        if (n2 != R.id.home) return super.onOptionsItemSelected(menuItem);
        this.finish();
        return super.onOptionsItemSelected(menuItem);
    }

    public static class FragmentRelatedMore
    extends ListFragment {
        private MergeAdapter adapter;
        private List<RelatedApkJson.Item> elements = new ArrayList<RelatedApkJson.Item>();
        private RelatedBucketAdapter listAdapter;
        private String mode;
        private String packageName;
        RequestListener<RelatedApkJson> request;
        SpiceManager spiceManager = new SpiceManager(HttpClientSpiceService.class);
        private int versionCode;

        public FragmentRelatedMore() {
            this.request = new RequestListener<RelatedApkJson>(){

                @Override
                public void onRequestFailure(SpiceException spiceException) {
                    FragmentRelatedMore.this.setEmptyText(FragmentRelatedMore.this.getString(R.string.connection_error));
                    FragmentRelatedMore.this.setListShown(true);
                }

                /*
                 * Enabled aggressive block sorting
                 */
                @Override
                public void onRequestSuccess(RelatedApkJson relatedApkJson) {
                    ArrayList<Object> arrayList = relatedApkJson != null ? (FragmentRelatedMore.this.mode.equals("multiversion") ? new ArrayList<RelatedApkJson.Item>(relatedApkJson.getMultiversion()) : (FragmentRelatedMore.this.mode.equals("itembased") ? new ArrayList<RelatedApkJson.Item>(relatedApkJson.getItembased()) : new ArrayList<RelatedApkJson.Item>(relatedApkJson.getDevelbased()))) : new ArrayList();
                    if (arrayList.size() > 0) {
                        FragmentRelatedMore.this.elements.clear();
                        if (PreferenceManager.getDefaultSharedPreferences((Context)Aptoide.getContext()).getBoolean("matureChkBox", true)) {
                            for (RelatedApkJson.Item item : arrayList) {
                                if (item.getAge().equals("Mature")) continue;
                                FragmentRelatedMore.this.elements.add(item);
                            }
                        } else {
                            FragmentRelatedMore.this.elements.addAll(arrayList);
                        }
                        FragmentRelatedMore.this.adapter.addAdapter((ListAdapter)FragmentRelatedMore.this.listAdapter);
                    }
                    FragmentRelatedMore.this.listAdapter.notifyDataSetChanged();
                    FragmentRelatedMore.this.setListAdapter((ListAdapter)FragmentRelatedMore.this.adapter);
                    FragmentRelatedMore.this.setEmptyText(FragmentRelatedMore.this.getString(R.string.no_related));
                }
            };
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onActivityCreated(Bundle bundle) {
            super.onActivityCreated(bundle);
            if (this.getArguments().containsKey("version")) {
                ((ActionBarActivity)this.getActivity()).getSupportActionBar().setTitle(this.getString(R.string.multiversion));
                return;
            } else {
                if (this.getArguments().containsKey("developer")) {
                    ((ActionBarActivity)this.getActivity()).getSupportActionBar().setTitle(this.getString(R.string.more_from_publisher));
                    return;
                }
                if (!this.getArguments().containsKey("item")) return;
                ((ActionBarActivity)this.getActivity()).getSupportActionBar().setTitle(this.getString(R.string.related_apps));
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onCreate(Bundle bundle) {
            super.onCreate(bundle);
            this.packageName = this.getArguments().getString("packageName");
            this.versionCode = this.getArguments().getInt("versionCode");
            if (this.getArguments().containsKey("version")) {
                this.mode = "multiversion";
            } else if (this.getArguments().containsKey("developer")) {
                this.mode = "develbased";
            } else if (this.getArguments().containsKey("item")) {
                this.mode = "itembased";
            }
            this.adapter = new MergeAdapter();
            this.listAdapter = new RelatedBucketAdapter((Activity)this.getActivity(), this.elements);
        }

        @Override
        public void onStart() {
            super.onStart();
            this.spiceManager.start((Context)this.getActivity());
        }

        @Override
        public void onStop() {
            super.onStop();
            if (this.spiceManager.isStarted()) {
                this.spiceManager.shouldStop();
            }
        }

        @Override
        public void onViewCreated(View view, Bundle bundle) {
            super.onViewCreated(view, bundle);
            ListRelatedApkRequest listRelatedApkRequest = new ListRelatedApkRequest((Context)this.getActivity());
            listRelatedApkRequest.setMode(this.mode);
            listRelatedApkRequest.setPackageName(this.packageName);
            listRelatedApkRequest.setVercode(this.versionCode);
            listRelatedApkRequest.setLimit(5 * this.listAdapter.getBucketSize());
            View view2 = LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.header_frag_more, null);
            if (view2 != null) {
                ((TextView)view2.findViewById(R.id.separator_label)).setText((CharSequence)this.getArguments().getString("appName"));
            }
            this.getListView().addHeaderView(view2);
            this.spiceManager.execute(listRelatedApkRequest, this.packageName + "-related-" + this.mode, 86400000L, this.request);
            this.getListView().setDivider(null);
            this.getListView().setCacheColorHint(this.getResources().getColor(17170445));
        }
    }
}

