/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.app.ProgressDialog;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.support.v4.app.DialogFragment;
import android.text.SpannableString;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.text.style.UnderlineSpan;
import android.util.Log;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;
import cm.aptoide.ptdev.AccountAuthenticatorActivity;
import cm.aptoide.ptdev.Aptoide;
import cm.aptoide.ptdev.R;
import cm.aptoide.ptdev.SignUpActivity;
import cm.aptoide.ptdev.dialogs.AptoideDialog;
import cm.aptoide.ptdev.dialogs.ProgressDialogFragment;
import cm.aptoide.ptdev.model.Error;
import cm.aptoide.ptdev.services.HttpClientSpiceService;
import cm.aptoide.ptdev.services.RabbitMqService;
import cm.aptoide.ptdev.utils.AptoideUtils;
import cm.aptoide.ptdev.utils.Filters;
import cm.aptoide.ptdev.webservices.CheckUserCredentialsRequest;
import cm.aptoide.ptdev.webservices.json.CheckUserCredentialsJson;
import com.facebook.Request;
import com.facebook.Response;
import com.facebook.Session;
import com.facebook.SessionState;
import com.facebook.UiLifecycleHelper;
import com.facebook.model.GraphUser;
import com.google.android.gms.auth.GoogleAuthException;
import com.google.android.gms.auth.GoogleAuthUtil;
import com.google.android.gms.auth.UserRecoverableAuthException;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.SignInButton;
import com.google.android.gms.plus.PlusClient;
import com.google.api.client.util.Data;
import com.octo.android.robospice.SpiceManager;
import com.octo.android.robospice.persistence.exception.SpiceException;
import com.octo.android.robospice.request.listener.RequestListener;
import java.io.IOException;
import java.util.Locale;

public class LoginActivity
extends AccountAuthenticatorActivity
implements GooglePlayServicesClient.ConnectionCallbacks,
GooglePlayServicesClient.OnConnectionFailedListener,
View.OnClickListener,
ProgressDialogFragment.OnCancelListener {
    public static final String ARG_ACCOUNT_NAME = "ACCOUNT_NAME";
    public static final String ARG_ACCOUNT_TYPE = "ACCOUNT_TYPE";
    public static final String ARG_AUTH_TYPE = "AUTH_TYPE";
    public static final String ARG_IS_ADDING_NEW_ACCOUNT = "IS_ADDING_ACCOUNT";
    public static final String KEY_ERROR_MESSAGE = "ERR_MSG";
    public static final String PARAM_USER_AVATAR = "USER_AVATAR";
    public static final String PARAM_USER_PASS = "USER_PASS";
    private static final int REQUEST_CODE_RESOLVE_ERR = 9000;
    private final int REQ_SIGNUP;
    private final String TAG;
    CheckBox checkShowPass;
    private boolean fromPreviousAptoideVersion;
    private boolean hasQueue;
    private AccountManager mAccountManager;
    private String mAuthTokenType;
    private ProgressDialog mConnectionProgressDialog;
    private ConnectionResult mConnectionResult;
    private PlusClient mPlusClient;
    EditText password_box;
    private CheckBox registerDevice;
    private CheckUserCredentialsRequest request;
    private boolean showPassword = true;
    private SpiceManager spiceManager = new SpiceManager(HttpClientSpiceService.class);
    private Session.StatusCallback statusCallback = new Session.StatusCallback(){

        @Override
        public void call(final Session session, SessionState sessionState, Exception exception) {
            if (sessionState.isOpened()) {
                Request.newMeRequest(session, new Request.GraphUserCallback(){

                    @Override
                    public void onCompleted(GraphUser graphUser, Response response) {
                        if (session == Session.getActiveSession() && graphUser != null) {
                            try {
                                LoginActivity.this.submit(Mode.FACEBOOK, graphUser.getProperty("email").toString(), session.getAccessToken(), null);
                                return;
                            }
                            catch (Exception exception) {
                                LoginActivity.this.runOnUiThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        Toast.makeText((Context)LoginActivity.this, (int)R.string.error_occured, (int)1).show();
                                        DialogFragment dialogFragment = (DialogFragment)LoginActivity.this.getSupportFragmentManager().findFragmentByTag("pleaseWaitDialog");
                                        if (dialogFragment != null) {
                                            dialogFragment.dismissAllowingStateLoss();
                                        }
                                    }
                                });
                                session.closeAndClearTokenInformation();
                                return;
                            }
                        }
                        session.closeAndClearTokenInformation();
                    }
                }).executeAsync();
            }
        }
    };
    private UiLifecycleHelper uiLifecycleHelper;

    public LoginActivity() {
        this.REQ_SIGNUP = 1;
        this.TAG = "Login";
    }

    static /* synthetic */ boolean access$102(LoginActivity loginActivity, boolean bl2) {
        loginActivity.showPassword = bl2;
        return bl2;
    }

    static /* synthetic */ boolean access$202(LoginActivity loginActivity, boolean bl2) {
        loginActivity.hasQueue = bl2;
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void finishLogin(Intent intent) {
        Log.d((String)"aptoide", (String)"Login> finishLogin");
        String string2 = intent.getStringExtra("authAccount");
        String string3 = intent.getStringExtra(PARAM_USER_PASS);
        Account account = new Account(string2, intent.getStringExtra("accountType"));
        if (this.getIntent().getBooleanExtra(ARG_IS_ADDING_NEW_ACCOUNT, false)) {
            Log.d((String)"aptoide", (String)"Login> finishLogin > addAccountExplicitly");
            String string4 = intent.getStringExtra("authtoken");
            String string5 = this.mAuthTokenType;
            this.mAccountManager.addAccountExplicitly(account, string3, null);
            this.mAccountManager.setAuthToken(account, string5, string4);
        } else {
            Log.d((String)"aptoide", (String)"Login> finishLogin > setPassword");
            this.mAccountManager.setPassword(account, string3);
        }
        this.setAccountAuthenticatorResult(intent.getExtras());
        this.setResult(-1, intent);
        if (this.fromPreviousAptoideVersion) {
            PreferenceManager.getDefaultSharedPreferences((Context)this).edit().remove("usernameLogin").commit();
        }
        this.finish();
        if (this.registerDevice.isChecked() && this.hasQueue) {
            this.startService(new Intent((Context)this, RabbitMqService.class));
        }
        ContentResolver.setSyncAutomatically((Account)account, (String)"cm.aptoide.pt.UpdatesProvider", (boolean)true);
        if (Build.VERSION.SDK_INT >= 8) {
            ContentResolver.addPeriodicSync((Account)account, (String)"cm.aptoide.pt.UpdatesProvider", (Bundle)new Bundle(), (long)43200L);
        }
        ContentResolver.setSyncAutomatically((Account)account, (String)"cm.aptoide.pt.AutoUpdateProvider", (boolean)true);
    }

    public static boolean isLoggedIn(Context context) {
        return AccountManager.get((Context)context).getAccountsByType("cm.aptoide.pt").length != 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onActivityResult(int n2, int n3, final Intent intent) {
        super.onActivityResult(n2, n3, intent);
        if (n2 == 9000 && n3 == -1) {
            this.mConnectionResult = null;
            this.mPlusClient.connect();
        } else if (n2 == 90 && n3 == -1) {
            this.mPlusClient.connect();
        }
        if (this.uiLifecycleHelper != null) {
            this.uiLifecycleHelper.onActivityResult(n2, n3, intent);
        }
        if (n2 == 1 && n3 == -1) {
            ((EditText)this.findViewById(R.id.username)).setText((CharSequence)intent.getStringExtra("username"));
            ((EditText)this.findViewById(R.id.password)).setText((CharSequence)intent.getStringExtra("password"));
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    LoginActivity.this.submit(Mode.APTOIDE, intent.getStringExtra("username"), intent.getStringExtra("password"), null);
                }
            });
        }
    }

    @Override
    public void onCancel() {
        if (this.request != null && this.spiceManager.isStarted()) {
            this.spiceManager.cancel(this.request);
        }
    }

    public void onClick(View view) {
        block5: {
            block4: {
                if (view.getId() != R.id.g_sign_in_button || this.mPlusClient.isConnected()) break block4;
                if (this.mConnectionResult != null) break block5;
                this.mPlusClient.connect();
                this.mConnectionProgressDialog.show();
            }
            return;
        }
        try {
            this.mConnectionResult.startResolutionForResult(this, 9000);
            return;
        }
        catch (IntentSender.SendIntentException sendIntentException) {
            this.mConnectionResult = null;
            this.mPlusClient.connect();
            return;
        }
    }

    @Override
    public void onConnected(Bundle bundle) {
        Log.d((String)"Aptoide-", (String)"On Connected");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    final String string2 = GoogleAuthUtil.getToken((Context)LoginActivity.this, LoginActivity.this.mPlusClient.getAccountName(), "oauth2:server:client_id:316068701674.apps.googleusercontent.com:api_scope:https://www.googleapis.com/auth/plus.login");
                    final String string3 = LoginActivity.this.mPlusClient.getAccountName();
                    final String string4 = LoginActivity.this.mPlusClient.getCurrentPerson().getDisplayName();
                    LoginActivity.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            LoginActivity.this.submit(Mode.GOOGLE, string3, string2, string4);
                        }
                    });
                    return;
                }
                catch (IOException iOException) {
                    if (LoginActivity.this.mPlusClient != null && LoginActivity.this.mPlusClient.isConnected()) {
                        LoginActivity.this.mPlusClient.clearDefaultAccount();
                        LoginActivity.this.mPlusClient.disconnect();
                    }
                    iOException.printStackTrace();
                    LoginActivity.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            Toast.makeText((Context)LoginActivity.this, (int)R.string.error_occured, (int)1).show();
                            DialogFragment dialogFragment = (DialogFragment)LoginActivity.this.getSupportFragmentManager().findFragmentByTag("pleaseWaitDialog");
                            if (dialogFragment != null) {
                                dialogFragment.dismissAllowingStateLoss();
                            }
                        }
                    });
                    return;
                }
                catch (UserRecoverableAuthException userRecoverableAuthException) {
                    LoginActivity.this.startActivityForResult(userRecoverableAuthException.getIntent(), 90);
                    return;
                }
                catch (GoogleAuthException googleAuthException) {
                    googleAuthException.printStackTrace();
                    if (LoginActivity.this.mPlusClient != null && LoginActivity.this.mPlusClient.isConnected()) {
                        LoginActivity.this.mPlusClient.clearDefaultAccount();
                        LoginActivity.this.mPlusClient.disconnect();
                    }
                    LoginActivity.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            Toast.makeText((Context)LoginActivity.this, (int)R.string.error_occured, (int)1).show();
                            DialogFragment dialogFragment = (DialogFragment)LoginActivity.this.getSupportFragmentManager().findFragmentByTag("pleaseWaitDialog");
                            if (dialogFragment != null) {
                                dialogFragment.dismissAllowingStateLoss();
                            }
                        }
                    });
                    return;
                }
                catch (Exception exception) {
                    if (LoginActivity.this.mPlusClient != null && LoginActivity.this.mPlusClient.isConnected()) {
                        LoginActivity.this.mPlusClient.clearDefaultAccount();
                        LoginActivity.this.mPlusClient.disconnect();
                    }
                    LoginActivity.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            Toast.makeText((Context)LoginActivity.this, (int)R.string.error_occured, (int)1).show();
                            DialogFragment dialogFragment = (DialogFragment)LoginActivity.this.getSupportFragmentManager().findFragmentByTag("pleaseWaitDialog");
                            if (dialogFragment != null) {
                                dialogFragment.dismissAllowingStateLoss();
                            }
                        }
                    });
                    return;
                }
            }
        }).start();
        this.mConnectionProgressDialog.dismiss();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onConnectionFailed(ConnectionResult connectionResult) {
        DialogFragment dialogFragment;
        if (this.mConnectionProgressDialog.isShowing() && connectionResult.hasResolution()) {
            try {
                connectionResult.startResolutionForResult(this, 9000);
            }
            catch (IntentSender.SendIntentException sendIntentException) {
                this.mPlusClient.connect();
            }
        }
        if ((dialogFragment = (DialogFragment)this.getSupportFragmentManager().findFragmentByTag("pleaseWaitDialog")) != null) {
            dialogFragment.dismissAllowingStateLoss();
        }
        this.mConnectionResult = connectionResult;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onCreate(Bundle bundle) {
        Aptoide.getThemePicker().setAptoideTheme((Context)this);
        super.onCreate(bundle);
        if (AccountManager.get((Context)this).getAccountsByType("cm.aptoide.pt").length > 0) {
            this.finish();
            Toast.makeText((Context)this, (int)R.string.one_account_allowed, (int)0).show();
            return;
        }
        this.setContentView(R.layout.form_login);
        if (Build.VERSION.SDK_INT >= 8) {
            this.findViewById(R.id.g_sign_in_button).setOnClickListener((View.OnClickListener)this);
            this.mConnectionProgressDialog = new ProgressDialog((Context)this);
            this.mConnectionProgressDialog.setMessage((CharSequence)this.getString(R.string.signing_in));
            this.uiLifecycleHelper = new UiLifecycleHelper(this, this.statusCallback);
            this.uiLifecycleHelper.onCreate(bundle);
            this.mPlusClient = new PlusClient.Builder((Context)this, this, this).build();
            boolean bl2 = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this) == 0;
            SignInButton signInButton = (SignInButton)this.findViewById(R.id.g_sign_in_button);
            if (!bl2) {
                signInButton.setVisibility(8);
            }
        }
        this.mAccountManager = AccountManager.get((Context)this.getBaseContext());
        String string2 = this.getIntent().getStringExtra(ARG_ACCOUNT_NAME);
        this.mAuthTokenType = this.getIntent().getStringExtra(ARG_AUTH_TYPE);
        if (this.mAuthTokenType == null) {
            this.mAuthTokenType = "Full access";
        }
        if (string2 != null) {
            ((EditText)this.findViewById(R.id.username)).setText((CharSequence)string2);
        }
        if (PreferenceManager.getDefaultSharedPreferences((Context)this).contains("usernameLogin")) {
            ((EditText)this.findViewById(R.id.username)).setText((CharSequence)PreferenceManager.getDefaultSharedPreferences((Context)this).getString("usernameLogin", ""));
            this.fromPreviousAptoideVersion = true;
        }
        this.password_box = (EditText)this.findViewById(R.id.password);
        this.password_box.setTransformationMethod((TransformationMethod)new PasswordTransformationMethod());
        final Drawable drawable2 = this.getResources().getDrawable(R.drawable.ic_show_password);
        final Drawable drawable3 = this.getResources().getDrawable(R.drawable.ic_hide_password);
        this.password_box.setCompoundDrawablesWithIntrinsicBounds(null, null, drawable2, null);
        this.password_box.setOnTouchListener(new View.OnTouchListener(){

            /*
             * Enabled aggressive block sorting
             */
            public boolean onTouch(View view, MotionEvent motionEvent) {
                if (LoginActivity.this.password_box.getCompoundDrawables()[2] == null || motionEvent.getAction() == 1 || !(motionEvent.getX() > (float)(LoginActivity.this.password_box.getWidth() - LoginActivity.this.password_box.getPaddingRight() - drawable2.getIntrinsicWidth()))) {
                    return false;
                }
                if (LoginActivity.this.showPassword) {
                    LoginActivity.access$102(LoginActivity.this, false);
                    LoginActivity.this.password_box.setTransformationMethod(null);
                    LoginActivity.this.password_box.setCompoundDrawablesWithIntrinsicBounds(null, null, drawable3, null);
                    return false;
                }
                LoginActivity.access$102(LoginActivity.this, true);
                LoginActivity.this.password_box.setTransformationMethod((TransformationMethod)new PasswordTransformationMethod());
                LoginActivity.this.password_box.setCompoundDrawablesWithIntrinsicBounds(null, null, drawable2, null);
                return false;
            }
        });
        this.findViewById(R.id.button_login).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String string2 = ((EditText)LoginActivity.this.findViewById(R.id.username)).getText().toString();
                String string3 = ((EditText)LoginActivity.this.findViewById(R.id.password)).getText().toString();
                LoginActivity.this.submit(Mode.APTOIDE, string2, string3, null);
            }
        });
        TextView textView = (TextView)this.findViewById(R.id.new_to_aptoide);
        int n2 = R.string.new_to_aptoide;
        Object[] objectArray = new Object[]{Aptoide.getConfiguration().getMarketName()};
        SpannableString spannableString = new SpannableString((CharSequence)this.getString(n2, objectArray));
        spannableString.setSpan((Object)new UnderlineSpan(), 0, spannableString.length(), 0);
        textView.setText((CharSequence)spannableString);
        textView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Intent intent = new Intent((Context)LoginActivity.this, SignUpActivity.class);
                LoginActivity.this.startActivityForResult(intent, 1);
            }
        });
        this.registerDevice = (CheckBox)this.findViewById(R.id.link_my_device);
        TextView textView2 = (TextView)this.findViewById(R.id.forgot_password);
        SpannableString spannableString2 = new SpannableString((CharSequence)this.getString(R.string.forgot_passwd));
        spannableString2.setSpan((Object)new UnderlineSpan(), 0, spannableString2.length(), 0);
        textView2.setText((CharSequence)spannableString2);
        textView2.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)"http://m.aptoide.com/account/password-recovery"));
                LoginActivity.this.startActivity(intent);
            }
        });
        this.getSupportActionBar().setTitle(this.getString(R.string.setcredentials));
        this.getSupportActionBar().setHomeButtonEnabled(true);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getSupportActionBar().setDisplayShowTitleEnabled(true);
        this.getSupportActionBar().setTitle(this.getString(R.string.login_or_register));
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (Build.VERSION.SDK_INT >= 8 && this.uiLifecycleHelper != null) {
            this.uiLifecycleHelper.onDestroy();
        }
    }

    @Override
    public void onDisconnected() {
        DialogFragment dialogFragment = (DialogFragment)this.getSupportFragmentManager().findFragmentByTag("pleaseWaitDialog");
        if (dialogFragment != null) {
            dialogFragment.dismissAllowingStateLoss();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onOptionsItemSelected(MenuItem menuItem) {
        int n2 = menuItem.getItemId();
        if (n2 == 16908332) {
            this.finish();
            return super.onOptionsItemSelected(menuItem);
        }
        if (n2 != R.id.home) return super.onOptionsItemSelected(menuItem);
        this.finish();
        return super.onOptionsItemSelected(menuItem);
    }

    @Override
    protected void onPause() {
        super.onPause();
        if (Build.VERSION.SDK_INT >= 8) {
            this.uiLifecycleHelper.onPause();
        }
    }

    protected void onRestoreInstanceState(Bundle bundle) {
        super.onRestoreInstanceState(bundle);
    }

    @Override
    protected void onResume() {
        super.onResume();
        if (Build.VERSION.SDK_INT >= 8) {
            this.uiLifecycleHelper.onResume();
        }
    }

    @Override
    protected void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        if (Build.VERSION.SDK_INT >= 8) {
            this.uiLifecycleHelper.onSaveInstanceState(bundle);
        }
    }

    @Override
    protected void onStart() {
        super.onStart();
        this.spiceManager.start(this.getBaseContext());
    }

    @Override
    protected void onStop() {
        super.onStop();
        if (this.mPlusClient != null && this.mPlusClient.isConnected()) {
            this.mPlusClient.disconnect();
        }
        this.spiceManager.shouldStop();
    }

    public void submit(Mode mode, final String string2, final String string3, String string4) {
        final String string5 = this.getIntent().getStringExtra(ARG_ACCOUNT_TYPE);
        this.request = new CheckUserCredentialsRequest();
        this.request.setMode(mode);
        String string6 = Settings.Secure.getString((ContentResolver)this.getContentResolver(), (String)"android_id");
        this.request.setRegisterDevice(this.registerDevice.isChecked());
        this.request.setSdk(String.valueOf(AptoideUtils.HWSpecifications.getSdkVer()));
        this.request.setDeviceId(string6);
        this.request.setCpu(AptoideUtils.HWSpecifications.getCpuAbi() + "," + AptoideUtils.HWSpecifications.getCpuAbi2());
        this.request.setDensity(String.valueOf(AptoideUtils.HWSpecifications.getNumericScreenSize((Context)this)));
        this.request.setOpenGl(String.valueOf(AptoideUtils.HWSpecifications.getGlEsVer((Context)this)));
        this.request.setModel(Build.MODEL);
        this.request.setScreenSize(Filters.Screen.values()[AptoideUtils.HWSpecifications.getScreenSize((Context)this)].name().toLowerCase(Locale.ENGLISH));
        this.request.setUser(string2);
        this.request.setPassword(string3);
        this.request.setNameForGoogle(string4);
        AptoideDialog.pleaseWaitDialog().show(this.getSupportFragmentManager(), "pleaseWaitDialog");
        this.spiceManager.execute(this.request, new RequestListener<CheckUserCredentialsJson>(){

            @Override
            public void onRequestFailure(SpiceException spiceException) {
                Session session = Session.getActiveSession();
                if (session != null && session.isOpened()) {
                    session.closeAndClearTokenInformation();
                }
                if (LoginActivity.this.mPlusClient != null && LoginActivity.this.mPlusClient.isConnected()) {
                    LoginActivity.this.mPlusClient.clearDefaultAccount();
                    LoginActivity.this.mPlusClient.disconnect();
                }
                Toast.makeText((Context)LoginActivity.this.getBaseContext(), (int)R.string.error_occured, (int)0).show();
                DialogFragment dialogFragment = (DialogFragment)LoginActivity.this.getSupportFragmentManager().findFragmentByTag("pleaseWaitDialog");
                if (dialogFragment != null) {
                    dialogFragment.dismissAllowingStateLoss();
                }
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onRequestSuccess(CheckUserCredentialsJson checkUserCredentialsJson) {
                DialogFragment dialogFragment = (DialogFragment)LoginActivity.this.getSupportFragmentManager().findFragmentByTag("pleaseWaitDialog");
                if (dialogFragment != null) {
                    dialogFragment.dismissAllowingStateLoss();
                }
                if ("OK".equals(checkUserCredentialsJson.getStatus())) {
                    if (!Data.isNull(checkUserCredentialsJson.getQueue())) {
                        LoginActivity.access$202(LoginActivity.this, true);
                        PreferenceManager.getDefaultSharedPreferences((Context)LoginActivity.this).edit().putString("queueName", checkUserCredentialsJson.getQueue()).commit();
                    }
                    if (!Data.isNull(checkUserCredentialsJson.getAvatar())) {
                        PreferenceManager.getDefaultSharedPreferences((Context)LoginActivity.this).edit().putString("useravatar", checkUserCredentialsJson.getAvatar()).commit();
                    }
                    if (!Data.isNull(checkUserCredentialsJson.getUsername())) {
                        PreferenceManager.getDefaultSharedPreferences((Context)LoginActivity.this).edit().putString("username", checkUserCredentialsJson.getUsername()).commit();
                    }
                    Bundle bundle = new Bundle();
                    bundle.putString("authAccount", string2);
                    bundle.putString("accountType", string5);
                    bundle.putString("authtoken", checkUserCredentialsJson.getToken());
                    bundle.putString(LoginActivity.PARAM_USER_PASS, string3);
                    Intent intent = new Intent();
                    intent.putExtras(bundle);
                    LoginActivity.this.finishLogin(intent);
                    return;
                } else {
                    for (Error error : checkUserCredentialsJson.getErrors()) {
                        Toast.makeText((Context)LoginActivity.this.getBaseContext(), (CharSequence)error.getMsg(), (int)0).show();
                    }
                }
            }
        });
    }

    public static final class Mode
    extends Enum<Mode> {
        private static final /* synthetic */ Mode[] $VALUES;
        public static final /* enum */ Mode APTOIDE = new Mode();
        public static final /* enum */ Mode FACEBOOK;
        public static final /* enum */ Mode GOOGLE;

        static {
            GOOGLE = new Mode();
            FACEBOOK = new Mode();
            Mode[] modeArray = new Mode[]{APTOIDE, GOOGLE, FACEBOOK};
            $VALUES = modeArray;
        }

        public static Mode valueOf(String string2) {
            return Enum.valueOf(Mode.class, string2);
        }

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }
    }
}

