/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.util.Log;
import cm.aptoide.ptdev.Aptoide;
import cm.aptoide.ptdev.InstalledApkEvent;
import cm.aptoide.ptdev.UnInstalledApkEvent;
import cm.aptoide.ptdev.database.Database;
import cm.aptoide.ptdev.events.BusProvider;
import cm.aptoide.ptdev.model.InstalledPackage;
import cm.aptoide.ptdev.model.RollBackItem;
import cm.aptoide.ptdev.utils.AptoideUtils;
import java.util.Locale;

public class InstalledBroadcastReceiver
extends BroadcastReceiver {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TargetApi(value=11)
    public void onReceive(Context context, Intent intent) {
        Database database = new Database(Aptoide.getDb());
        if (intent.getAction().equals("android.intent.action.PACKAGE_REPLACED")) {
            database.confirmRollBackAction(intent.getData().getEncodedSchemeSpecificPart(), RollBackItem.Action.UPDATING.toString(), RollBackItem.Action.UPDATED.toString());
            Log.d((String)"InstalledBroadcastReceiver", (String)"Updated rollback action");
            return;
        }
        if (intent.getAction().equals("android.intent.action.PACKAGE_ADDED")) {
            try {
                String string2;
                PackageInfo packageInfo = context.getPackageManager().getPackageInfo(intent.getData().getEncodedSchemeSpecificPart(), 64);
                InstalledPackage installedPackage = new InstalledPackage((String)packageInfo.applicationInfo.loadLabel(context.getPackageManager()), packageInfo.packageName, packageInfo.versionCode, packageInfo.versionName, AptoideUtils.Algorithms.computeSHA1sumFromBytes(packageInfo.signatures[0].toByteArray()).toUpperCase(Locale.ENGLISH));
                database.insertInstalled(installedPackage);
                database.deleteScheduledDownloadByPackageName(intent.getData().getEncodedSchemeSpecificPart());
                BusProvider.getInstance().post(new InstalledApkEvent(installedPackage));
                if (!intent.getBooleanExtra("android.intent.extra.REPLACING", false) && (string2 = database.getNotConfirmedRollbackAction(packageInfo.packageName)) != null) {
                    if (string2.equals(RollBackItem.Action.INSTALLING.toString())) {
                        database.confirmRollBackAction(packageInfo.packageName, string2, RollBackItem.Action.INSTALLED.toString());
                        Log.d((String)"InstalledBroadcastReceiver", (String)"Installed rollback action");
                    } else if (string2.equals(RollBackItem.Action.DOWNGRADING.toString())) {
                        database.confirmRollBackAction(packageInfo.packageName, string2, RollBackItem.Action.DOWNGRADED.toString());
                        Log.d((String)"InstalledBroadcastReceiver", (String)"Downgraded rollback action");
                    }
                }
                BusProvider.getInstance().post(new InstalledApkEvent(installedPackage));
                if (Build.VERSION.SDK_INT < 11 || context.getPackageManager().getInstallerPackageName(intent.getData().getEncodedSchemeSpecificPart()) != null) return;
                context.getPackageManager().setInstallerPackageName(intent.getData().getEncodedSchemeSpecificPart(), "cm.aptoide.pt.dev");
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
        if (!intent.getAction().equals("android.intent.action.PACKAGE_REMOVED")) return;
        String string3 = intent.getData().getEncodedSchemeSpecificPart();
        database.deleteInstalledApk(string3);
        BusProvider.getInstance().post(new UnInstalledApkEvent(string3));
        if (intent.getBooleanExtra("android.intent.extra.REPLACING", false)) return;
        String string4 = database.getNotConfirmedRollbackAction(string3);
        if (string4 != null && string4.equals(RollBackItem.Action.UNINSTALLING.toString())) {
            database.confirmRollBackAction(string3, string4, RollBackItem.Action.UNINSTALLED.toString());
            Log.d((String)"InstalledBroadcastReceiver", (String)"unistalled rollback action");
        }
        BusProvider.getInstance().post(new UnInstalledApkEvent(intent.getData().getEncodedSchemeSpecificPart()));
    }
}

