/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import cm.aptoide.ptdev.database.Database;
import cm.aptoide.ptdev.model.InstalledPackage;
import cm.aptoide.ptdev.utils.AptoideUtils;
import java.util.List;
import java.util.Locale;

public class InstalledAppsHelper {
    public static void sync(SQLiteDatabase sQLiteDatabase, Context context) {
        Database database = new Database(sQLiteDatabase);
        List list = context.getPackageManager().getInstalledPackages(64);
        List<InstalledPackage> list2 = database.getStartupInstalled();
        for (PackageInfo packageInfo : list) {
            try {
                InstalledPackage installedPackage = new InstalledPackage((String)packageInfo.applicationInfo.loadLabel(context.getPackageManager()), packageInfo.packageName, packageInfo.versionCode, packageInfo.versionName, AptoideUtils.Algorithms.computeSHA1sumFromBytes(packageInfo.signatures[0].toByteArray()).toUpperCase(Locale.ENGLISH));
                if (list2.contains(installedPackage)) continue;
                Log.d((String)"Aptoide-InstalledSync", (String)("Adding " + installedPackage.getPackage_name() + "-" + installedPackage.getVersion_name()));
                database.insertInstalled(installedPackage);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

