/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev;

import android.content.Context;
import android.database.Cursor;
import android.os.Bundle;
import android.support.v7.app.ActionBarActivity;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import cm.aptoide.ptdev.Aptoide;
import cm.aptoide.ptdev.R;
import cm.aptoide.ptdev.database.Database;
import com.nostra13.universalimageloader.core.ImageLoader;
import java.util.ArrayList;
import java.util.Iterator;

public class ExcludedUpdatesActivity
extends ActionBarActivity {
    private ArrayAdapter<ExcludedUpdate> adapter;
    private Database db;
    ArrayList<ExcludedUpdate> excludedUpdates = new ArrayList();
    private ListView lv;
    private TextView tv_no_excluded_downloads;

    public ExcludedUpdatesActivity() {
        this.db = new Database(Aptoide.getDb());
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private boolean isAllChecked() {
        if (this.adapter.isEmpty()) {
            return false;
        }
        Iterator<ExcludedUpdate> iterator = this.excludedUpdates.iterator();
        do {
            if (!iterator.hasNext()) return false;
        } while (!iterator.next().checked);
        return true;
    }

    private void redraw() {
        Cursor cursor = this.db.getExcludedApks();
        this.excludedUpdates.clear();
        cursor.moveToFirst();
        while (!cursor.isAfterLast()) {
            ExcludedUpdate excludedUpdate = new ExcludedUpdate(cursor.getString(cursor.getColumnIndex("name")), cursor.getString(cursor.getColumnIndex("package_name")), cursor.getString(cursor.getColumnIndex("iconpath")), cursor.getInt(cursor.getColumnIndex("vercode")));
            this.excludedUpdates.add(excludedUpdate);
            cursor.moveToNext();
        }
        cursor.close();
        this.adapter.notifyDataSetChanged();
        Log.d((String)"ExcludedUpdatesActivity", (String)("excluded updates: " + this.excludedUpdates.toString()));
        if (!this.adapter.isEmpty()) {
            this.tv_no_excluded_downloads.setVisibility(8);
            return;
        }
        this.tv_no_excluded_downloads.setVisibility(0);
    }

    @Override
    public void onCreate(Bundle bundle) {
        Aptoide.getThemePicker().setAptoideTheme((Context)this);
        super.onCreate(bundle);
        this.setContentView(R.layout.page_excluded_uploads);
        this.getSupportActionBar().setHomeButtonEnabled(true);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getSupportActionBar().setDisplayShowTitleEnabled(true);
        this.getSupportActionBar().setTitle(this.getString(R.string.excluded_updates));
        this.lv = (ListView)this.findViewById(R.id.excluded_updates_list);
        this.lv.setDivider(null);
        this.tv_no_excluded_downloads = (TextView)this.findViewById(R.id.tv_no_excluded_downloads);
        this.adapter = new ArrayAdapter<ExcludedUpdate>((Context)this, 0, this.excludedUpdates){

            /*
             * Enabled aggressive block sorting
             */
            public void bindView(View view, int n2) {
                CheckBox checkBox;
                TextView textView;
                TextView textView2;
                TextView textView3;
                ImageView imageView;
                ExcludedUpdate excludedUpdate = (ExcludedUpdate)this.getItem(n2);
                if (view.getTag() == null) {
                    imageView = (ImageView)view.findViewById(R.id.app_icon);
                    textView3 = (TextView)view.findViewById(R.id.tv_name);
                    textView2 = (TextView)view.findViewById(R.id.tv_vercode);
                    textView = (TextView)view.findViewById(R.id.tv_apkid);
                    checkBox = (CheckBox)view.findViewById(R.id.cb_exclude);
                    view.setTag((Object)new ExcludedUpdatesHolder(imageView, textView3, textView, textView2, checkBox));
                    checkBox.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            CheckBox checkBox = (CheckBox)view;
                            ((ExcludedUpdate)checkBox.getTag()).setChecked(checkBox.isChecked());
                        }
                    });
                } else {
                    ExcludedUpdatesHolder excludedUpdatesHolder = (ExcludedUpdatesHolder)view.getTag();
                    checkBox = excludedUpdatesHolder.cb_exclude;
                    imageView = excludedUpdatesHolder.icon;
                    textView2 = excludedUpdatesHolder.tv_vercode;
                    textView3 = excludedUpdatesHolder.tv_name;
                    textView = excludedUpdatesHolder.tv_apkid;
                }
                checkBox.setTag((Object)excludedUpdate);
                checkBox.setChecked(checkBox.isChecked());
                ImageLoader.getInstance().displayImage(excludedUpdate.getIcon(), imageView);
                textView3.setText((CharSequence)excludedUpdate.getName());
                textView2.setText((CharSequence)("" + excludedUpdate.getVercode()));
                textView.setText((CharSequence)excludedUpdate.getApkid());
            }

            public long getItemId(int n2) {
                return n2;
            }

            /*
             * Enabled aggressive block sorting
             */
            public View getView(int n2, View view, ViewGroup viewGroup) {
                View view2 = view == null ? this.newView(viewGroup) : view;
                this.bindView(view2, n2);
                return view2;
            }

            public View newView(ViewGroup viewGroup) {
                return LayoutInflater.from((Context)this.getContext()).inflate(R.layout.row_excluded_update, null);
            }
        };
        this.redraw();
        this.lv.setAdapter(this.adapter);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.menu_excluded_updates, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onOptionsItemSelected(MenuItem menuItem) {
        int n2 = menuItem.getItemId();
        if (n2 == 16908332) {
            this.finish();
            return super.onOptionsItemSelected(menuItem);
        }
        if (n2 == R.id.home) {
            this.finish();
            return super.onOptionsItemSelected(menuItem);
        }
        if (n2 != R.id.menu_remove) return super.onOptionsItemSelected(menuItem);
        if (!this.isAllChecked()) {
            Toast.makeText((Context)this, (int)R.string.no_excluded_updates_selected, (int)0).show();
            return super.onOptionsItemSelected(menuItem);
        }
        Iterator<ExcludedUpdate> iterator = this.excludedUpdates.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.redraw();
                return super.onOptionsItemSelected(menuItem);
            }
            ExcludedUpdate excludedUpdate = iterator.next();
            if (!excludedUpdate.checked) continue;
            this.db.deleteFromExcludeUpdate(excludedUpdate.apkid, excludedUpdate.vercode);
        }
    }

    private static class ExcludedUpdate {
        private String apkid = "";
        private boolean checked = false;
        private String icon;
        private String name = "";
        private int vercode = 0;

        public ExcludedUpdate(String string2, String string3, String string4, int n2) {
            this.name = string2;
            this.apkid = string3;
            this.vercode = n2;
            this.icon = string4;
        }

        public String getApkid() {
            return this.apkid;
        }

        public String getIcon() {
            return this.icon;
        }

        public String getName() {
            return this.name;
        }

        public int getVercode() {
            return this.vercode;
        }

        public boolean isChecked() {
            return this.checked;
        }

        public void setChecked(boolean bl2) {
            this.checked = bl2;
        }

        public String toString() {
            return "Name: " + this.name + ", vercode: " + this.vercode + ", apkid: " + this.apkid;
        }
    }

    private static class ExcludedUpdatesHolder {
        public CheckBox cb_exclude;
        public ImageView icon;
        public TextView tv_apkid;
        public TextView tv_name;
        public TextView tv_vercode;

        public ExcludedUpdatesHolder(ImageView imageView, TextView textView, TextView textView2, TextView textView3, CheckBox checkBox) {
            this.cb_exclude = checkBox;
            this.icon = imageView;
            this.tv_name = textView;
            this.tv_apkid = textView2;
            this.tv_vercode = textView3;
        }
    }
}

