/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.AsyncTask;
import android.util.Log;
import android.view.ContextThemeWrapper;
import cm.aptoide.ptdev.Aptoide;
import cm.aptoide.ptdev.R;
import cm.aptoide.ptdev.utils.AptoideUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.TimeoutException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;

public class AutoUpdate
extends AsyncTask<Void, Void, AutoUpdateInfo> {
    private final String TMP_UPDATE_FILE = Aptoide.getConfiguration().getPathCache() + "aptoideUpdate.apk";
    private Activity activity;
    private final String url = Aptoide.getConfiguration().getAutoUpdateUrl();

    public AutoUpdate(Activity activity) {
        this.activity = activity;
    }

    private void doUpdateSelf() {
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        intent.setFlags(0x10000000);
        intent.setDataAndType(Uri.parse((String)("file://" + this.TMP_UPDATE_FILE)), "application/vnd.android.package-archive");
        this.activity.startActivityForResult(intent, 99);
    }

    private void requestUpdateSelf(final AutoUpdateInfo autoUpdateInfo) {
        Activity activity = this.activity;
        Activity activity2 = this.activity;
        int[] nArray = new int[]{R.attr.alertDialog};
        AlertDialog alertDialog = new AlertDialog.Builder((Context)new ContextThemeWrapper((Context)activity, activity2.obtainStyledAttributes(nArray).getResourceId(0, 0))).create();
        alertDialog.setTitle(this.activity.getText(R.string.update_self_title));
        alertDialog.setIcon(Aptoide.getConfiguration().getIcon());
        Activity activity3 = this.activity;
        int n2 = R.string.update_self_msg;
        Object[] objectArray = new Object[]{Aptoide.getConfiguration().getMarketName()};
        alertDialog.setMessage((CharSequence)activity3.getString(n2, objectArray));
        alertDialog.setCancelable(false);
        alertDialog.setButton(-1, (CharSequence)this.activity.getString(17039379), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n2) {
                DownloadSelfUpdate downloadSelfUpdate = new DownloadSelfUpdate();
                Object[] objectArray = new AutoUpdateInfo[]{autoUpdateInfo};
                downloadSelfUpdate.execute(objectArray);
            }
        });
        alertDialog.setButton(-2, (CharSequence)this.activity.getString(17039369), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n2) {
                dialogInterface.dismiss();
            }
        });
        alertDialog.show();
    }

    protected AutoUpdateInfo doInBackground(Void ... voidArray) {
        try {
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            AutoUpdateHandler autoUpdateHandler = new AutoUpdateHandler();
            Log.d((String)"TAG", (String)("Requesting auto-update from " + this.url));
            HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(this.url).openConnection();
            httpURLConnection.setConnectTimeout(10000);
            httpURLConnection.setReadTimeout(10000);
            sAXParser.parse(httpURLConnection.getInputStream(), (DefaultHandler)autoUpdateHandler);
            AutoUpdateInfo autoUpdateInfo = autoUpdateHandler.getAutoUpdateInfo();
            return autoUpdateInfo;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            return null;
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            return null;
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void onPostExecute(AutoUpdateInfo autoUpdateInfo) {
        super.onPostExecute((Object)autoUpdateInfo);
        if (autoUpdateInfo == null) return;
        String string2 = this.activity.getPackageName();
        int n2 = autoUpdateInfo.vercode;
        try {
            if (n2 <= this.activity.getPackageManager().getPackageInfo((String)string2, (int)0).versionCode && !Aptoide.getConfiguration().isAlwaysUpdate()) return;
            this.requestUpdateSelf(autoUpdateInfo);
            return;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            return;
        }
    }

    private class AutoUpdateHandler
    extends DefaultHandler2 {
        AutoUpdateInfo info = new AutoUpdateInfo();
        private StringBuilder sb = new StringBuilder();

        private AutoUpdateHandler() {
        }

        private AutoUpdateInfo getAutoUpdateInfo() {
            return this.info;
        }

        @Override
        public void characters(char[] cArray, int n2, int n3) throws SAXException {
            super.characters(cArray, n2, n3);
            this.sb.append(cArray, n2, n3);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void endElement(String string2, String string3, String string4) throws SAXException {
            super.endElement(string2, string3, string4);
            if (string3.equals("versionCode")) {
                this.info.vercode = Integer.parseInt(this.sb.toString());
                return;
            } else {
                if (string3.equals("uri")) {
                    this.info.path = this.sb.toString();
                    return;
                }
                if (!string3.equals("md5")) return;
                this.info.md5 = this.sb.toString();
                return;
            }
        }

        @Override
        public void startElement(String string2, String string3, String string4, Attributes attributes) throws SAXException {
            super.startElement(string2, string3, string4, attributes);
            this.sb.setLength(0);
        }
    }

    static class AutoUpdateInfo {
        String md5;
        String path;
        int vercode;

        AutoUpdateInfo() {
        }
    }

    private class DownloadSelfUpdate
    extends AsyncTask<AutoUpdateInfo, Void, Void> {
        private final ProgressDialog dialog;
        String latestVersionUri;
        String referenceMd5;

        private DownloadSelfUpdate() {
            this.dialog = new ProgressDialog((Context)AutoUpdate.this.activity);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected Void doInBackground(AutoUpdateInfo ... autoUpdateInfoArray) {
            HttpResponse httpResponse;
            FileOutputStream fileOutputStream;
            try {
                this.retrieveUpdateParameters(autoUpdateInfoArray[0]);
                File file = new File(AutoUpdate.this.TMP_UPDATE_FILE);
                if (file.exists()) {
                    file.delete();
                }
                fileOutputStream = new FileOutputStream(AutoUpdate.this.TMP_UPDATE_FILE);
                DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
                HttpGet httpGet = new HttpGet(this.latestVersionUri);
                httpResponse = defaultHttpClient.execute((HttpUriRequest)httpGet);
                if (httpResponse == null) {
                    Log.d((String)"Aptoide", (String)"Problem in network... retry...");
                    httpResponse = defaultHttpClient.execute((HttpUriRequest)httpGet);
                    if (httpResponse == null) {
                        Log.d((String)"Aptoide", (String)"Major network exception... Exiting!");
                        fileOutputStream.close();
                        throw new TimeoutException();
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Log.d((String)"Aptoide-Auto-Update", (String)"Update connection failed!  Keeping current version.");
                return null;
            }
            {
                if (httpResponse.getStatusLine().getStatusCode() == 401) {
                    fileOutputStream.close();
                    throw new TimeoutException();
                }
                InputStream inputStream = httpResponse.getEntity().getContent();
                byte[] byArray = new byte[8096];
                int n2 = inputStream.read(byArray, 0, 8096);
                while (true) {
                    if (n2 == -1) {
                        Log.d((String)"Aptoide", (String)"Download done!");
                        fileOutputStream.flush();
                        fileOutputStream.close();
                        inputStream.close();
                        return null;
                    }
                    fileOutputStream.write(byArray, 0, n2);
                    n2 = inputStream.read(byArray, 0, 8096);
                }
            }
        }

        protected void onPostExecute(Void void_) {
            if (this.dialog.isShowing()) {
                this.dialog.dismiss();
            }
            super.onPostExecute((Object)void_);
            if (this.referenceMd5 != null) {
                try {
                    File file = new File(AutoUpdate.this.TMP_UPDATE_FILE);
                    if (this.referenceMd5.equalsIgnoreCase(AptoideUtils.Algorithms.md5Calc(file))) {
                        AutoUpdate.this.doUpdateSelf();
                        return;
                    }
                    Log.d((String)"Aptoide", (String)(this.referenceMd5 + " VS " + AptoideUtils.Algorithms.md5Calc(file)));
                    throw new Exception(this.referenceMd5 + " VS " + AptoideUtils.Algorithms.md5Calc(file));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Log.d((String)"Aptoide-Auto-Update", (String)"Update package checksum failed!  Keeping current version.");
                    if (this.dialog.isShowing()) {
                        this.dialog.dismiss();
                    }
                    super.onPostExecute((Object)void_);
                }
            }
        }

        protected void onPreExecute() {
            this.dialog.setMessage((CharSequence)AutoUpdate.this.activity.getString(R.string.retrieving_update));
            this.dialog.show();
            super.onPreExecute();
        }

        void retrieveUpdateParameters(AutoUpdateInfo autoUpdateInfo) {
            try {
                this.latestVersionUri = autoUpdateInfo.path;
                this.referenceMd5 = autoUpdateInfo.md5;
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Log.d((String)"Aptoide-Auto-Update", (String)"Update connection failed!  Keeping current version.");
                return;
            }
        }
    }
}

