/*
 * Decompiled with CFR 0.152.
 */
package cm.aptoide.ptdev;

import android.app.Application;
import android.content.Context;
import android.content.pm.PackageManager;
import android.database.sqlite.SQLiteDatabase;
import android.preference.PreferenceManager;
import android.util.Log;
import cm.aptoide.ptdev.AptoideThemePicker;
import cm.aptoide.ptdev.R;
import cm.aptoide.ptdev.configuration.AptoideConfiguration;
import cm.aptoide.ptdev.database.DatabaseHelper;
import cm.aptoide.ptdev.preferences.ManagerPreferences;
import cm.aptoide.ptdev.utils.AptoideUtils;
import com.nostra13.universalimageloader.cache.disc.impl.UnlimitedDiscCache;
import com.nostra13.universalimageloader.cache.disc.naming.FileNameGenerator;
import com.nostra13.universalimageloader.core.DisplayImageOptions;
import com.nostra13.universalimageloader.core.ImageLoader;
import com.nostra13.universalimageloader.core.ImageLoaderConfiguration;
import com.nostra13.universalimageloader.core.download.BaseImageDownloader;
import com.nostra13.universalimageloader.core.download.ImageDownloader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.acra.ACRA;
import org.acra.ACRAConfiguration;
import org.acra.ACRAConfigurationException;
import org.acra.ReportField;
import org.acra.ReportingInteractionMode;
import org.acra.annotation.ReportsCrashes;
import org.acra.sender.HttpSender;

@ReportsCrashes(formKey="", formUri="http://acra.aptoide.com/acra-aptoide/_design/acra-storage/_update/report", httpMethod=HttpSender.Method.PUT, reportType=HttpSender.Type.JSON)
public class Aptoide
extends Application {
    public static final boolean DEBUG_MODE = Log.isLoggable((String)"APTOIDE", (int)3);
    public static boolean IS_SYSTEM;
    private static AptoideConfiguration configuration;
    private static Context context;
    private static DatabaseHelper db;
    private static AptoideThemePicker themePicker;
    private static boolean webInstallServiceRunning;

    static {
        configuration = null;
    }

    public static AptoideConfiguration getConfiguration() {
        return configuration;
    }

    public static Context getContext() {
        return context;
    }

    public static SQLiteDatabase getDb() {
        return db.getWritableDatabase();
    }

    public static AptoideThemePicker getThemePicker() {
        return themePicker;
    }

    public static boolean isUpdate() throws PackageManager.NameNotFoundException {
        int n2 = PreferenceManager.getDefaultSharedPreferences((Context)Aptoide.getContext()).getInt("version", 0);
        int n3 = Aptoide.getContext().getPackageManager().getPackageInfo((String)Aptoide.getContext().getPackageName(), (int)0).versionCode;
        boolean bl2 = false;
        if (n2 < n3) {
            bl2 = true;
        }
        return bl2;
    }

    public static boolean isWebInstallServiceRunning() {
        return webInstallServiceRunning;
    }

    public static void setWebInstallServiceRunning(boolean bl2) {
        webInstallServiceRunning = bl2;
    }

    public void bootImpl(ManagerPreferences managerPreferences) {
    }

    public AptoideConfiguration getAptoideConfiguration() {
        return new AptoideConfiguration();
    }

    public AptoideThemePicker getNewThemePicker() {
        return new AptoideThemePicker();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onCreate() {
        super.onCreate();
        context = this.getApplicationContext();
        try {
            int n2 = 1 & this.getPackageManager().getApplicationInfo((String)this.getPackageName(), (int)0).flags;
            boolean bl2 = false;
            if (n2 == 1) {
                bl2 = true;
            }
            IS_SYSTEM = bl2;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
        }
        ACRA.init(this);
        ACRAConfiguration aCRAConfiguration = ACRA.getNewDefaultConfig(this);
        try {
            aCRAConfiguration.setMode(ReportingInteractionMode.TOAST);
            ReportField[] reportFieldArray = new ReportField[]{ReportField.APP_VERSION_CODE, ReportField.APP_VERSION_NAME, ReportField.PACKAGE_NAME, ReportField.BRAND, ReportField.PRODUCT, ReportField.ANDROID_VERSION, ReportField.PHONE_MODEL, ReportField.STACK_TRACE, ReportField.LOGCAT, ReportField.REPORT_ID, ReportField.BUILD};
            aCRAConfiguration.setCustomReportContent(reportFieldArray);
        }
        catch (ACRAConfigurationException aCRAConfigurationException) {
            aCRAConfigurationException.printStackTrace();
        }
        aCRAConfiguration.setResDialogText(R.string.crash_text);
        ACRA.setConfig(aCRAConfiguration);
        db = DatabaseHelper.getInstance(this.getApplicationContext());
        this.setConfiguration(this.getAptoideConfiguration());
        ManagerPreferences managerPreferences = new ManagerPreferences((Context)this);
        this.bootImpl(managerPreferences);
        this.setThemePicker(this.getNewThemePicker());
        DisplayImageOptions displayImageOptions = new DisplayImageOptions.Builder().cacheInMemory(true).cacheOnDisc(true).resetViewBeforeLoading(true).showStubImage(R.drawable.icon_non_available).build();
        FileNameGenerator fileNameGenerator = new FileNameGenerator(){

            @Override
            public String generate(String string2) {
                if (string2 != null) {
                    return string2.substring(1 + string2.lastIndexOf(47));
                }
                return null;
            }
        };
        ImageLoaderConfiguration imageLoaderConfiguration = new ImageLoaderConfiguration.Builder(this.getApplicationContext()).discCache(new UnlimitedDiscCache(new File(Aptoide.getConfiguration().getPathCacheIcons()), fileNameGenerator)).imageDownloader(new ImageDownloaderWithPermissions(Aptoide.getContext(), managerPreferences)).defaultDisplayImageOptions(displayImageOptions).build();
        ImageLoader.getInstance().init(imageLoaderConfiguration);
    }

    public void setConfiguration(AptoideConfiguration aptoideConfiguration) {
        configuration = aptoideConfiguration;
    }

    public void setThemePicker(AptoideThemePicker aptoideThemePicker) {
        themePicker = aptoideThemePicker;
    }

    public static class ImageDownloaderWithPermissions
    extends BaseImageDownloader {
        public static final int DEFAULT_HTTP_CONNECT_TIMEOUT = 5000;
        public static final int DEFAULT_HTTP_READ_TIMEOUT = 10000;
        private int connectTimeout;
        private ManagerPreferences managerPreferences;
        private int readTimeout;

        public ImageDownloaderWithPermissions(Context context, int n2, int n3) {
            super(context, n2, n3);
            this.connectTimeout = n2;
            this.readTimeout = n3;
        }

        public ImageDownloaderWithPermissions(Context context, ManagerPreferences managerPreferences) {
            this(context, 5000, 10000);
            this.managerPreferences = managerPreferences;
        }

        @Override
        public InputStream getStream(String string2, Object object) throws IOException {
            boolean bl2 = AptoideUtils.NetworkUtils.isPermittedConnectionAvailable(this.context, this.managerPreferences.getIconDownloadPermissions());
            switch (ImageDownloader.Scheme.ofUri(string2)) {
                default: {
                    return this.getStreamFromOtherSource(string2, object);
                }
                case HTTP: 
                case HTTPS: {
                    if (bl2) {
                        return this.getStreamFromNetwork(string2, object);
                    }
                }
                case FILE: {
                    return this.getStreamFromFile(string2, object);
                }
                case CONTENT: {
                    return this.getStreamFromContent(string2, object);
                }
                case ASSETS: {
                    return this.getStreamFromAssets(string2, object);
                }
                case DRAWABLE: 
            }
            return this.getStreamFromDrawable(string2, object);
        }
    }
}

